/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.Defined_Reference;
import org.eclipse.titan.designer.AST.ASN1.values.RelativeObjectIdentifier_Value;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.ObjectIdentifier_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ObjectIdentifierComponent
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private Identifier name;
    private IValue number;
    private IValue definedValue;
    private Location location = NULL_Location.INSTANCE;
    private static final Nameform[] NAMES_ROOT = new Nameform[]{new Nameform("itu__t", 0), new Nameform("ccitt", 0), new Nameform("iso", 1), new Nameform("joint__iso__itu__t", 2), new Nameform("joint__iso__ccitt", 2)};
    private static final Nameform[] NAMES_ITU = new Nameform[]{new Nameform("recommendation", 0), new Nameform("question", 1), new Nameform("administration", 2), new Nameform("network__operator", 3), new Nameform("identified__organization", 4), new Nameform("r__recommendation", 5)};
    private static final Nameform[] NAMES_ISO = new Nameform[]{new Nameform("standard", 0), new Nameform("regisztration__authority", 1), new Nameform("member__body", 2), new Nameform("identified__organization", 3)};
    private static final Nameform[] NAMES_JOINT = new Nameform[]{new Nameform("presentation", 0), new Nameform("asn1", 1), new Nameform("association__control", 2), new Nameform("reliable__transfer", 3), new Nameform("remote__operations", 4), new Nameform("ds", 5), new Nameform("directory", 5), new Nameform("mhs", 6), new Nameform("mhs__motis", 6), new Nameform("ccr", 7), new Nameform("oda", 8), new Nameform("ms", 9), new Nameform("osi__management", 9), new Nameform("transaction__processing", 10), new Nameform("dor", 11), new Nameform("distinguished__object__reference", 11), new Nameform("reference__data__transfer", 12), new Nameform("network__layer", 13), new Nameform("network__layer__management", 13), new Nameform("transport__layer", 14), new Nameform("transport__layer__management", 14), new Nameform("datalink__layer", 15), new Nameform("datalink__layer__management", 15), new Nameform("datalink__layer__management__information", 15), new Nameform("country", 16), new Nameform("registration__procedures", 17), new Nameform("registration__procedure", 17), new Nameform("physiscal__layer", 18), new Nameform("physical__layer__management", 18), new Nameform("mheg", 19), new Nameform("genericULS", 20), new Nameform("generic__upper__layer__security", 20), new Nameform("guls", 20), new Nameform("transport__layer__security__protocol", 21), new Nameform("network__layer__security__protocol", 22), new Nameform("international__organisations", 23), new Nameform("internationalRA", 23), new Nameform("sios", 24), new Nameform("uuid", 25), new Nameform("odp", 26), new Nameform("upu", 40)};

    public ObjectIdentifierComponent(Identifier name, IValue number) {
        this.name = name;
        this.number = number;
        if (number != null) {
            number.setFullNameParent(this);
        }
    }

    public ObjectIdentifierComponent(IValue definedValue) {
        this.definedValue = definedValue;
        if (definedValue != null) {
            definedValue.setFullNameParent(this);
        }
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.definedValue != null) {
            this.definedValue.setMyScope(scope);
        }
        if (this.number != null) {
            this.number.setMyScope(scope);
        }
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        if (this.number != null) {
            builder.append(this.number.createStringRepresentation());
        } else if (this.name != null) {
            builder.append(this.name.getDisplayName());
        } else if (this.definedValue != null) {
            builder.append(this.definedValue.createStringRepresentation());
        } else {
            builder.append("<unknown OID component>");
        }
        return builder.toString();
    }

    public void getOidComponents(List<Integer> components) {
        if (this.definedValue != null) {
            if (IValue.Value_type.OBJECTID_VALUE.equals((Object)this.definedValue.getValuetype())) {
                ((ObjectIdentifier_Value)this.definedValue).getOidComponents(components);
            }
        } else if (this.number != null && IValue.Value_type.INTEGER_VALUE.equals((Object)this.number.getValuetype())) {
            components.add(((Integer_Value)this.number).intValue());
        }
    }

    public oidState_type checkOID(CompilationTimeStamp timestamp, IReferenceChain refChain, Value parent, oidState_type state) {
        if (this.name != null && this.number != null) {
            return this.checkNameAndNumberForm(timestamp, state);
        }
        if (this.name != null) {
            return this.checkNameForm(timestamp, parent, refChain, state);
        }
        if (this.number != null) {
            return this.checkNumberFormOID(timestamp, state);
        }
        return this.checkDefdValueOID(timestamp, refChain, state);
    }

    public void checkROID(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.number != null) {
            this.checkNumberFormROID(timestamp);
        } else if (this.definedValue != null) {
            this.checkDefdValueROID(timestamp, refChain);
        }
    }

    private oidState_type checkNameForm(CompilationTimeStamp timestamp, Value parent, IReferenceChain refChain, oidState_type state) {
        String nameString = this.name.getName();
        oidState_type actualState = state;
        int value = -1;
        switch (state) {
            case START: {
                if ("itu__t".equals(nameString) || "ccitt".equals(nameString)) {
                    actualState = oidState_type.ITU;
                    value = 0;
                    break;
                }
                if ("itu__r".equals(nameString)) {
                    this.location.reportSemanticWarning(MessageFormat.format("Identifier `{0}'' should not be used as NameForm", this.name.getDisplayName()));
                    actualState = oidState_type.ITU;
                    value = 0;
                    break;
                }
                if ("iso".equals(nameString)) {
                    actualState = oidState_type.ISO;
                    value = 1;
                    break;
                }
                if (!"joint__iso__itu__t".equals(nameString) && !"joint__iso__ccitt".equals(nameString)) break;
                actualState = oidState_type.JOINT;
                value = 2;
                break;
            }
            case ITU: {
                int i;
                block11: for (i = 0; i < NAMES_ITU.length; ++i) {
                    if (!nameString.equals(ObjectIdentifierComponent.NAMES_ITU[i].name)) continue;
                    value = ObjectIdentifierComponent.NAMES_ITU[i].value;
                    switch (value) {
                        case 0: {
                            actualState = oidState_type.ITU_REC;
                            continue block11;
                        }
                        case 5: {
                            this.location.reportSemanticWarning(MessageFormat.format("Identifier `{0}'' should not be used as NumberForm", this.name.getDisplayName()));
                            actualState = oidState_type.LATER;
                            continue block11;
                        }
                        default: {
                            actualState = oidState_type.LATER;
                        }
                    }
                }
                break;
            }
            case ISO: {
                int i;
                for (i = 0; i < NAMES_ISO.length; ++i) {
                    if (!nameString.equals(ObjectIdentifierComponent.NAMES_ISO[i].name)) continue;
                    value = ObjectIdentifierComponent.NAMES_ISO[i].value;
                    actualState = oidState_type.LATER;
                }
                break;
            }
            case JOINT: {
                int i;
                for (i = 0; i < NAMES_JOINT.length; ++i) {
                    if (!nameString.equals(ObjectIdentifierComponent.NAMES_JOINT[i].name)) continue;
                    value = ObjectIdentifierComponent.NAMES_JOINT[i].value;
                    actualState = oidState_type.LATER;
                    this.location.reportSemanticWarning(MessageFormat.format("Identifier `{0}'' should not be used as NumberForm", this.name.getDisplayName()));
                }
                break;
            }
            case ITU_REC: {
                char c;
                if (nameString.length() != 1 || (c = nameString.charAt(0)) < 'a' || c > 'z') break;
                value = c - 97 + 1;
                actualState = oidState_type.LATER;
                break;
            }
        }
        if (value < 0) {
            ArrayList<ISubReference> newSubreferences = new ArrayList<ISubReference>();
            newSubreferences.add(new FieldSubReference(this.name));
            Reference reference = parent.isAsn() ? new Defined_Reference(null, newSubreferences) : new Reference(null, newSubreferences);
            Referenced_Value newDefinedValue = new Referenced_Value(reference);
            newDefinedValue.setLocation(this.getLocation());
            ObjectIdentifierComponent component = new ObjectIdentifierComponent(newDefinedValue);
            component.setFullNameParent(this);
            component.setMyScope(parent.getMyScope());
            actualState = component.checkDefdValueOID(timestamp, refChain, actualState);
        }
        return actualState;
    }

    private oidState_type checkDefdValueOID(CompilationTimeStamp timestamp, IReferenceChain refChain, oidState_type state) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue value = this.definedValue.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        if (value.getIsErroneous(timestamp)) {
            return oidState_type.LATER;
        }
        switch (value.getValuetype()) {
            case INTEGER_VALUE: {
                ObjectIdentifierComponent temp = new ObjectIdentifierComponent(null, this.definedValue);
                temp.setFullNameParent(this);
                temp.setMyScope(this.myScope);
                return temp.checkNumberFormOID(timestamp, state);
            }
            case OBJECTID_VALUE: {
                if (!oidState_type.START.equals((Object)state)) {
                    this.definedValue.getLocation().reportSemanticError("INTEGER or RELATIVE-OID value was expected");
                }
                ((ObjectIdentifier_Value)value).checkOID(timestamp, refChain);
                return oidState_type.LATER;
            }
            case RELATIVEOBJECTIDENTIFIER_VALUE: {
                switch (state) {
                    case ITU_REC: {
                        return oidState_type.LATER;
                    }
                    case LATER: {
                        return oidState_type.LATER;
                    }
                }
                this.definedValue.getLocation().reportSemanticError(MessageFormat.format("RELATIVE-OID value cannot be used as the {0} component of an OBJECTIDENTIFIER value", oidState_type.START.equals((Object)state) ? "first" : "second"));
                return oidState_type.LATER;
            }
        }
        if (oidState_type.START.equals((Object)state)) {
            this.definedValue.getLocation().reportSemanticError("INTEGER or OBJECT IDENTIFIER value was expected for the first component");
        } else {
            this.definedValue.getLocation().reportSemanticError("INTEGER or RELATIVE-OID value was expected");
        }
        return oidState_type.LATER;
    }

    private void checkDefdValueROID(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue value = this.definedValue.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        if (value.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case INTEGER_VALUE: {
                ObjectIdentifierComponent temp = new ObjectIdentifierComponent(null, this.definedValue);
                temp.setFullNameParent(this);
                temp.setMyScope(this.myScope);
                temp.checkNumberFormROID(timestamp);
                break;
            }
            case RELATIVEOBJECTIDENTIFIER_VALUE: {
                ((RelativeObjectIdentifier_Value)value).checkROID(timestamp, referenceChain);
                break;
            }
            default: {
                this.definedValue.getLocation().reportSemanticError("INTEGER or RELATIVE-OID value was expected");
            }
        }
    }

    private oidState_type checkNumberFormOID(CompilationTimeStamp timestamp, oidState_type state) {
        if (this.number == null) {
            return oidState_type.LATER;
        }
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = this.number.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        if (last.getIsErroneous(timestamp)) {
            return oidState_type.LATER;
        }
        if (!IValue.Value_type.INTEGER_VALUE.equals((Object)last.getValuetype())) {
            this.number.getLocation().reportSemanticError("INTEGER value was expected in the number form");
            return oidState_type.LATER;
        }
        BigInteger value = ((Integer_Value)last).getValueValue();
        if (value.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == 1) {
            this.number.getLocation().reportSemanticError(MessageFormat.format("An integer value less then `{0}'' was expected in the number form instead of `{1}''", Integer.MAX_VALUE, value));
            return oidState_type.LATER;
        }
        int value2 = value.intValue();
        switch (state) {
            case START: {
                switch (value2) {
                    case 0: {
                        return oidState_type.ITU;
                    }
                    case 1: {
                        return oidState_type.ISO;
                    }
                    case 2: {
                        return oidState_type.JOINT;
                    }
                }
                this.number.getLocation().reportSemanticError(MessageFormat.format("The value of first OBJECT IDENTIFIER component must be between 0 and 2 instead of {0}", value2));
                return oidState_type.LATER;
            }
            case ITU: 
            case ISO: {
                if (value2 < 0 || value2 > 38) {
                    this.number.getLocation().reportSemanticError(MessageFormat.format("The value of second OBJECT IDENTIFIER component must be between 0 and 39 instead of {0}", value2));
                }
                if (oidState_type.ITU.equals((Object)state) && value2 == 0) {
                    return oidState_type.ITU_REC;
                }
                return oidState_type.LATER;
            }
        }
        if (value2 < 0) {
            this.number.getLocation().reportSemanticError(MessageFormat.format("A non-negative integer value was expected instead of {0}", value2));
        }
        return oidState_type.LATER;
    }

    private void checkNumberFormROID(CompilationTimeStamp timestamp) {
        if (this.number == null) {
            return;
        }
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = this.number.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        if (last.getIsErroneous(timestamp)) {
            return;
        }
        if (!IValue.Value_type.INTEGER_VALUE.equals((Object)last.getValuetype())) {
            this.number.getLocation().reportSemanticError("INTEGER value was expected in the number form");
            return;
        }
        BigInteger value = ((Integer_Value)last).getValueValue();
        if (value.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == 1) {
            this.number.getLocation().reportSemanticError(MessageFormat.format("An integer value less then `{0}'' was expected in the number form instead of `{1}''", Integer.MAX_VALUE, value));
            return;
        }
        if (value.compareTo(BigInteger.ZERO) == -1) {
            this.number.getLocation().reportSemanticError(MessageFormat.format("A non-negative integer value was expected instead of {0}", value));
        }
    }

    private oidState_type checkNameAndNumberForm(CompilationTimeStamp timestamp, oidState_type state) {
        oidState_type actualState = state;
        actualState = this.checkNumberFormOID(timestamp, actualState);
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = this.number.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        if (last.getIsErroneous(timestamp)) {
            return actualState;
        }
        if (!IValue.Value_type.INTEGER_VALUE.equals((Object)last.getValuetype())) {
            return actualState;
        }
        BigInteger value = ((Integer_Value)last).getValueValue();
        if (value.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == 1) {
            return actualState;
        }
        String tempName = this.name.getName();
        int tempInt = value.intValue();
        switch (state) {
            case START: {
                if (this.isValidNameForNumber(tempName, tempInt, NAMES_ROOT)) break;
                this.number.getLocation().reportSemanticWarning(MessageFormat.format("Identifier {0} was expected instead of `{1}'' for number {2} in the NameAndNumberForm as the first OBJECT IDENTIFIER component", this.getExpectedNameForNumber(tempInt, this.number.isAsn(), NAMES_ROOT), this.name.getDisplayName(), value));
                break;
            }
            case ITU: {
                if (this.isValidNameForNumber(tempName, tempInt, NAMES_ITU)) break;
                this.number.getLocation().reportSemanticWarning(MessageFormat.format("Identifier {0} was expected instead of `{1}'' for number {2} in the NameAndNumberForm as the second OBJECT IDENTIFIER component", this.getExpectedNameForNumber(tempInt, this.number.isAsn(), NAMES_ITU), this.name.getDisplayName(), value));
                break;
            }
            case ISO: {
                if (this.isValidNameForNumber(tempName, tempInt, NAMES_ISO)) break;
                this.number.getLocation().reportSemanticWarning(MessageFormat.format("Identifier {0} was expected instead of `{1}'' for number {2} in the NameAndNumberForm as the second OBJECT IDENTIFIER component", this.getExpectedNameForNumber(tempInt, this.number.isAsn(), NAMES_ISO), this.name.getDisplayName(), value));
                break;
            }
            case JOINT: {
                if (this.isValidNameForNumber(tempName, tempInt, NAMES_JOINT)) break;
                this.number.getLocation().reportSemanticWarning(MessageFormat.format("Identifier {0} was expected instead of `{1}'' for number {2} in the NameAndNumberForm as the second OBJECT IDENTIFIER component", this.getExpectedNameForNumber(tempInt, this.number.isAsn(), NAMES_JOINT), this.name.getDisplayName(), value));
                break;
            }
            case ITU_REC: {
                if (tempInt < 1 || tempInt > 26 || tempName.length() == 1 && tempName.getBytes()[0] == 97 + tempInt - 1) break;
                this.number.getLocation().reportSemanticWarning(MessageFormat.format("Identifier {0} was expected instead of `{1}'' for number {2} in the NameAndNumberForm as the third OBJECT IDENTIFIER component", 97 + tempInt - 1, this.name.getDisplayName(), value));
                break;
            }
        }
        return actualState;
    }

    private boolean isValidNameForNumber(String name, int number, Nameform[] names) {
        boolean result = true;
        for (int i = 0; i < names.length; ++i) {
            if (number != names[i].value) continue;
            if (name.equals(names[i].name)) {
                return true;
            }
            result = false;
        }
        return result;
    }

    private String getExpectedNameForNumber(int number, boolean asn1, Nameform[] names) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < names.length; ++i) {
            if (number != names[i].value) continue;
            if (i > 0) {
                builder.append(" or ");
            }
            builder.append('`');
            Identifier identifier = new Identifier(Identifier.Identifier_type.ID_NAME, names[i].name);
            if (asn1) {
                builder.append(identifier.getAsnName());
            } else {
                builder.append(identifier.getTtcnName());
            }
            builder.append('\'');
        }
        return builder.toString();
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.name != null) {
            reparser.updateLocation(this.name.getLocation());
        }
        if (this.number instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.number)).updateSyntax(reparser, false);
            reparser.updateLocation(this.number.getLocation());
        } else if (this.number != null) {
            throw new ReParseException();
        }
        if (this.definedValue instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.definedValue)).updateSyntax(reparser, false);
            reparser.updateLocation(this.definedValue.getLocation());
        } else if (this.definedValue != null) {
            throw new ReParseException();
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.name != null && !this.name.accept(v)) {
            return false;
        }
        if (this.number != null && !this.number.accept(v)) {
            return false;
        }
        return this.definedValue == null || this.definedValue.accept(v);
    }

    private static final class Nameform {
        String name;
        int value;

        public Nameform(String name, int value) {
            this.name = name;
            this.value = value;
        }
    }

    public static enum oidState_type {
        START,
        ITU,
        ISO,
        JOINT,
        ITU_REC,
        LATER;

    }
}

