/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.BridgingNamedNode;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceChainElement;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TTCN3Scope;
import org.eclipse.titan.designer.AST.TTCN3.attributes.AttributeSpecification;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ExtensionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ExtensionsAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifiers;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.VisibilityModifier;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeReferenceList;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.DefinitionContainer;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.SkeletonTemplateProposal;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Keywords;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.extensionattributeparser.ExtensionAttributeAnalyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ComponentTypeBody
extends TTCN3Scope
implements IReferenceChainElement,
ILocateableNode,
IIncrementallyUpdateable {
    private static final String FULLNAMEPART = "<extends>";
    public static final String CIRCULAREXTENSIONCHAIN = "Circular extension chain is not allowed: {0}";
    public static final String INHERITEDDEFINITIONLOCATION = "Definition `{0}'' inherited from component type `{1}'' is here";
    public static final String INHERITANCECOLLISSION = "Definition `{0}'' inherited from component type `{1}'' collides with definition inherited from `{2}''";
    public static final String LOCALINHERTANCECOLLISSION = "Local Definiton `{0}'' collides with definition inherited from component type `{1}''";
    public static final String INHERITEDLOCATION = "Inherited definition of `{0}'' is here";
    public static final String HIDINGSCOPEELEMENT = "The name of the inherited definition `{0}'' is not unique in the scope hierarchy";
    public static final String HIDDENSCOPEELEMENT = "Previous definition with identifier `{0}'' in higher scope unit is here";
    public static final String HIDINGMODULEIDENTIFIER = "Inherited definition with name `{0}'' hides a module identifier";
    public static final String MEMBERNOTVISIBLE = "The member definition `{0}'' in component type `{1}'' is not visible in this scope";
    private Location location;
    private Location commentLocation = null;
    private final Identifier identifier;
    private final ComponentTypeReferenceList extendsReferences;
    private ComponentTypeReferenceList attrExtendsReferences = new ComponentTypeReferenceList();
    private final Set<ComponentTypeBody> compatibleBodies = new HashSet<ComponentTypeBody>();
    private final DefinitionContainer definitions = new DefinitionContainer();
    private final Map<String, Definition> extendsGainedDefinitions = new HashMap<String, Definition>();
    private final Map<String, Definition> attributeGainedDefinitions = new HashMap<String, Definition>();
    private WithAttributesPath withAttributesPath;
    private Component_Type myType;
    private CompilationTimeStamp lastCompilationTimeStamp;
    private CompilationTimeStamp lastUniquenessCheck;

    public ComponentTypeBody(Identifier identifier, ComponentTypeReferenceList extendsReferences) {
        this.identifier = identifier;
        this.extendsReferences = extendsReferences;
        if (extendsReferences != null) {
            extendsReferences.setFullNameParent(this);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.definitions != null) {
            for (Definition definition : this.definitions) {
                if (definition != child) continue;
                Identifier tempIdentifier = definition.getIdentifier();
                return builder.append(".").append(tempIdentifier.getDisplayName());
            }
        } else if (this.extendsReferences != child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Component_Type getMyType() {
        return this.myType;
    }

    public void setMyType(Component_Type type) {
        this.myType = type;
    }

    public void setMyScope(Scope scope) {
        this.setParentScope(scope);
        if (this.location != null) {
            scope.addSubScope(this.location, this);
        }
        if (this.extendsReferences != null) {
            this.extendsReferences.setMyScope(scope);
        }
    }

    public void setAttributeParentPath(WithAttributesPath parent) {
        this.withAttributesPath = parent;
        for (Definition def : this.definitions) {
            def.setAttributeParentPath(parent);
        }
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getCommentLocation() {
        return this.commentLocation;
    }

    public void setCommentLocation(Location commentLocation) {
        this.commentLocation = commentLocation;
    }

    public Map<String, Definition> getDefinitionMap() {
        return this.definitions.getDefinitionMap();
    }

    public ComponentTypeReferenceList getExtensions() {
        return this.extendsReferences;
    }

    public ComponentTypeReferenceList getAttributeExtensions() {
        return this.attrExtendsReferences;
    }

    public List<Definition> getDefinitions() {
        return this.definitions.getDefinitions();
    }

    public boolean hasLocalAssignmentWithId(Identifier identifier) {
        String name;
        Definition definition;
        if (this.lastUniquenessCheck == null) {
            this.checkUniqueness(CompilationTimeStamp.getBaseTimestamp());
        }
        if ((definition = this.definitions.getDefinition(name = identifier.getName())) != null) {
            return true;
        }
        definition = this.extendsGainedDefinitions.get(name);
        if (definition != null) {
            return true;
        }
        return this.attributeGainedDefinitions.containsKey(name);
    }

    public Definition getLocalAssignmentById(Identifier identifier) {
        String name;
        Definition definition;
        if (this.lastUniquenessCheck == null) {
            this.checkUniqueness(CompilationTimeStamp.getBaseTimestamp());
        }
        if ((definition = this.definitions.getDefinition(name = identifier.getName())) != null) {
            return definition;
        }
        definition = this.extendsGainedDefinitions.get(name);
        if (definition != null) {
            if (VisibilityModifier.Public.equals((Object)definition.getVisibilityModifier())) {
                return definition;
            }
            identifier.getLocation().reportSemanticError(MessageFormat.format(MEMBERNOTVISIBLE, identifier.getDisplayName(), this.identifier.getDisplayName()));
        }
        if ((definition = this.attributeGainedDefinitions.get(name)) != null) {
            if (VisibilityModifier.Public.equals((Object)definition.getVisibilityModifier())) {
                return definition;
            }
            identifier.getLocation().reportSemanticError(MessageFormat.format(MEMBERNOTVISIBLE, identifier.getDisplayName(), this.identifier.getDisplayName()));
        }
        return null;
    }

    @Override
    public boolean hasAssignmentWithId(CompilationTimeStamp timestamp, Identifier identifier) {
        String name = identifier.getName();
        Definition definition = this.definitions.getDefinition(name);
        if (definition != null) {
            return true;
        }
        definition = this.extendsGainedDefinitions.get(name);
        if (definition != null && VisibilityModifier.Public.equals((Object)definition.getVisibilityModifier())) {
            return true;
        }
        definition = this.attributeGainedDefinitions.get(name);
        if (definition != null && VisibilityModifier.Public.equals((Object)definition.getVisibilityModifier())) {
            return true;
        }
        return super.hasAssignmentWithId(timestamp, identifier);
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference) {
        return this.getAssBySRef(timestamp, reference, null);
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference, IReferenceChain refChain) {
        String name;
        Definition definition;
        if (reference.getModuleIdentifier() != null) {
            return this.getParentScope().getAssBySRef(timestamp, reference);
        }
        if (this.lastUniquenessCheck == null) {
            this.checkUniqueness(timestamp);
        }
        if ((definition = this.definitions.getDefinition(name = reference.getId().getName())) != null) {
            return definition;
        }
        definition = this.extendsGainedDefinitions.get(name);
        if (definition != null) {
            if (VisibilityModifier.Public.equals((Object)definition.getVisibilityModifier())) {
                return definition;
            }
            reference.getLocation().reportSemanticError(MessageFormat.format(MEMBERNOTVISIBLE, reference.getId().getDisplayName(), this.identifier.getDisplayName()));
            return null;
        }
        definition = this.attributeGainedDefinitions.get(name);
        if (definition != null) {
            if (VisibilityModifier.Public.equals((Object)definition.getVisibilityModifier())) {
                return definition;
            }
            reference.getLocation().reportSemanticError(MessageFormat.format(MEMBERNOTVISIBLE, reference.getId().getDisplayName(), this.identifier.getDisplayName()));
            return null;
        }
        return this.getParentScope().getAssBySRef(timestamp, reference);
    }

    private List<ComponentTypeBody> getExtendsInheritedComponentBodies() {
        ArrayList<ComponentTypeBody> result = new ArrayList<ComponentTypeBody>();
        LinkedList<ComponentTypeBody> toBeChecked = new LinkedList<ComponentTypeBody>(this.extendsReferences.getComponentBodies());
        while (!toBeChecked.isEmpty()) {
            ComponentTypeBody body = toBeChecked.removeFirst();
            if (result.contains(body)) continue;
            result.add(body);
            for (ComponentTypeBody subBody : body.extendsReferences.getComponentBodies()) {
                if (result.contains(subBody) || toBeChecked.contains(subBody)) continue;
                toBeChecked.add(subBody);
            }
        }
        return result;
    }

    private List<ComponentTypeBody> getAttributeExtendsInheritedComponentBodies() {
        ArrayList<ComponentTypeBody> result = new ArrayList<ComponentTypeBody>();
        LinkedList<ComponentTypeBody> toBeChecked = new LinkedList<ComponentTypeBody>(this.attrExtendsReferences.getComponentBodies());
        while (!toBeChecked.isEmpty()) {
            ComponentTypeBody body = toBeChecked.removeFirst();
            if (result.contains(body)) continue;
            result.add(body);
            if (body.attrExtendsReferences == null) continue;
            for (ComponentTypeBody subBody : body.attrExtendsReferences.getComponentBodies()) {
                if (result.contains(subBody) || toBeChecked.contains(subBody)) continue;
                toBeChecked.add(subBody);
            }
        }
        return result;
    }

    public void addAssignments(List<Definition> assignments) {
        for (Definition def : assignments) {
            if (def == null || def.getIdentifier() == null || def.getIdentifier().getLocation() == null) continue;
            this.definitions.add(def);
            def.setFullNameParent(this);
            def.setMyScope(this);
        }
    }

    @Override
    public String chainedDescription() {
        return this.getFullName();
    }

    @Override
    public Location getChainLocation() {
        if (this.identifier != null && this.identifier.getLocation() != null) {
            return this.identifier.getLocation();
        }
        return null;
    }

    public String toString() {
        return this.getFullName();
    }

    protected void checkRecursion(IReferenceChain refChain) {
        if (refChain.add(this)) {
            return;
        }
        if (this.extendsReferences != null && refChain.add(this)) {
            this.extendsReferences.checkRecursion(refChain);
        }
    }

    private void collectExtensionAttributes(CompilationTimeStamp timestamp) {
        int i;
        if (this.withAttributesPath == null) {
            return;
        }
        List<SingleWithAttribute> realAttributes = this.withAttributesPath.getRealAttributes(timestamp);
        ArrayList<AttributeSpecification> specifications = null;
        for (int i2 = 0; i2 < realAttributes.size(); ++i2) {
            Qualifiers qualifiers;
            SingleWithAttribute attribute = realAttributes.get(i2);
            if (!SingleWithAttribute.Attribute_Type.Extension_Attribute.equals((Object)attribute.getAttributeType()) || (qualifiers = attribute.getQualifiers()) != null && qualifiers.getNofQualifiers() != 0) continue;
            if (specifications == null) {
                specifications = new ArrayList<AttributeSpecification>();
            }
            specifications.add(attribute.getAttributeSpecification());
        }
        if (specifications == null) {
            return;
        }
        ArrayList<ExtensionAttribute> attributes = new ArrayList<ExtensionAttribute>();
        for (i = 0; i < specifications.size(); ++i) {
            AttributeSpecification specification = (AttributeSpecification)specifications.get(i);
            ExtensionAttributeAnalyzer analyzer = new ExtensionAttributeAnalyzer();
            analyzer.parse(specification);
            List<ExtensionAttribute> temp = analyzer.getAttributes();
            if (temp == null) continue;
            attributes.addAll(temp);
        }
        if (attributes.isEmpty()) {
            return;
        }
        this.attrExtendsReferences = new ComponentTypeReferenceList();
        int size = attributes.size();
        for (i = 0; i < size; ++i) {
            ExtensionAttribute tempAttribute = (ExtensionAttribute)attributes.get(i);
            if (!ExtensionAttribute.ExtensionAttribute_type.EXTENDS.equals((Object)tempAttribute.getAttributeType())) continue;
            ExtensionsAttribute extensionsAttribute = (ExtensionsAttribute)tempAttribute;
            int size2 = extensionsAttribute.getNofTypes();
            for (int j = 0; j < size2; ++j) {
                IType tempType = extensionsAttribute.getType(j);
                if (!IType.Type_type.TYPE_REFERENCED.equals((Object)tempType.getTypetype())) continue;
                this.attrExtendsReferences.addReference(((Referenced_Type)tempType).getReference());
            }
        }
        this.attrExtendsReferences.setFullNameParent(new BridgingNamedNode(this, ".<extends attribute>"));
        this.attrExtendsReferences.setMyScope(this.parentScope);
    }

    private void initCompatibility(ComponentTypeReferenceList references) {
        List<ComponentTypeBody> componentBodies = references.getComponentBodies();
        int size = componentBodies.size();
        for (int i = 0; i < size; ++i) {
            ComponentTypeBody componentBody = componentBodies.get(i);
            if (!this.compatibleBodies.contains(componentBody)) {
                this.compatibleBodies.add(componentBody);
            }
            for (ComponentTypeBody tempComponentBody : componentBody.compatibleBodies) {
                if (this.compatibleBodies.contains(tempComponentBody)) continue;
                this.compatibleBodies.add(tempComponentBody);
            }
        }
    }

    private void checkUniqueness(CompilationTimeStamp timestamp) {
        if (this.lastUniquenessCheck != null && !this.lastUniquenessCheck.isLess(timestamp)) {
            return;
        }
        this.lastUniquenessCheck = timestamp;
        this.compatibleBodies.clear();
        this.definitions.checkUniqueness();
        this.addDefinitionsOfExtendsParents(timestamp);
        this.addDefinitionsOfExtendAttributeParents(timestamp);
    }

    private void addDefinitionsOfExtendAttributeParents(CompilationTimeStamp timestamp) {
        this.attributeGainedDefinitions.clear();
        if (this.attrExtendsReferences != null) {
            this.attrExtendsReferences.check(timestamp);
            ReferenceChain referenceChain = ReferenceChain.getInstance(CIRCULAREXTENSIONCHAIN, true);
            if (referenceChain.add(this)) {
                this.attrExtendsReferences.checkRecursion(referenceChain);
            }
            referenceChain.release();
            this.initCompatibility(this.attrExtendsReferences);
            this.collectDefinitionsFromAttributeExtends();
        }
    }

    private void addDefinitionsOfExtendsParents(CompilationTimeStamp timestamp) {
        this.extendsGainedDefinitions.clear();
        if (this.extendsReferences == null) {
            return;
        }
        this.extendsReferences.check(timestamp);
        ReferenceChain referenceChain = ReferenceChain.getInstance(CIRCULAREXTENSIONCHAIN, true);
        if (referenceChain.add(this)) {
            this.extendsReferences.checkRecursion(referenceChain);
        }
        referenceChain.release();
        this.initCompatibility(this.extendsReferences);
        List<ComponentTypeBody> bodies = this.getExtendsInheritedComponentBodies();
        for (ComponentTypeBody body : bodies) {
            Map<String, Definition> subDefinitionMap = body.getDefinitionMap();
            for (Definition definition : subDefinitionMap.values()) {
                String name = definition.getIdentifier().getName();
                if (this.definitions.hasDefinition(name)) {
                    Definition localDefinition = this.definitions.getDefinition(name);
                    localDefinition.getIdentifier().getLocation().reportSemanticError(MessageFormat.format(LOCALINHERTANCECOLLISSION, definition.getIdentifier().getDisplayName(), definition.getMyScope().getFullName()));
                    continue;
                }
                if (this.extendsGainedDefinitions.containsKey(name)) {
                    Definition previousDefinition = this.extendsGainedDefinitions.get(name);
                    if (previousDefinition.equals(definition)) continue;
                    if (this.equals(previousDefinition.getMyScope())) {
                        previousDefinition.getLocation().reportSemanticError(MessageFormat.format(LOCALINHERTANCECOLLISSION, previousDefinition.getIdentifier().getDisplayName(), definition.getMyScope().getFullName()));
                        definition.getIdentifier().getLocation().reportSemanticWarning(MessageFormat.format(INHERITEDLOCATION, definition.getIdentifier().getDisplayName()));
                        continue;
                    }
                    if (this.identifier == null || this.identifier.getLocation() == null) continue;
                    this.identifier.getLocation().reportSemanticError(MessageFormat.format(INHERITANCECOLLISSION, definition.getIdentifier().getDisplayName(), definition.getMyScope().getFullName(), previousDefinition.getMyScope().getFullName()));
                    definition.getIdentifier().getLocation().reportSingularSemanticWarning(MessageFormat.format(INHERITEDDEFINITIONLOCATION, definition.getIdentifier().getDisplayName(), definition.getMyScope().getFullName()));
                    previousDefinition.getIdentifier().getLocation().reportSingularSemanticWarning(MessageFormat.format(INHERITEDDEFINITIONLOCATION, previousDefinition.getIdentifier().getDisplayName(), previousDefinition.getMyScope().getFullName()));
                    continue;
                }
                this.extendsGainedDefinitions.put(name, definition);
                if (definition.getMyScope().getModuleScope().equals(this.parentScope.getModuleScope())) continue;
                if (this.parentScope.hasAssignmentWithId(timestamp, definition.getIdentifier())) {
                    if (this.identifier == null || this.identifier.getLocation() == null) continue;
                    this.identifier.getLocation().reportSemanticError(MessageFormat.format(HIDINGSCOPEELEMENT, definition.getIdentifier().getDisplayName()));
                    ArrayList<ISubReference> subReferences = new ArrayList<ISubReference>();
                    subReferences.add(new FieldSubReference(definition.getIdentifier()));
                    Reference reference = new Reference(null, subReferences);
                    Assignment assignment = this.parentScope.getAssBySRef(timestamp, reference);
                    if (assignment != null && assignment.getLocation() != null) {
                        assignment.getLocation().reportSingularSemanticError(MessageFormat.format(HIDDENSCOPEELEMENT, definition.getIdentifier().getDisplayName()));
                    }
                    definition.getIdentifier().getLocation().reportSingularSemanticWarning(MessageFormat.format(INHERITEDDEFINITIONLOCATION, definition.getIdentifier().getDisplayName(), definition.getMyScope().getFullName()));
                    continue;
                }
                if (!this.parentScope.isValidModuleId(definition.getIdentifier())) continue;
                definition.getLocation().reportSingularSemanticWarning(MessageFormat.format(HIDINGMODULEIDENTIFIER, definition.getIdentifier().getDisplayName()));
            }
        }
    }

    private void collectDefinitionsFromAttributeExtends() {
        List<ComponentTypeBody> parents = this.getAttributeExtendsInheritedComponentBodies();
        for (ComponentTypeBody parent : parents) {
            for (Definition definition : parent.getDefinitions()) {
                Identifier id = definition.getIdentifier();
                String name = id.getName();
                if (this.extendsGainedDefinitions.containsKey(name)) {
                    Definition myDefinition = this.extendsGainedDefinitions.get(name);
                    if (definition == myDefinition) continue;
                    this.location.reportSemanticError(MessageFormat.format(INHERITANCECOLLISSION, id.getDisplayName(), definition.getMyScope().getFullName(), myDefinition.getMyScope().getFullName()));
                    continue;
                }
                if (!this.definitions.hasDefinition(name)) {
                    this.location.reportSemanticError(MessageFormat.format("Missing local definition of `{0}'', which was inherited from component type `{1}''", id.getDisplayName(), definition.getMyScope().getFullName()));
                    continue;
                }
                this.attributeGainedDefinitions.put(name, definition);
            }
        }
    }

    private void checkExtensionAttributes(CompilationTimeStamp timestamp) {
        if (this.attributeGainedDefinitions == null || this.attributeGainedDefinitions.isEmpty()) {
            return;
        }
        for (Definition originalDefinition : this.definitions) {
            Definition inheritedDefinition = this.attributeGainedDefinitions.get(originalDefinition.getIdentifier().getName());
            if (inheritedDefinition == null) continue;
            originalDefinition.checkIdentical(timestamp, inheritedDefinition);
        }
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.lastCompilationTimeStamp != null && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        this.lastCompilationTimeStamp = timestamp;
        this.attrExtendsReferences = null;
        this.collectExtensionAttributes(timestamp);
        this.checkUniqueness(timestamp);
        this.definitions.checkAll(timestamp);
        this.checkExtensionAttributes(timestamp);
    }

    public boolean isCompatible(CompilationTimeStamp timestamp, ComponentTypeBody other) {
        if (this == other) {
            return true;
        }
        this.check(timestamp);
        other.check(timestamp);
        if (this.definitions.isEmpty() && this.extendsReferences == null && this.attrExtendsReferences == null) {
            return true;
        }
        return other.compatibleBodies.contains(this);
    }

    @Override
    public void addProposal(ProposalCollector propCollector) {
        if (propCollector.getReference().getModuleIdentifier() == null) {
            this.addProposal(propCollector, 0);
        }
    }

    public void addProposal(ProposalCollector propCollector, int i) {
        if (i > 0) {
            return;
        }
        for (Definition definition : this.definitions) {
            definition.addProposal(propCollector, i);
        }
        for (Definition definition : this.extendsGainedDefinitions.values()) {
            if (!VisibilityModifier.Public.equals((Object)definition.getVisibilityModifier())) continue;
            definition.addProposal(propCollector, i);
        }
    }

    @Override
    public void addSkeletonProposal(ProposalCollector propCollector) {
        for (SkeletonTemplateProposal templateProposal : TTCN3CodeSkeletons.COMPONENT_INTERNAL_SKELETON_TEMPLATE_PROPOSALS) {
            propCollector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), TTCN3CodeSkeletons.SKELETON_IMAGE);
        }
    }

    @Override
    public void addKeywordProposal(ProposalCollector propCollector) {
        propCollector.addProposal(TTCN3Keywords.COMPONENT_SCOPE, null, "keyword");
        super.addKeywordProposal(propCollector);
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector) {
        if (declarationCollector.getReference().getModuleIdentifier() == null) {
            this.addDeclaration(declarationCollector, 0);
        }
    }

    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        Identifier identifier = declarationCollector.getReference().getId();
        Definition definition = this.definitions.getDefinition(identifier.getName());
        if (definition != null) {
            definition.addDeclaration(declarationCollector, i);
        }
        if ((definition = this.extendsGainedDefinitions.get(identifier.getName())) != null) {
            definition.addDeclaration(declarationCollector, i);
        }
        if ((definition = this.attributeGainedDefinitions.get(identifier.getName())) != null) {
            definition.addDeclaration(declarationCollector, i);
        }
        if (i == 0) {
            super.addDeclaration(declarationCollector);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        for (Definition definition : this.definitions) {
            definition.updateSyntax(reparser, false);
            reparser.updateLocation(definition.getLocation());
            if (definition.getLocation().equals(definition.getCumulativeDefinitionLocation())) continue;
            reparser.updateLocation(definition.getCumulativeDefinitionLocation());
        }
        if (this.extendsReferences != null) {
            this.extendsReferences.updateSyntax(reparser, false);
            reparser.updateLocation(this.extendsReferences.getLocation());
        }
    }

    @Override
    public Assignment getEnclosingAssignment(int offset) {
        if (this.definitions == null) {
            return null;
        }
        for (Definition definition : this.definitions) {
            if (!definition.getLocation().containsOffset(offset)) continue;
            return definition;
        }
        return null;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.definitions != null) {
            for (Definition def : this.definitions) {
                def.findReferences(referenceFinder, foundIdentifiers);
            }
        }
        if (this.extendsReferences != null) {
            this.extendsReferences.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.attrExtendsReferences != null) {
            this.attrExtendsReferences.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.definitions != null) {
            for (Definition def : this.definitions) {
                if (def.accept(v)) continue;
                return false;
            }
        }
        if (this.extendsReferences != null && !this.extendsReferences.accept(v)) {
            return false;
        }
        if (this.attrExtendsReferences != null && !this.attrExtendsReferences.accept(v)) {
            return false;
        }
        return v.leave(this) != 2;
    }
}

