/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.PortReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Port;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeFactory;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimensions;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ValueofExpression;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Port_Utility {
    private static final String VALUEREDIRECTTYPEMISSMATCH = "Type missmatch in value redirect: A variable of type `{0}'' was expected instead of `{1}''";
    private static final String PORTINCONTROLPART = "Port operation is not allowed in the control part";
    private static final String PORTREFERENCEEXPECTED = "Reference to a port or port parameter was expected instead of {0}";
    private static final String SIGNATUREEXPECTED1 = "Reference to a signature was expceted instead of {0}";
    private static final String SIGNATUREEXPECTED2 = "Reference to a signature was expected instead of port type `{0}''";
    private static final String SIGNATUREEXPECTED3 = "Reference to a signature was expected instead of data type `{0}''";
    private static final String COMPONENTOPINCONTROLPART = "Component operation is not allowed in the control part";
    private static final String NULLCOMPONENTREFERENCE = "The `null'' component reference shall not be used in a {0} operation";
    private static final String VALUERETURNEXPECTED = "A component reference was expected as return value";
    private static final String MTCCOMPONENTREFERENCE = "The `mtc'' component reference shall not be used in a {0} operation";
    private static final String SYSTEMCOMPONENTREFERENCE = "The `system'' component reference shall not be used in a {0} operation";
    private static final String COMPONENTREFERENCEEXPECTED = "A component reference was expected as operand";
    private static final String COMPONENTTYPEMISMATCH = "Type mismatch: The type of the operand should be a component type instead of `{0}''";
    private static final String NOPORTWITHNAME = "Component type `{0}'' does not have a port with name `{1}''";
    private static final String DEFINITIONNOTPORT = "Definition `{0}'' in component type `{1}'' is a {2} and not a port";

    private Port_Utility() {
    }

    public static Port_Type checkPortReference(CompilationTimeStamp timestamp, Statement source, Reference portReference) {
        if (source.getMyStatementBlock() != null && source.getMyStatementBlock().getMyDefinition() == null) {
            source.getLocation().reportSemanticError(PORTINCONTROLPART);
        }
        if (portReference == null) {
            return null;
        }
        Assignment assignment = portReference.getRefdAssignment(timestamp, true);
        if (assignment == null || assignment.getIsErroneous()) {
            return null;
        }
        IType result = null;
        switch (assignment.getAssignmentType()) {
            case A_PORT: {
                ArrayDimensions dimensions = ((Def_Port)assignment).getDimensions();
                if (dimensions != null) {
                    dimensions.checkIndices(timestamp, portReference, "port", false, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
                } else if (portReference.getSubreferences().size() > 1) {
                    portReference.getLocation().reportSemanticError(MessageFormat.format("Reference to single {0} cannot have field or array sub-references", assignment.getDescription()));
                }
                result = ((Def_Port)assignment).getType(timestamp);
                break;
            }
            case A_PAR_PORT: {
                if (portReference.getSubreferences().size() > 1) {
                    portReference.getLocation().reportSemanticError(MessageFormat.format("Reference to {0} cannot have field or array sub-references", assignment.getDescription()));
                }
                result = ((FormalParameter)assignment).getType(timestamp);
                break;
            }
            default: {
                portReference.getLocation().reportSemanticError(MessageFormat.format(PORTREFERENCEEXPECTED, assignment.getAssignmentName()));
            }
        }
        if (result == null) {
            return null;
        }
        if (IType.Type_type.TYPE_PORT.equals((Object)(result = result.getTypeRefdLast(timestamp)).getTypetype())) {
            return (Port_Type)result;
        }
        return null;
    }

    public static Signature_Type checkSignatureReference(CompilationTimeStamp timestamp, Reference reference) {
        if (reference == null) {
            return null;
        }
        Assignment assignment = reference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return null;
        }
        if (!Assignment.Assignment_type.A_TYPE.equals(assignment.getAssignmentType())) {
            reference.getLocation().reportSemanticError(MessageFormat.format(SIGNATUREEXPECTED1, assignment.getAssignmentName()));
            return null;
        }
        IType result = ((Def_Type)assignment).getType(timestamp);
        if (result == null) {
            return null;
        }
        if ((result = result.getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false)) == null) {
            return null;
        }
        result = result.getTypeRefdLast(timestamp);
        switch (result.getTypetype()) {
            case TYPE_SIGNATURE: {
                return (Signature_Type)result;
            }
            case TYPE_PORT: {
                reference.getLocation().reportSemanticError(MessageFormat.format(SIGNATUREEXPECTED2, result.getTypename()));
                return null;
            }
        }
        reference.getLocation().reportSemanticError(MessageFormat.format(SIGNATUREEXPECTED3, result.getTypename()));
        return null;
    }

    public static Component_Type checkComponentReference(CompilationTimeStamp timestamp, Statement source, IValue value, boolean allowMtc, boolean allowSystem) {
        if (source.getMyStatementBlock() != null && source.getMyStatementBlock().getMyDefinition() == null) {
            source.getLocation().reportSemanticError(COMPONENTOPINCONTROLPART);
        }
        if (value == null || value.getIsErroneous(timestamp)) {
            return null;
        }
        IValue last = value.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
        block0 : switch (last.getValuetype()) {
            case REFERENCED_VALUE: {
                break;
            }
            case TTCN3_NULL_VALUE: {
                value.getLocation().reportSemanticError(MessageFormat.format(NULLCOMPONENTREFERENCE, source.getStatementName()));
                break;
            }
            case EXPRESSION_VALUE: {
                Expression_Value expression = (Expression_Value)last;
                switch (expression.getOperationType()) {
                    case APPLY_OPERATION: {
                        if (IType.Type_type.TYPE_COMPONENT.equals((Object)last.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE))) break block0;
                        value.getLocation().reportSemanticError(VALUERETURNEXPECTED);
                        break block0;
                    }
                    case COMPONENT_NULL_OPERATION: {
                        value.getLocation().reportSemanticError(MessageFormat.format(NULLCOMPONENTREFERENCE, source.getStatementName()));
                        break block0;
                    }
                    case MTC_COMPONENT_OPERATION: {
                        if (allowMtc) break block0;
                        value.getLocation().reportSemanticError(MessageFormat.format(MTCCOMPONENTREFERENCE, source.getStatementName()));
                        break block0;
                    }
                    case SYSTEM_COMPONENT_OPERATION: {
                        if (allowSystem) break block0;
                        value.getLocation().reportSemanticError(MessageFormat.format(SYSTEMCOMPONENTREFERENCE, source.getStatementName()));
                        break block0;
                    }
                    case SELF_COMPONENT_OPERATION: {
                        break block0;
                    }
                    case COMPONENT_CREATE_OPERATION: {
                        break block0;
                    }
                    case VALUEOF_OPERATION: {
                        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                        ((ValueofExpression)expression).evaluateValue(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, referenceChain);
                        referenceChain.release();
                        break block0;
                    }
                    default: {
                        value.getLocation().reportSemanticError(COMPONENTREFERENCEEXPECTED);
                        return null;
                    }
                }
            }
            default: {
                value.getLocation().reportSemanticError(COMPONENTREFERENCEEXPECTED);
                return null;
            }
        }
        IType result = value.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        if (result == null) {
            return null;
        }
        if ((result = result.getTypeRefdLast(timestamp)).getIsErroneous(timestamp)) {
            return null;
        }
        if (IType.Type_type.TYPE_COMPONENT.equals((Object)result.getTypetype())) {
            return (Component_Type)result;
        }
        value.getLocation().reportSemanticError(MessageFormat.format(COMPONENTTYPEMISMATCH, result.getTypename()));
        return null;
    }

    public static IType checkConnectionEndpoint(CompilationTimeStamp timestamp, Statement source, Value componentReference, PortReference portReference, boolean allowSystem) {
        IType providerType;
        PortTypeBody portBody;
        Component_Type componentType = Port_Utility.checkComponentReference(timestamp, source, componentReference, true, allowSystem);
        if (portReference == null) {
            return componentType;
        }
        if (componentType == null) {
            List<ISubReference> subreferences = portReference.getSubreferences();
            if (subreferences.size() > 1) {
                block4: for (int i = 0; i < subreferences.size(); ++i) {
                    ISubReference subreference = subreferences.get(i);
                    if (!(subreference instanceof ArraySubReference)) continue;
                    Value value = ((ArraySubReference)subreference).getValue();
                    value.setLoweridToReference(timestamp);
                    IType.Type_type temporalType1 = value.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
                    switch (temporalType1) {
                        case TYPE_INTEGER: {
                            ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                            IValue last1 = value.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, referenceChain);
                            referenceChain.release();
                            if (last1.isUnfoldable(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)last1.getValuetype()) || ((Integer_Value)last1).signum() >= 0) continue block4;
                            value.getLocation().reportSemanticError("Using a large integer value ({0}) as index is not supported");
                            value.setIsErroneous(true);
                            continue block4;
                        }
                        case TYPE_UNDEFINED: {
                            value.setIsErroneous(true);
                            continue block4;
                        }
                        default: {
                            if (value.getIsErroneous(timestamp)) continue block4;
                            value.getLocation().reportSemanticError("An integer value was expected as index");
                            value.setIsErroneous(true);
                        }
                    }
                }
            }
            return null;
        }
        ComponentTypeBody componentBody = componentType.getComponentBody();
        portReference.setBaseScope(componentBody);
        portReference.setComponent(componentType);
        Identifier portIdentifier = portReference.getId();
        if (!componentBody.hasLocalAssignmentWithId(portIdentifier)) {
            portReference.getLocation().reportSemanticError(MessageFormat.format(NOPORTWITHNAME, componentType.getTypename(), portIdentifier.getDisplayName()));
            return null;
        }
        Definition assignment = componentBody.getLocalAssignmentById(portIdentifier);
        if (assignment == null) {
            return null;
        }
        if (!Assignment.Assignment_type.A_PORT.equals(assignment.getAssignmentType())) {
            portReference.getLocation().reportSemanticError(MessageFormat.format(DEFINITIONNOTPORT, portIdentifier.getDisplayName(), componentType.getTypename(), assignment.getAssignmentName()));
            return null;
        }
        ArrayDimensions dimensions = ((Def_Port)assignment).getDimensions();
        if (dimensions != null) {
            dimensions.checkIndices(timestamp, portReference, "port", false, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        } else if (portReference.getSubreferences().size() > 1) {
            portReference.getLocation().reportSemanticError(MessageFormat.format("Port `{0}'' is not an array. The reference cannot have field or array sub-references", portIdentifier.getDisplayName()));
        }
        Port_Type portType = ((Def_Port)assignment).getType(timestamp);
        if (portType != null && PortTypeBody.PortType_type.PT_USER.equals((Object)(portBody = portType.getPortBody()).getPortType()) && (providerType = portBody.getProviderType()) instanceof Port_Type) {
            portType = (Port_Type)providerType;
        }
        return portType;
    }

    public static IType checkSenderRedirect(CompilationTimeStamp timestamp, IType addressType, Reference redirectSender) {
        if (redirectSender == null) {
            return null;
        }
        IType variableType = redirectSender.checkVariableReference(timestamp);
        if (variableType == null) {
            return null;
        }
        if (addressType == null || !addressType.isIdentical(timestamp, variableType)) {
            IType last = variableType.getTypeRefdLast(timestamp);
            if (last.getIsErroneous(timestamp)) {
                return null;
            }
            if (!IType.Type_type.TYPE_COMPONENT.equals((Object)last.getTypetype())) {
                redirectSender.getLocation().reportSemanticError(MessageFormat.format("The type of the variable should be a component type {0}instead of `{1}''", addressType == null ? "" : "or the `address' type ", variableType.getTypename()));
                return null;
            }
        }
        return variableType;
    }

    public static void checkFromClause(CompilationTimeStamp timestamp, Statement source, Port_Type portType, TemplateInstance fromClause, Reference redirectSender) {
        Module module;
        IType addressType = null;
        if (portType != null) {
            addressType = portType.getPortBody().getAddressType(timestamp);
        } else if (source != null && source.getMyStatementBlock() != null && (module = source.getMyStatementBlock().getModuleScope()) != null && Module.module_type.TTCN3_MODULE.equals((Object)module.getModuletype())) {
            addressType = ((TTCN3Module)module).getAddressType(timestamp);
        }
        boolean senderRedirectChecked = false;
        IType fromClauseType = null;
        if (fromClause != null) {
            fromClauseType = fromClause.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
            ITTCN3Template templateBody = fromClause.getTemplateBody();
            if (fromClauseType == null) {
                templateBody = addressType != null ? addressType.checkThisTemplateRef(timestamp, templateBody) : templateBody.setLoweridToReference(timestamp);
                fromClauseType = templateBody.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
            }
            if (fromClauseType == null) {
                fromClauseType = Port_Utility.checkSenderRedirect(timestamp, addressType, redirectSender);
                senderRedirectChecked = true;
            }
            if (fromClauseType == null) {
                boolean isComponentReference;
                if (IType.Type_type.TYPE_COMPONENT.equals((Object)templateBody.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_TEMPLATE))) {
                    isComponentReference = true;
                } else {
                    switch (templateBody.getTemplatetype()) {
                        case SPECIFIC_VALUE: {
                            isComponentReference = IValue.Value_type.TTCN3_NULL_VALUE.equals((Object)((SpecificValue_Template)templateBody).getSpecificValue().getValuetype());
                            break;
                        }
                        case ANY_VALUE: 
                        case ANY_OR_OMIT: {
                            isComponentReference = true;
                            break;
                        }
                        default: {
                            isComponentReference = false;
                        }
                    }
                }
                if (isComponentReference) {
                    fromClauseType = TypeFactory.createType(IType.Type_type.TYPE_COMPONENT);
                } else if (addressType != null) {
                    fromClauseType = addressType;
                }
            }
            if (fromClauseType != null) {
                fromClause.check(timestamp, fromClauseType);
                if (addressType == null || !addressType.isCompatible(timestamp, fromClauseType, null, null, null)) {
                    IType last = fromClauseType.getTypeRefdLast(timestamp);
                    if (last.getIsErroneous(timestamp)) {
                        fromClauseType = null;
                    } else if (IType.Type_type.TYPE_COMPONENT.equals((Object)last.getTypetype())) {
                        if (ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)templateBody.getTemplatetype())) {
                            Port_Utility.checkComponentReference(timestamp, source, ((SpecificValue_Template)templateBody).getSpecificValue(), true, true);
                        }
                    } else {
                        String message = MessageFormat.format("The type of the template should be a component type {0} instead of `{1}''", addressType == null ? "" : "or the `address' type ", fromClauseType.getTypename());
                        fromClause.getLocation().reportSemanticError(message);
                        fromClauseType = null;
                    }
                }
            } else {
                fromClause.getLocation().reportSemanticError("Cannot determine the type of the template");
            }
        }
        if (!senderRedirectChecked) {
            IType senderRedirectType = Port_Utility.checkSenderRedirect(timestamp, addressType, redirectSender);
            if (fromClauseType != null && senderRedirectType != null && !fromClauseType.isIdentical(timestamp, senderRedirectType)) {
                String message = MessageFormat.format("The types in `from'' clause and `sender'' redirect are not the same: `{0}'' was expected instead of `{1}''", fromClauseType.getTypename(), senderRedirectType.getTypename());
                senderRedirectType.getLocation().reportSemanticError(message);
            }
        }
    }

    public static void checkToClause(CompilationTimeStamp timestamp, Statement source, Port_Type portType, IValue toClause) {
        Module module;
        if (toClause == null) {
            return;
        }
        IType addressType = null;
        if (portType != null) {
            addressType = portType.getPortBody().getAddressType(timestamp);
        } else if (source != null && (module = source.getMyStatementBlock().getModuleScope()) != null && Module.module_type.TTCN3_MODULE.equals((Object)module.getModuletype())) {
            addressType = ((TTCN3Module)module).getAddressType(timestamp);
        }
        if (addressType == null) {
            Port_Utility.checkComponentReference(timestamp, source, toClause, true, true);
        } else {
            IValue temp = addressType.checkThisValueRef(timestamp, toClause);
            IType governor = temp.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            boolean isAddress = governor == null ? !IType.Type_type.TYPE_COMPONENT.equals((Object)temp.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE)) : addressType.isCompatible(timestamp, governor, null, null, null);
            if (isAddress) {
                addressType.checkThisValue(timestamp, temp, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, false, true, false, false));
            } else {
                Port_Utility.checkComponentReference(timestamp, source, temp, true, true);
            }
        }
    }

    public static IType checkValueRedirect(CompilationTimeStamp timestamp, Reference redirectValue, IType type) {
        Assignment assignment;
        if (redirectValue == null) {
            return null;
        }
        IType variableType = redirectValue.checkVariableReference(timestamp);
        if (type != null && variableType != null && !type.isCompatible(timestamp, variableType, null, null, null)) {
            redirectValue.getLocation().reportSemanticError(MessageFormat.format(VALUEREDIRECTTYPEMISSMATCH, type.getTypename(), variableType.getTypename()));
        }
        if ((assignment = redirectValue.getRefdAssignment(timestamp, true)) != null) {
            switch (assignment.getAssignmentType()) {
                case A_PAR_VAL: 
                case A_PAR_VAL_OUT: 
                case A_PAR_VAL_INOUT: {
                    ((FormalParameter)assignment).setWritten();
                    break;
                }
                case A_VAR: {
                    ((Def_Var)assignment).setWritten();
                    break;
                }
                case A_PAR_TEMP_OUT: 
                case A_PAR_TEMP_INOUT: {
                    ((FormalParameter)assignment).setWritten();
                    break;
                }
                case A_VAR_TEMPLATE: {
                    ((Def_Var_Template)assignment).setWritten();
                    break;
                }
            }
        }
        return variableType;
    }

    public static IType getIncomingType(CompilationTimeStamp timestamp, TemplateInstance templateInstance, Reference valueRedirect, boolean[] valueRedirectChecked) {
        IType result = templateInstance.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
        if (result != null) {
            return result;
        }
        result = Port_Utility.checkValueRedirect(timestamp, valueRedirect, null);
        valueRedirectChecked[0] = true;
        if (result != null) {
            return result;
        }
        TTCN3Template template = templateInstance.getTemplateBody();
        ITTCN3Template temp = template.setLoweridToReference(timestamp);
        return temp.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
    }

    public static IType getOutgoingType(CompilationTimeStamp timestamp, TemplateInstance templateInstance) {
        IType result = templateInstance.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
        if (result != null) {
            return result.getTypeRefdLast(timestamp);
        }
        ITTCN3Template template = templateInstance.getTemplateBody();
        template = template.setLoweridToReference(timestamp);
        return template.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
    }
}

