/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.statements.LogArgument;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class LogArguments
extends ASTNode
implements IIncrementallyUpdateable {
    private static final String FULLNAMEPART = ".logargs_";
    private final ArrayList<LogArgument> arguments = new ArrayList();

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.arguments.size();
        for (int i = 0; i < size; ++i) {
            if (this.arguments.get(i) != child) continue;
            return builder.append(FULLNAMEPART).append(Integer.toString(i + 1));
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        int size = this.arguments.size();
        for (int i = 0; i < size; ++i) {
            this.arguments.get(i).setMyScope(scope);
        }
    }

    public void add(LogArgument logArgument) {
        if (logArgument != null) {
            this.arguments.add(logArgument);
            logArgument.setFullNameParent(this);
        }
    }

    public void check(CompilationTimeStamp timestamp) {
        this.arguments.trimToSize();
        int size = this.arguments.size();
        for (int i = 0; i < size; ++i) {
            this.arguments.get(i).check(timestamp);
        }
    }

    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        int size = this.arguments.size();
        for (int i = 0; i < size; ++i) {
            this.arguments.get(i).checkRecursions(timestamp, referenceChain);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        int size = this.arguments.size();
        for (int i = 0; i < size; ++i) {
            LogArgument argument = this.arguments.get(i);
            argument.updateSyntax(reparser, false);
            reparser.updateLocation(argument.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.arguments == null) {
            return;
        }
        ArrayList<LogArgument> tempList = new ArrayList<LogArgument>(this.arguments);
        for (LogArgument logArgument : tempList) {
            logArgument.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.arguments != null) {
            for (LogArgument la : this.arguments) {
                if (la.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

