/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public final class SelectionUtils {
    private SelectionUtils() {
    }

    public static List<IFile> getAccessibleFilesFromSelection(ISelection selection) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        for (Object selected : SelectionUtils.getObjectsFromSelection(selection)) {
            IFile file;
            if (!(selected instanceof IFile) || !(file = (IFile)selected).isAccessible()) continue;
            result.add(file);
        }
        return result;
    }

    public static List<IResource> getResourcesFromSelection(ISelection selection) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        for (Object o : SelectionUtils.getObjectsFromSelection(selection)) {
            if (!(o instanceof IResource)) continue;
            result.add((IResource)o);
        }
        return result;
    }

    public static List<IProject> getProjectsFromSelection(ISelection selection) {
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (Object o : SelectionUtils.getObjectsFromSelection(selection)) {
            if (!(o instanceof IProject)) continue;
            result.add((IProject)o);
        }
        return result;
    }

    public static List<Object> getObjectsFromSelection(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return new ArrayList<Object>();
        }
        IStructuredSelection structSelection = (IStructuredSelection)selection;
        if (structSelection.isEmpty()) {
            return new ArrayList<Object>();
        }
        return structSelection.toList();
    }

    public static <T> List<T> filterSelection(ISelection selection, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object o : SelectionUtils.getObjectsFromSelection(selection)) {
            if (!type.isInstance(o)) continue;
            result.add(type.cast(o));
        }
        return result;
    }
}

