/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.path;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathUtil;
import org.eclipse.titan.common.utils.environment.EnvironmentVariableResolver;

public final class TITANPathUtilities {
    private TITANPathUtilities() {
    }

    public static URI resolvePath(String pathToBeResolved, URI basePath) {
        String basePathString;
        String temp;
        Map envVariables = DebugPlugin.getDefault() != null ? DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved() : null;
        String tmp2 = null;
        try {
            String tmp1 = EnvironmentVariableResolver.eclipseStyle().resolve(pathToBeResolved, envVariables);
            tmp2 = EnvironmentVariableResolver.unixStyle().resolveIgnoreErrors(tmp1, envVariables);
        }
        catch (EnvironmentVariableResolver.VariableNotFoundException e) {
            ErrorReporter.logError("There was an error while resolving `" + pathToBeResolved + "'");
            return null;
        }
        IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        URI uri = org.eclipse.core.filesystem.URIUtil.toURI((String)tmp2);
        uri = pathVariableManager.resolveURI(uri);
        if (basePath != null && uri != null && !uri.isAbsolute() && (temp = PathUtil.getAbsolutePath(basePathString = org.eclipse.core.filesystem.URIUtil.toPath((URI)basePath).toOSString(), tmp2)) != null) {
            uri = org.eclipse.core.filesystem.URIUtil.toURI((String)temp);
        }
        return uri;
    }

    public static URI resolvePathURI(String pathToBeResolved, String basePath) {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin == null) {
            ErrorReporter.logError("There was an error while resolving `" + pathToBeResolved + "'" + "the DebugPlugin was not yet initialized");
            return URI.create(pathToBeResolved);
        }
        Map envVariables = debugPlugin.getLaunchManager().getNativeEnvironmentCasePreserved();
        return TITANPathUtilities.resolvePathURI(pathToBeResolved, basePath, envVariables, ResourcesPlugin.getWorkspace().getPathVariableManager());
    }

    private static URI resolvePathURI(String pathToBeResolved, String basePath, Map<?, ?> envVariables, IPathVariableManager pathVariableManager) {
        String temp;
        String tmp2 = null;
        try {
            String tmp1 = EnvironmentVariableResolver.eclipseStyle().resolve(pathToBeResolved, envVariables);
            tmp2 = EnvironmentVariableResolver.unixStyle().resolveIgnoreErrors(tmp1, envVariables);
        }
        catch (EnvironmentVariableResolver.VariableNotFoundException e) {
            ErrorReporter.logError("There was an error while resolving `" + pathToBeResolved + "'");
            return null;
        }
        URI uri = org.eclipse.core.filesystem.URIUtil.toURI((String)tmp2);
        URI resolvedURI = pathVariableManager.resolveURI(uri);
        if (basePath != null && !"".equals(basePath) && !resolvedURI.isAbsolute() && (temp = PathUtil.getAbsolutePath(basePath, tmp2)) != null) {
            resolvedURI = org.eclipse.core.filesystem.URIUtil.toURI((String)temp);
        }
        return resolvedURI;
    }

    public static URI convertToAbsoluteURI(String pathToBeConverted, String basePath) {
        return TITANPathUtilities.convertToAbsoluteURI(pathToBeConverted, org.eclipse.core.filesystem.URIUtil.toURI((String)basePath));
    }

    public static URI convertToAbsoluteURI(String pathToBeConverted, URI basePath) {
        URI convertedURI;
        Path tmp = new Path(pathToBeConverted);
        if (basePath != null && tmp != null && !tmp.isAbsolute() && (convertedURI = URIUtil.append((URI)basePath, (String)pathToBeConverted)) != null) {
            return convertedURI;
        }
        return org.eclipse.core.filesystem.URIUtil.toURI((IPath)tmp);
    }
}

