/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Clause;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Receive_Port_Statement;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titanium.markers.spotters.implementation.RefUsedInMatching;

final class SuspiciouslyUsedIf
extends ASTVisitor {
    private Reference redirectValue;
    private boolean smells;
    private If_Clause suspicious;

    public SuspiciouslyUsedIf(Receive_Port_Statement rec) {
        this.redirectValue = rec.getRedirectValue();
        this.smells = false;
        this.suspicious = null;
    }

    public boolean doesSmell() {
        return this.smells;
    }

    public If_Clause getSuspicious() {
        return this.suspicious;
    }

    public int visit(IVisitableNode node) {
        if (node instanceof If_Statement) {
            List ifs = ((If_Statement)node).getIfClauses().getClauses();
            for (If_Clause clause : ifs) {
                Value cond = clause.getExpression();
                if (cond == null) continue;
                RefUsedInMatching mv = new RefUsedInMatching(this.redirectValue);
                cond.accept((ASTVisitor)mv);
                if (!mv.getUsed()) continue;
                this.smells = true;
                this.suspicious = clause;
            }
            return 1;
        }
        return 3;
    }
}

