/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.IsValueExpression;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class IsValueWithValue
extends BaseModuleCodeSmellSpotter {
    private static final String ERR_MSG = "Isvalue check on value always returns true. 'isbound' should be used to check existence. ";

    public IsValueWithValue() {
        super(CodeSmellType.ISVALUE_WITH_VALUE);
    }

    @Override
    protected void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        if (!(node instanceof IsValueExpression)) {
            return;
        }
        IsValueExpression ive = (IsValueExpression)node;
        ExpressionVisitor visitor = new ExpressionVisitor(problems);
        ive.accept((ASTVisitor)visitor);
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(IsValueExpression.class);
        return ret;
    }

    private static final class ExpressionVisitor
    extends ASTVisitor {
        private final BaseCodeSmellSpotter.Problems problems;

        public ExpressionVisitor(BaseCodeSmellSpotter.Problems problems) {
            this.problems = problems;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof IsValueExpression) {
                return 3;
            }
            if (node instanceof TemplateInstance) {
                return 3;
            }
            if (node instanceof TTCN3Template) {
                TTCN3Template template = (TTCN3Template)node;
                if ((template = template.setLoweridToReference(CompilationTimeStamp.getBaseTimestamp())).isValue(CompilationTimeStamp.getBaseTimestamp())) {
                    this.problems.report(template.getLocation(), IsValueWithValue.ERR_MSG);
                    return 1;
                }
            }
            return 1;
        }
    }
}

