/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.gui.dialogs;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.titanium.error.GUIErrorHandler;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.MetricGroup;
import org.eclipse.titanium.metrics.StatColumn;
import org.eclipse.titanium.metrics.Statistics;
import org.eclipse.titanium.metrics.preferences.PreferenceManager;
import org.eclipse.titanium.metrics.utils.ModuleMetricsWrapper;
import org.eclipse.titanium.metrics.utils.WrapperStore;
import org.eclipse.titanium.swt.SWTResourceManager;

public class InfoWindow
extends Dialog {
    private Table table;
    private NodeDescriptor module;
    private ModuleMetricsWrapper metricsProvider;
    private IMetricEnum chosenMetric;
    private Shell shell;
    protected final GUIErrorHandler errorHandler = new GUIErrorHandler();
    private static final Point WINDOW_SIZE = new Point(300, 300);
    private static final Point TABLE_BORDER_SIZE = new Point(15, 40);
    private static final int COLUMN_WIDTH = 150;

    public InfoWindow(NodeDescriptor node, IMetricEnum chosenMetric, Shell parent) {
        super(parent);
        this.shell = new Shell(this.getParent(), 2160);
        this.shell.setSize(WINDOW_SIZE);
        this.shell.setText("Module information - " + node.getDisplayName());
        this.shell.setImage(SWTResourceManager.getImage("resources/icons/metrics_top_worst.gif"));
        this.shell.addListener(11, new Listener(){

            public void handleEvent(Event ev) {
                if (InfoWindow.this.table != null && InfoWindow.this.shell != null) {
                    Point size = InfoWindow.this.shell.getSize();
                    InfoWindow.this.table.setSize(size.x - TABLE_BORDER_SIZE.x, size.y - TABLE_BORDER_SIZE.y);
                }
            }
        });
        this.chosenMetric = chosenMetric;
        this.setText("Module information - " + node.getDisplayName());
        this.metricsProvider = WrapperStore.getWrapper(node.getProject());
        this.module = node;
        this.table = new Table((Composite)this.shell, 67584);
        this.table.setSize(InfoWindow.WINDOW_SIZE.x - InfoWindow.TABLE_BORDER_SIZE.x, InfoWindow.WINDOW_SIZE.y - InfoWindow.TABLE_BORDER_SIZE.y);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn tmpCol = new TableColumn(this.table, 0);
        tmpCol.setText("Property");
        tmpCol.setWidth(150);
        for (StatColumn actCol : StatColumn.values()) {
            TableColumn tempCol = new TableColumn(this.table, 2048);
            tempCol.setText(actCol.getName());
            tempCol.setWidth(150);
        }
        this.open();
    }

    private void createContents(NodeDescriptor node) {
        if (node.isMissing()) {
            this.errorHandler.reportErrorMessage("The module \"" + node.getDisplayName() + "\" cannot be found on the disk!");
            return;
        }
        String shownName = node.getDisplayName();
        ArrayList<String> actRow = null;
        this.addRow(new ArrayList<String>(Arrays.asList("General Information")), Color.lightGray);
        this.addRow(new ArrayList<String>(Arrays.asList("Module name", shownName)), Color.white);
        for (MetricGroup type : new MetricGroup[]{MetricGroup.MODULE}) {
            this.addRow(new ArrayList<String>(Arrays.asList(type.getGroupName() + " metrics")), Color.lightGray);
            for (IMetricEnum metric : type.getMetrics()) {
                if (!PreferenceManager.isEnabledOnModuleGraph(metric)) continue;
                actRow = new ArrayList<String>();
                actRow.add(metric.getName());
                String val = null;
                Number tempVal = this.metricsProvider.getValue(metric, this.module.getName());
                if (tempVal != null) {
                    val = tempVal.toString();
                }
                actRow.add(val);
                if (this.chosenMetric.equals(metric)) {
                    this.addRow(actRow, node.getColor());
                    continue;
                }
                this.addRow(actRow, Color.white);
            }
        }
        for (MetricGroup type : new MetricGroup[]{MetricGroup.ALTSTEP, MetricGroup.FUNCTION, MetricGroup.TESTCASE}) {
            this.addRow(new ArrayList<String>(Arrays.asList(type.getGroupName())), Color.lightGray);
            for (IMetricEnum metric : type.getMetrics()) {
                if (!PreferenceManager.isEnabledOnModuleGraph(metric)) continue;
                actRow = new ArrayList();
                actRow.add(metric.getName());
                Statistics stat = this.metricsProvider.getStats(metric, this.module.getName());
                for (StatColumn actCol : StatColumn.values()) {
                    Number val = stat == null ? (Number)null : (Number)stat.get(actCol);
                    actRow.add(val == null ? "-" : val.toString());
                }
                if (this.chosenMetric.equals(metric)) {
                    this.addRow(actRow, node.getColor());
                    continue;
                }
                this.addRow(actRow, Color.white);
            }
        }
    }

    private Object open() {
        this.createContents(this.module);
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return null;
    }

    private void addRow(List<String> rowData, Color rowColour) {
        TableItem actItem = new TableItem(this.table, 2048);
        actItem.setBackground(SWTResourceManager.getColor(new RGB(rowColour.getRed(), rowColour.getGreen(), rowColour.getBlue())));
        String[] row = new String[rowData.size()];
        int i = 0;
        for (String cell : rowData) {
            row[i++] = cell;
        }
        actItem.setText(row);
    }

    public void dispose() {
        if (!this.shell.isDisposed()) {
            this.shell.close();
        }
    }
}

