/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titanium.error.GUIErrorHandler;
import org.eclipse.titanium.graph.gui.windows.ComponentGraphEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class ComponentGraphAction
extends AbstractHandler
implements IObjectActionDelegate {
    private ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        this.doOpenComponentGraphForSelected();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        this.doOpenComponentGraphForSelected();
        return null;
    }

    private void doOpenComponentGraphForSelected() {
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structSelection = (IStructuredSelection)this.selection;
        for (Object selected : structSelection.toList()) {
            if (!(selected instanceof IProject)) continue;
            final IProject project = (IProject)selected;
            Job generator = new Job("Generator"){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("Parsing project", 30);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ComponentGraphAction.this.doOpenGraphForProject(project);
                        }
                    });
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            generator.schedule();
        }
    }

    private void doOpenGraphForProject(IProject project) {
        try {
            IEditorPart editor;
            IResource[] members;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IFile input = null;
            for (IResource res : members = project.members()) {
                if (res.getType() == 1) {
                    input = (IFile)res;
                    break;
                }
                if (res.getType() != 2) continue;
                members = ((IFolder)res).members();
            }
            if ((editor = page.findEditor((IEditorInput)new FileEditorInput(input))) instanceof ComponentGraphEditor) {
                ((ComponentGraphEditor)editor).refreshGraph();
            } else {
                page.openEditor((IEditorInput)new FileEditorInput(input), "org.eclipse.titanium.graph.editors.ComponentGraphEditor", true, 3);
            }
        }
        catch (Exception exc) {
            GUIErrorHandler errorHandler = new GUIErrorHandler();
            errorHandler.reportException("Error while parsing the project", exc);
        }
    }
}

