/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.javadoc;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.viewers.StyledString;

public class JavadocLinkTypeCompletionProposal
extends LazyJavaTypeCompletionProposal {
    private static final String LINK_PREFIX = "{@link ";

    public JavadocLinkTypeCompletionProposal(CompletionProposal proposal, JavaContentAssistInvocationContext context) {
        super(proposal, context);
        Assert.isTrue((boolean)this.isInJavadoc());
    }

    @Override
    protected String computeReplacementString() {
        String typeReplacement = super.computeReplacementString();
        return LINK_PREFIX + typeReplacement + "}";
    }

    @Override
    public void apply(IDocument document, char trigger, int offset) {
        boolean continueWithMember;
        if (trigger == '.') {
            trigger = (char)35;
        }
        boolean bl = continueWithMember = trigger == '#';
        if (continueWithMember) {
            this.setCursorPosition(this.getCursorPosition() - 1);
        }
        super.apply(document, trigger, offset);
        if (continueWithMember) {
            this.setUpLinkedMode(document, '}');
        }
    }

    @Override
    public StyledString getStyledDisplayString(IDocument document, int offset, BoldStylerProvider boldStylerProvider) {
        StyledString styledDisplayString = new StyledString();
        styledDisplayString.append(this.getStyledDisplayString());
        String pattern = this.getPatternToEmphasizeMatch(document, offset);
        if (pattern != null && pattern.length() > 0) {
            int patternMatchRule;
            int prefixLength;
            int[] matchingRegions;
            String displayString = styledDisplayString.getString();
            int index = displayString.indexOf(45);
            if (index != -1) {
                displayString = displayString.substring(0, index);
            }
            if ((matchingRegions = SearchPattern.getMatchingRegions((String)pattern, (String)(displayString = displayString.substring(prefixLength = LINK_PREFIX.length())), (int)(patternMatchRule = this.getPatternMatchRule(pattern, displayString)))) != null) {
                int i = 0;
                while (i < matchingRegions.length) {
                    matchingRegions[i] = matchingRegions[i] + prefixLength;
                    i += 2;
                }
            }
            Strings.markMatchingRegions(styledDisplayString, 0, matchingRegions, boldStylerProvider.getBoldStyler());
        }
        return styledDisplayString;
    }
}

