/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.lens;

import fr.inria.zvtm.lens.BLinearLens;

public class HWaveLens
extends BLinearLens {
    float N = 5.0f;

    public HWaveLens() {
    }

    public HWaveLens(float mm, float n) {
        super(mm);
        this.N = n;
    }

    public HWaveLens(float mm, float tc, float tf, int outerRadius, int innerRadius, float n) {
        super(mm, tc, tf, outerRadius, innerRadius);
        this.N = n;
    }

    public HWaveLens(float mm, float tc, float tf, int outerRadius, int innerRadius, float n, int x, int y) {
        super(mm, tc, tf, outerRadius, innerRadius, x, y);
        this.N = n;
    }

    public void setN(float n) {
        this.N = n;
        this.bT = (float)this.LR2 / this.N;
    }

    public float getN() {
        return this.N;
    }

    @Override
    void computeDropoffFactors() {
        this.aT = this.MMTf - this.MMTc;
        this.bT = (float)this.LR2 / this.N;
    }

    @Override
    public void gf(float x, float y, float[] g) {
        this.d = Math.sqrt((x - (float)this.sw - (float)this.lx) * (x - (float)this.sw - (float)this.lx) + (y - (float)this.sh - (float)this.ly) * (y - (float)this.sh - (float)this.ly));
        if (this.d <= (double)this.LR2) {
            g[0] = g[1] = this.MM;
        } else if (this.d <= (double)this.LR1) {
            g[0] = g[1] = (float)((double)(this.MM - 1.0f) * Math.sin(this.d / (double)this.N - (double)((float)this.LR2 / this.N)) / (this.d / (double)this.N - (double)((float)this.LR2 / this.N)) + 1.0);
            if (g[0] < 1.0f) {
                g[1] = 1.0f;
                g[0] = 1.0f;
            }
        } else {
            g[1] = 1.0f;
            g[0] = 1.0f;
        }
    }

    @Override
    public void gfT(float x, float y, float[] g) {
        this.d = Math.sqrt((x - (float)this.sw - (float)this.lx) * (x - (float)this.sw - (float)this.lx) + (y - (float)this.sh - (float)this.ly) * (y - (float)this.sh - (float)this.ly));
        if (this.d <= (double)this.LR2) {
            g[0] = this.MMTf;
        } else if (this.d <= (double)this.LR1) {
            g[0] = (float)((double)this.aT * Math.sin(this.d / (double)this.N - (double)this.bT) / (this.d / (double)this.N - (double)this.bT) + (double)this.MMTc);
            if (g[0] < this.MMTc) {
                g[0] = this.MMTc;
            }
        } else {
            g[0] = 0.0f;
        }
    }
}

