/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.VImage;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class RImage<T>
extends VImage {
    static float REFLECTION_HEIGHT_RATIO = 0.5f;
    static float REFLECTION_MASK_ALPHA_BASE = 0.2f;
    static float REFLECTION_MASK_ALPHA_EDGE = 0.0f;
    boolean irihc = false;

    public static void setReflectionHeight(float ratio) {
        REFLECTION_HEIGHT_RATIO = ratio;
    }

    public static void setReflectionMaskEndPoints(float base, float edge) {
        REFLECTION_MASK_ALPHA_BASE = base;
        REFLECTION_MASK_ALPHA_EDGE = edge;
    }

    public RImage(Image img, float alpha) {
        super(img);
        this.setTranslucencyValue(alpha);
        this.image = RImage.createReflection(img);
    }

    public RImage(double x, double y, int z, Image img, float alpha) {
        super(x, y, z, img, 1.0, alpha);
        this.image = RImage.createReflection(img);
    }

    public RImage(double x, double y, int z, Image img, double scale, float alpha) {
        super(x, y, z, img, scale, alpha);
        this.image = RImage.createReflection(img);
    }

    public RImage(double x, double y, int z, Image img, double scale, float alpha, boolean hir) {
        super(x, y, z, img, scale, alpha);
        this.image = RImage.createReflection(img);
        this.irihc = hir;
        if (this.irihc) {
            // empty if block
        }
    }

    public boolean includesReflectionInHeightComputation() {
        return this.irihc;
    }

    @Override
    public void setImage(Image i) {
        this.image = RImage.createReflection(i);
        this.vw = Math.round(this.image.getWidth(null));
        this.vh = Math.round((double)this.image.getHeight(null) / 2.0);
        this.ar = this.vw / this.vh;
        this.computeSize();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public double getHeight() {
        return this.irihc ? this.vh : this.vh / 2.0;
    }

    @Override
    public Object clone() {
        RImage<T> res = new RImage<T>(this.vx, this.vy, this.vz, this.image, this.alphaC != null ? this.alphaC.getAlpha() : 1.0f);
        res.setWidth(this.vw);
        res.setHeight(this.vh);
        res.borderColor = this.borderColor;
        res.cursorInsideColor = this.cursorInsideColor;
        res.bColor = this.bColor;
        res.setZoomSensitive(this.zoomSensitive);
        return res;
    }

    public static BufferedImage getBufferedImageFromFile(File f) {
        try {
            return ImageIO.read(f);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static BufferedImage createReflection(Image src) {
        return RImage.createReflection(src, new GradientPaint(0.0f, 0.0f, new Color(1.0f, 1.0f, 1.0f, REFLECTION_MASK_ALPHA_BASE), 0.0f, Math.round((float)src.getHeight(null) * REFLECTION_HEIGHT_RATIO), new Color(1.0f, 1.0f, 1.0f, REFLECTION_MASK_ALPHA_EDGE)));
    }

    public static BufferedImage createReflection(Image src, GradientPaint mask) {
        int height = src.getHeight(null);
        BufferedImage target = new BufferedImage(src.getWidth(null), height * 2, 2);
        Graphics2D g2 = target.createGraphics();
        g2.drawImage(src, 0, 0, null);
        g2.scale(1.0, -1.0);
        g2.drawImage(src, 0, -height - height, null);
        g2.scale(1.0, -1.0);
        g2.translate(0, height);
        g2.setPaint(mask);
        g2.setComposite(AlphaComposite.DstIn);
        g2.fillRect(0, 0, src.getWidth(null), height);
        g2.dispose();
        return target;
    }
}

