/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.page.debug;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.api.ILaunchConfigurationGUIelement;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.efm.execution.configuration.common.ui.editors.BooleanFieldEditor;
import org.eclipse.efm.execution.configuration.common.ui.editors.StringFieldEditor;
import org.eclipse.efm.execution.core.SymbexPreferenceUtil;
import org.eclipse.efm.execution.core.workflow.common.ConsoleVerbosityKind;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class DebugConfigurationPage
extends AbstractConfigurationPage {
    private static final String[] CONSOLE_LEVEL_COMBO_ITEMS = new String[]{ConsoleVerbosityKind.SILENT.getLiteral(), ConsoleVerbosityKind.MINIMUM.getLiteral(), ConsoleVerbosityKind.MEDIUM.getLiteral(), ConsoleVerbosityKind.MAXIMUM.getLiteral()};
    private Combo fConsoleLevelCombo = null;
    private ConsoleVerbosityKind fConsoleLevel = ConsoleVerbosityKind.MINIMUM;
    private BooleanFieldEditor fFirstParsedModelTextualEnabledBooleanField;
    private BooleanFieldEditor fFirstParsedModelGraphizEnabledBooleanField;
    private BooleanFieldEditor fFirstCompiledModelTextualEnabledBooleanField;
    private boolean fEnabledSymbexDeveloperMode;
    private BooleanFieldEditor fFirstSymbexOutputTextualEnabledBooleanField;
    private BooleanFieldEditor fFirstSymbexOutputGraphizEnabledBooleanField;
    private Group fGroupFirstSymbexOutputTrace;
    private Group fGroupFirstSymbexOutputFormat;
    private StringFieldEditor fFirstSymbexOutputGraphizTraceStringField;
    private StringFieldEditor fFirstSymbexOutputGraphizFormatStringField;
    private Group fGroupSecondStageSymbexWorkflow;
    private Group fGroupSymbexOutputGeneratedTraces;
    private BooleanFieldEditor fSecondSymbexOutputTextualEnabledBooleanField;
    private BooleanFieldEditor fSecondSymbexOutputGraphizEnabledBooleanField;
    private Group fGroupSecondSymbexOutputTrace;
    private Group fGroupSecondSymbexOutputFormat;
    private StringFieldEditor fSecondSymbexOutputGraphizTraceStringField;
    private StringFieldEditor fSecondSymbexOutputGraphizFormatStringField;
    private TabListener fListener = new TabListener();

    public DebugConfigurationPage(ILaunchConfigurationGUIelement masterGUIelement) {
        super(masterGUIelement);
        this.fEnabledSymbexDeveloperMode = SymbexPreferenceUtil.getBooleanPreference((String)"org.eclipse.efm.execution.core.PREF_SYMBEX_DEVELOPER_MODE");
    }

    private void handleConsoleLevelSelectionChange() {
        this.fConsoleLevel = ConsoleVerbosityKind.get((String)this.fConsoleLevelCombo.getText());
        if (this.fConsoleLevel == null) {
            this.fConsoleLevel = ConsoleVerbosityKind.MINIMUM;
        }
        this.propagateGUIupdate();
    }

    @Override
    protected void createContent(Composite parent, IWidgetToolkit widgetToolkit) {
        this.createDebugTracePage(parent, widgetToolkit);
    }

    private void createDebugTracePage(Composite parent, IWidgetToolkit widgetToolkit) {
        Group group = widgetToolkit.createGroup(parent, "Debug Trace", 1, 1, 768);
        this.createConsoleLogComponent((Composite)group, widgetToolkit);
        this.createFirstSymbexWorkflowPage((Composite)group, widgetToolkit);
        this.createSecondSymbexWorkflowtPage((Composite)group, widgetToolkit);
    }

    private void createConsoleLogComponent(Composite parent, IWidgetToolkit widgetToolkit) {
        Group group = widgetToolkit.createGroup(parent, "Console Log", 2, 1, 768);
        widgetToolkit.createLabel((Composite)group, "&Verbose Level :", 1);
        this.fConsoleLevelCombo = widgetToolkit.createCombo((Composite)group, 12, 1, CONSOLE_LEVEL_COMBO_ITEMS);
        this.fConsoleLevelCombo.addSelectionListener((SelectionListener)this.fListener);
    }

    public void createFirstSymbexWorkflowPage(Composite parent, IWidgetToolkit widgetToolkit) {
        Group group = widgetToolkit.createGroup(parent, "First Stage Symbex Workflow Page", 1, 1, 768);
        this.createFirstInputModelGraphicComponent((Composite)group, widgetToolkit);
        this.createFirstSymbexOutputComponent((Composite)group, widgetToolkit);
    }

    private void createFirstInputModelGraphicComponent(Composite parent, IWidgetToolkit widgetToolkit) {
        Group group = widgetToolkit.createGroup(parent, "Input Model Generated Traces", 1, 1, 768);
        Composite comp = widgetToolkit.createComposite((Composite)group, 1, 1, 768);
        this.fFirstParsedModelTextualEnabledBooleanField = new BooleanFieldEditor(this, "org.eclipse.efm.execution.core.ATTR_ENABLED_FIRST_PARSED_MODEL_TEXTUAL_GENERATION", "&Parsed Model as Textual Representation", comp, false);
        this.fFirstParsedModelGraphizEnabledBooleanField = new BooleanFieldEditor(this, "org.eclipse.efm.execution.core.ATTR_ENABLED_FIRST_PARSED_MODEL_GRAPHVIZ_GENERATION", "&Parsed Model as <Graphiz> Representation", comp, false);
        if (this.fEnabledSymbexDeveloperMode) {
            this.fFirstCompiledModelTextualEnabledBooleanField = new BooleanFieldEditor(this, "org.eclipse.efm.execution.core.ATTR_ENABLED_FIRST_COMPILED_MODEL_TEXTUAL_GENERATION", "&Compiled Model as Textual Representation", comp, false);
        }
    }

    private void createFirstSymbexOutputComponent(Composite parent, IWidgetToolkit widgetToolkit) {
        Group group = widgetToolkit.createGroup(parent, "Symbex Output Generated Traces", 1, 1, 768);
        Composite comp = widgetToolkit.createComposite((Composite)group, 1, 1, 768);
        this.fFirstSymbexOutputTextualEnabledBooleanField = new BooleanFieldEditor(this, "org.eclipse.efm.execution.core.ATTR_ENABLED_FIRST_SYMBEX_OUTPUT_TEXTUAL_GENERATION", "&Basic Textual Representation", comp, false);
        group = widgetToolkit.createGroup(comp, "Symbex Output Generated Graphic Traces", 1, 1, 768);
        comp = widgetToolkit.createComposite((Composite)group, 2, 1, 768);
        this.fFirstSymbexOutputGraphizEnabledBooleanField = new BooleanFieldEditor(this, "org.eclipse.efm.execution.core.ATTR_ENABLED_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_GENERATION", "&<Graphiz> Representation", comp, false);
        this.fFirstSymbexOutputGraphizEnabledBooleanField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugConfigurationPage.this.setEnableFirstExecutionPage(DebugConfigurationPage.this.fFirstSymbexOutputGraphizEnabledBooleanField.getBooleanValue());
            }
        });
        this.fGroupFirstSymbexOutputTrace = widgetToolkit.createGroup(comp, "&Trace ", 1, 2, 1808);
        this.fFirstSymbexOutputGraphizTraceStringField = new StringFieldEditor(this, "org.eclipse.efm.execution.core.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_TRACE_SPEC", "", (Composite)this.fGroupFirstSymbexOutputTrace, "com = [*]\nvariable = [*]\n// See full grammar of [Trace Specification] at the end of this generated file", 578);
        this.fGroupFirstSymbexOutputFormat = widgetToolkit.createGroup(comp, "&Format ", 1, 2, 1808);
        this.fFirstSymbexOutputGraphizFormatStringField = new StringFieldEditor(this, "org.eclipse.efm.execution.core.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_FORMAT_SPEC", "", (Composite)this.fGroupFirstSymbexOutputFormat, "node#header = EC#%1%<Ev:%2% , H:%3%>\\n%6%\nlifeline#state = %2%:%4%\npath#condition = PC: %1%\npath#timed#condition = PtC: %1%\nnode#condition = NC: %1%\nnode#timed#condition = NtC: %1%\nassign     = %3%=%4%\nnewfresh   = newfresh(%2%:%3%) <- %4%\ninput#env  = INPUT %2%:%3%%4%\ninput#rdv  = input %2%:%3%%4%\ninput      = input %2%:%3%%4%\noutput#env = OUTPUT %2%:%3%%4%\noutput#rdv = output %2%:%3%%4%\noutput     = output %2%:%3%%4%\nroutine    = invoke %2%:%3%\ntransition = fired transition %3%\nmachine    = \"run %2%:%3%\"", 578);
    }

    private void setEnableFirstExecutionPage(boolean checked) {
        this.propagateVisibility((Composite)this.fGroupFirstSymbexOutputTrace, checked);
        this.propagateVisibility((Composite)this.fGroupFirstSymbexOutputFormat, checked);
    }

    public void createSecondSymbexWorkflowtPage(Composite parent, IWidgetToolkit widgetToolkit) {
        this.fGroupSecondStageSymbexWorkflow = widgetToolkit.createGroup(parent, "Second Stage Symbex Workflow Page", 1, 1, 768);
        this.createSecondSymbexOutputComponent((Composite)this.fGroupSecondStageSymbexWorkflow, widgetToolkit);
    }

    private void createSecondSymbexOutputComponent(Composite parent, IWidgetToolkit widgetToolkit) {
        this.fGroupSymbexOutputGeneratedTraces = widgetToolkit.createGroup(parent, "Symbex Output Generated Traces", 1, 1, 768);
        Composite comp = widgetToolkit.createComposite((Composite)this.fGroupSymbexOutputGeneratedTraces, 1, 1, 768);
        this.fSecondSymbexOutputTextualEnabledBooleanField = new BooleanFieldEditor(this, "org.eclipse.efm.execution.core.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_TEXTUAL_GENERATION", "&Basic Textual Representation", comp, false);
        Group group = widgetToolkit.createGroup(comp, "Symbex Output Generated Graphic Traces", 1, 1, 768);
        comp = widgetToolkit.createComposite((Composite)group, 1, 1, 768);
        this.fSecondSymbexOutputGraphizEnabledBooleanField = new BooleanFieldEditor(this, "org.eclipse.efm.execution.core.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_GENERATION", "&<Graphiz> Representation", comp, false);
        this.fSecondSymbexOutputGraphizEnabledBooleanField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugConfigurationPage.this.setEnableSecondExecutionPage(DebugConfigurationPage.this.fSecondSymbexOutputGraphizEnabledBooleanField.getBooleanValue());
            }
        });
        this.fGroupSecondSymbexOutputTrace = widgetToolkit.createGroup(comp, "&Trace ", 1, 2, 1808);
        this.fSecondSymbexOutputGraphizTraceStringField = new StringFieldEditor(this, "org.eclipse.efm.execution.core.ATTR_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_TRACE_SPEC", "", (Composite)this.fGroupSecondSymbexOutputTrace, "com = [*]\n// See full grammar of [Trace Specification] at the end of this generated file", 578);
        this.fGroupSecondSymbexOutputFormat = widgetToolkit.createGroup(comp, "&Format ", 1, 2, 1808);
        this.fSecondSymbexOutputGraphizFormatStringField = new StringFieldEditor(this, "org.eclipse.efm.execution.core.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_FORMAT_SPEC", "", (Composite)this.fGroupSecondSymbexOutputFormat, "node#header = EC#%1%<Ev:%2% , H:%3%>\\n%6%\nlifeline#state = %2%:%4%\npath#condition = PC: %1%\npath#timed#condition = PtC: %1%\nnode#condition = NC: %1%\nnode#timed#condition = NtC: %1%\nassign     = %3%=%4%\nnewfresh   = newfresh(%2%:%3%) <- %4%\ninput#env  = INPUT %2%:%3%%4%\ninput#rdv  = input %2%:%3%%4%\ninput      = input %2%:%3%%4%\noutput#env = OUTPUT %2%:%3%%4%\noutput#rdv = output %2%:%3%%4%\noutput     = output %2%:%3%%4%\nroutine    = invoke %2%:%3%\ntransition = fired transition %3%\nmachine    = \"run %2%:%3%\"", 578);
    }

    private void setEnableSecondExecutionPage(boolean checked) {
        this.propagateVisibility((Composite)this.fGroupSecondSymbexOutputTrace, checked);
        this.propagateVisibility((Composite)this.fGroupSecondSymbexOutputFormat, checked);
    }

    @Override
    public void setDefaultFieldValues(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_CONSOLE_LOG_VERBOSE_LEVEL", "MINIMUM");
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_FIRST_PARSED_MODEL_TEXTUAL_GENERATION", false);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_FIRST_PARSED_MODEL_TEXTUAL_FILENAME", "model_parsed.xlia");
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_FIRST_PARSED_MODEL_GRAPHVIZ_GENERATION", false);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_FIRST_PARSED_MODEL_GRAPHVIZ_FILENAME", "model_parsed_graph.gv");
        if (this.fEnabledSymbexDeveloperMode) {
            configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_FIRST_COMPILED_MODEL_TEXTUAL_GENERATION", false);
            configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_FIRST_COMPILED_MODEL_TEXTUAL_FILENAME", "phase1_compiled_model.fexe");
        }
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_FIRST_SYMBEX_OUTPUT_TEXTUAL_GENERATION", false);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_FIRST_SYMBEX_OUTPUT_TEXTUAL_FILENAME", "symbex_output.fscn");
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_GENERATION", false);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_FILENAME", "symbex_output.gv");
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_TRACE_SPEC", "com = [*]\nvariable = [*]\n// See full grammar of [Trace Specification] at the end of this generated file");
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_FORMAT_SPEC", "node#header = EC#%1%<Ev:%2% , H:%3%>\\n%6%\nlifeline#state = %2%:%4%\npath#condition = PC: %1%\npath#timed#condition = PtC: %1%\nnode#condition = NC: %1%\nnode#timed#condition = NtC: %1%\nassign     = %3%=%4%\nnewfresh   = newfresh(%2%:%3%) <- %4%\ninput#env  = INPUT %2%:%3%%4%\ninput#rdv  = input %2%:%3%%4%\ninput      = input %2%:%3%%4%\noutput#env = OUTPUT %2%:%3%%4%\noutput#rdv = output %2%:%3%%4%\noutput     = output %2%:%3%%4%\nroutine    = invoke %2%:%3%\ntransition = fired transition %3%\nmachine    = \"run %2%:%3%\"");
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SECOND_PARSED_MODEL_TEXTUAL_FILENAME", "phase2_parsed_model.xlia");
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SECOND_PARSED_MODEL_GRAPHVIZ_FILENAME", "phase2_parsed_model.gv");
        if (this.fEnabledSymbexDeveloperMode) {
            configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_SECOND_COMPILED_MODEL_TEXTUAL_GENERATION", false);
            configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SECOND_COMPILED_MODEL_TEXTUAL_FILENAME", "phase2_compiled_model.fexe");
        }
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_TEXTUAL_GENERATION", false);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SECOND_SYMBEX_OUTPUT_TEXTUAL_FILENAME", "symbex_output_extension.fscn");
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_GENERATION", false);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_FILENAME", "symbex_output_extension.gv");
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_TRACE_SPEC", "com = [*]\n// See full grammar of [Trace Specification] at the end of this generated file");
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_FORMAT_SPEC", "node#header = EC#%1%<Ev:%2% , H:%3%>\\n%6%\nlifeline#state = %2%:%4%\npath#condition = PC: %1%\npath#timed#condition = PtC: %1%\nnode#condition = NC: %1%\nnode#timed#condition = NtC: %1%\nassign     = %3%=%4%\nnewfresh   = newfresh(%2%:%3%) <- %4%\ninput#env  = INPUT %2%:%3%%4%\ninput#rdv  = input %2%:%3%%4%\ninput      = input %2%:%3%%4%\noutput#env = OUTPUT %2%:%3%%4%\noutput#rdv = output %2%:%3%%4%\noutput     = output %2%:%3%%4%\nroutine    = invoke %2%:%3%\ntransition = fired transition %3%\nmachine    = \"run %2%:%3%\"");
    }

    @Override
    public void initializeFieldValuesFrom(ILaunchConfiguration configuration) {
        try {
            this.fConsoleLevel = ConsoleVerbosityKind.get((String)configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_CONSOLE_LOG_VERBOSE_LEVEL", ConsoleVerbosityKind.MINIMUM.getLiteral()));
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.fConsoleLevel = ConsoleVerbosityKind.MINIMUM;
        }
        if (this.fConsoleLevel == null) {
            this.fConsoleLevel = ConsoleVerbosityKind.MINIMUM;
        }
        this.initializeConsoleLevel();
        this.fFirstParsedModelTextualEnabledBooleanField.initializeFrom(configuration);
        this.fFirstParsedModelGraphizEnabledBooleanField.initializeFrom(configuration);
        if (this.fEnabledSymbexDeveloperMode) {
            this.fFirstCompiledModelTextualEnabledBooleanField.initializeFrom(configuration);
        }
        this.fFirstSymbexOutputTextualEnabledBooleanField.initializeFrom(configuration);
        this.fFirstSymbexOutputGraphizEnabledBooleanField.initializeFrom(configuration);
        this.fFirstSymbexOutputGraphizTraceStringField.initializeFrom(configuration);
        this.fFirstSymbexOutputGraphizFormatStringField.initializeFrom(configuration);
        this.fSecondSymbexOutputTextualEnabledBooleanField.initializeFrom(configuration);
        this.fSecondSymbexOutputGraphizEnabledBooleanField.initializeFrom(configuration);
        this.fSecondSymbexOutputGraphizTraceStringField.initializeFrom(configuration);
        this.fSecondSymbexOutputGraphizFormatStringField.initializeFrom(configuration);
        this.setEnableFirstExecutionPage(this.fFirstSymbexOutputGraphizEnabledBooleanField.getBooleanValue());
        this.setEnableSecondExecutionPage(this.fSecondSymbexOutputGraphizEnabledBooleanField.getBooleanValue());
        try {
            this.propagateVisibility((Composite)this.fGroupSecondStageSymbexWorkflow, configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_TRACE_EXTENSION", false));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void initializeConsoleLevel() {
        switch (this.fConsoleLevel) {
            case SILENT: {
                this.fConsoleLevelCombo.select(0);
                break;
            }
            case MINIMUM: {
                this.fConsoleLevelCombo.select(1);
                break;
            }
            case MEDIUM: {
                this.fConsoleLevelCombo.select(2);
                break;
            }
            case MAXIMUM: {
                this.fConsoleLevelCombo.select(3);
                break;
            }
            default: {
                this.fConsoleLevelCombo.select(0);
            }
        }
    }

    @Override
    public void applyUpdatesOnFieldValuesFrom(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_CONSOLE_LOG_VERBOSE_LEVEL", this.fConsoleLevel.getLiteral());
        this.fFirstParsedModelTextualEnabledBooleanField.performApply(configuration);
        this.fFirstParsedModelGraphizEnabledBooleanField.performApply(configuration);
        if (this.fEnabledSymbexDeveloperMode) {
            this.fFirstCompiledModelTextualEnabledBooleanField.performApply(configuration);
        }
        this.fFirstSymbexOutputTextualEnabledBooleanField.performApply(configuration);
        this.fFirstSymbexOutputGraphizEnabledBooleanField.performApply(configuration);
        this.fFirstSymbexOutputGraphizTraceStringField.performApply(configuration);
        this.fFirstSymbexOutputGraphizFormatStringField.performApply(configuration);
        this.fSecondSymbexOutputTextualEnabledBooleanField.performApply(configuration);
        this.fSecondSymbexOutputGraphizEnabledBooleanField.performApply(configuration);
        this.fSecondSymbexOutputGraphizTraceStringField.performApply(configuration);
        this.fSecondSymbexOutputGraphizFormatStringField.performApply(configuration);
        this.setEnableFirstExecutionPage(this.fFirstSymbexOutputGraphizEnabledBooleanField.getBooleanValue());
        this.setEnableSecondExecutionPage(this.fSecondSymbexOutputGraphizEnabledBooleanField.getBooleanValue());
    }

    @Override
    public AbstractConfigurationPage.FieldValidationReturn areFieldsValid(ILaunchConfiguration launchConfig) {
        return new AbstractConfigurationPage.FieldValidationReturn(true, null);
    }

    @Override
    protected void handleConfigurationPropertyChange(PropertyChangeEvent event) {
        switch (event.getProperty()) {
            case "org.eclipse.efm.execution.core.ATTR_ENABLED_TRACE_EXTENSION": {
                this.propagateVisibility((Composite)this.fGroupSecondStageSymbexWorkflow, (Boolean)event.getNewValue());
                break;
            }
        }
    }

    private class TabListener
    extends SelectionAdapter
    implements ModifyListener {
        private TabListener() {
        }

        public void modifyText(ModifyEvent e) {
            DebugConfigurationPage.this.propagateGUIupdate();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == DebugConfigurationPage.this.fConsoleLevelCombo) {
                DebugConfigurationPage.this.handleConsoleLevelSelectionChange();
            }
        }
    }
}

