/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.linkedlist.ExposedNodeLinkedList;
import org.eclipse.persistence.internal.identitymaps.CacheIdentityMap;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.identitymaps.HardCacheWeakIdentityMap;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.identitymaps.NoIdentityMap;
import org.eclipse.persistence.internal.identitymaps.SoftCacheWeakIdentityMap;
import org.eclipse.persistence.internal.identitymaps.SoftIdentityMap;
import org.eclipse.persistence.internal.identitymaps.WeakIdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.platform.server.JMXEnabledPlatform;
import org.eclipse.persistence.services.ClassSummaryDetailBase;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.profiler.PerformanceProfiler;

public abstract class RuntimeServices {
    protected Session session;
    private int deployedSessionProfileWeight;
    private SessionLog deployedSessionLog;
    public String objectName;
    protected static final String EclipseLink_Product_Name = "EclipseLink";
    protected static String PLATFORM_NAME = "Server";

    protected RuntimeServices() {
    }

    protected RuntimeServices(Session session) {
        this.session = session;
    }

    protected AbstractSession getSession() {
        return (AbstractSession)this.session;
    }

    public String getSessionName() {
        return this.getSession().getName();
    }

    public boolean getShouldLogMessages() {
        return this.getSession().shouldLogMessages();
    }

    public void setShouldProfilePerformance(boolean shouldProfile) {
        if (shouldProfile && this.getSession().getProfiler() == null) {
            this.getSession().setProfiler(new PerformanceProfiler());
        } else if (!shouldProfile) {
            this.getSession().setProfiler(null);
        }
    }

    public boolean getShouldProfilePerformance() {
        return this.getSession().getProfiler() != null && ClassConstants.PerformanceProfiler_Class.isAssignableFrom(this.getSession().getProfiler().getClass());
    }

    public void setShouldLogPerformanceProfiler(boolean shouldLogPerformanceProfiler) {
        if (this.getSession().getProfiler() != null && ClassConstants.PerformanceProfiler_Class.isAssignableFrom(this.getSession().getProfiler().getClass())) {
            ((PerformanceProfiler)this.getSession().getProfiler()).setShouldLogProfile(shouldLogPerformanceProfiler);
        }
    }

    public boolean getShouldLogPerformanceProfiler() {
        if (this.getSession().getProfiler() != null && ClassConstants.PerformanceProfiler_Class.isAssignableFrom(this.getSession().getProfiler().getClass())) {
            return ((PerformanceProfiler)this.getSession().getProfiler()).shouldLogProfile();
        }
        return false;
    }

    public void setShouldCacheAllStatements(boolean shouldCacheAllStatements) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setShouldCacheAllStatements(shouldCacheAllStatements);
    }

    public void setStatementCacheSize(int size) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setStatementCacheSize(size);
    }

    public int getStatementCacheSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return 0;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).getStatementCacheSize();
    }

    public void setSequencePreallocationSize(int size) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatasourcePlatform)this.getSession().getDatasourcePlatform()).setSequencePreallocationSize(size);
    }

    public int getSequencePreallocationSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return 0;
        }
        return ((DatasourcePlatform)this.getSession().getDatasourcePlatform()).getSequencePreallocationSize();
    }

    public void updatePoolSize(String poolName, int maxSize, int minSize) {
        ConnectionPool connectionPool;
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass()) && (connectionPool = ((ServerSession)this.getSession()).getConnectionPool(poolName)) != null) {
            connectionPool.setMaxNumberOfConnections(maxSize);
            connectionPool.setMinNumberOfConnections(minSize);
        }
    }

    public List<String> getAvailableConnectionPools() {
        ArrayList<String> list = null;
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            Map<String, ConnectionPool> pools = ((ServerSession)this.getSession()).getConnectionPools();
            list = new ArrayList(pools.size());
            list.addAll(pools.keySet());
        } else {
            list = new ArrayList<String>();
        }
        return list;
    }

    public List<Integer> getSizeForPool(String poolName) {
        ConnectionPool connectionPool;
        ArrayList<Integer> results = new ArrayList<Integer>(2);
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass()) && (connectionPool = ((ServerSession)this.getSession()).getConnectionPool(poolName)) != null) {
            results.add(connectionPool.getMaxNumberOfConnections());
            results.add(connectionPool.getMinNumberOfConnections());
        }
        return results;
    }

    public void addNewConnectionPool(String poolName, int maxSize, int minSize, String platform, String driverClassName, String url, String userName, String password) throws ClassNotFoundException {
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            DatabaseLogin login = new DatabaseLogin();
            login.setPlatformClassName(platform);
            login.setDriverClassName(driverClassName);
            login.setConnectionString(url);
            login.setUserName(userName);
            login.setEncryptedPassword(password);
            ((ServerSession)this.getSession()).addConnectionPool(poolName, login, minSize, maxSize);
        }
    }

    public void resetAllConnections() {
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            for (ConnectionPool pool : ((ServerSession)this.getSession()).getConnectionPools().values()) {
                pool.shutDown();
                pool.startUp();
            }
        } else if (ClassConstants.PublicInterfaceDatabaseSession_Class.isAssignableFrom(this.getSession().getClass())) {
            this.getSession().getAccessor().reestablishConnection(this.getSession());
        }
    }

    public List<String> getClassesInSession() {
        return this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
    }

    public List<Object> getObjectsInIdentityMap(String className) throws ClassNotFoundException {
        Class classToChange = this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, CoreClassConstants.CLASS);
        IdentityMap map = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(classToChange);
        ArrayList<Object> results = new ArrayList<Object>(map.getSize());
        Enumeration<CacheKey> objects = map.keys();
        while (objects.hasMoreElements()) {
            results.add(objects.nextElement().getObject());
        }
        return results;
    }

    public Integer getNumberOfObjectsInIdentityMap(String className) throws ClassNotFoundException {
        Class classToChange = this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, CoreClassConstants.CLASS);
        return this.getSession().getIdentityMapAccessorInstance().getIdentityMap(classToChange).getSize();
    }

    public List getObjectsInIdentityMapSubCacheAsMap(String className) throws ClassNotFoundException {
        Class classToChange = this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, CoreClassConstants.CLASS);
        IdentityMap map = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(classToChange);
        List subCache = new ArrayList(0);
        if (ClassConstants.HardCacheWeakIdentityMap_Class.isAssignableFrom(map.getClass())) {
            subCache = ((HardCacheWeakIdentityMap)map).getReferenceCache();
        }
        return subCache;
    }

    public Integer getNumberOfObjectsInIdentityMapSubCache(String className) throws ClassNotFoundException {
        Integer result = 0;
        Class classToChange = this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, CoreClassConstants.CLASS);
        IdentityMap map = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(classToChange);
        if (map.getClass().isAssignableFrom(ClassConstants.HardCacheWeakIdentityMap_Class)) {
            ExposedNodeLinkedList subCache = ((HardCacheWeakIdentityMap)map).getReferenceCache();
            result = subCache.size();
        }
        return result;
    }

    public int getLogLevel(String category) {
        return this.getSession().getLogLevel(category);
    }

    public void setLogLevel(int level) {
        this.getSession().setLogLevel(level);
    }

    public boolean shouldLog(int Level2, String category) {
        return this.getSession().shouldLog(Level2, category);
    }

    public int getProfileWeight() {
        if (this.getSession().isInProfile()) {
            return this.getSession().getProfiler().getProfileWeight();
        }
        return 0;
    }

    public void setProfileWeight(int weight) {
        if (this.getSession().isInProfile()) {
            this.getSession().getProfiler().setProfileWeight(weight);
        }
    }

    public synchronized void initializeIdentityMap(String className) throws ClassNotFoundException {
        Class registeredClass = this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, CoreClassConstants.CLASS);
        this.getSession().getIdentityMapAccessor().initializeIdentityMap(registeredClass);
        ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_initialized", className);
    }

    public void printIdentityMapLocks() {
        this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().printLocks();
    }

    public void printIdentityMapLocks(String registeredClassName) {
        Class registeredClass = this.getSession().getDatasourcePlatform().getConversionManager().convertObject(registeredClassName, CoreClassConstants.CLASS);
        this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().printLocks(registeredClass);
    }

    public void printProfileSummary() {
        if (!this.getUsesEclipseLinkProfiling().booleanValue()) {
            return;
        }
        PerformanceProfiler performanceProfiler = (PerformanceProfiler)this.getSession().getProfiler();
        this.getSession().getSessionLog().info(performanceProfiler.buildProfileSummary().toString());
    }

    private String trimProfileString(String originalProfileString) {
        if (originalProfileString.length() > 1) {
            String trimmedString = originalProfileString;
            if (trimmedString.charAt(0) == '{' && trimmedString.charAt(trimmedString.length() - 1) == '}') {
                trimmedString = trimmedString.substring(1, trimmedString.length() - 1);
            }
            return trimmedString;
        }
        return originalProfileString;
    }

    public void printProfileSummaryByClass() {
        if (!this.getUsesEclipseLinkProfiling().booleanValue()) {
            return;
        }
        PerformanceProfiler performanceProfiler = (PerformanceProfiler)this.getSession().getProfiler();
        this.getSession().getSessionLog().info(this.trimProfileString(performanceProfiler.buildProfileSummaryByClass().toString()));
    }

    public void printProfileSummaryByQuery() {
        if (!this.getUsesEclipseLinkProfiling().booleanValue()) {
            return;
        }
        PerformanceProfiler performanceProfiler = (PerformanceProfiler)this.getSession().getProfiler();
        this.getSession().getSessionLog().info(this.trimProfileString(performanceProfiler.buildProfileSummaryByQuery().toString()));
    }

    public synchronized String getProfilingType() {
        if (this.getUsesEclipseLinkProfiling().booleanValue()) {
            return EclipseLink_Product_Name;
        }
        return "None";
    }

    public synchronized void setProfilingType(String profileType) {
        if (profileType == null || profileType.compareToIgnoreCase("None") == 0) {
            this.setUseNoProfiling();
        } else if (profileType.compareToIgnoreCase(EclipseLink_Product_Name) == 0) {
            this.setUseEclipseLinkProfiling();
        }
    }

    public void setUseEclipseLinkProfiling() {
        if (this.getUsesEclipseLinkProfiling().booleanValue()) {
            return;
        }
        this.getSession().setProfiler(new PerformanceProfiler());
    }

    public void setUseNoProfiling() {
        this.getSession().setProfiler(null);
    }

    public Boolean getUsesEclipseLinkProfiling() {
        return this.getSession().getProfiler() instanceof PerformanceProfiler;
    }

    public String getDeployedEclipseLinkLogLevel() {
        return this.getNameForLogLevel(this.getDeployedSessionLog().getLevel());
    }

    public String getCurrentEclipseLinkLogLevel() {
        return this.getNameForLogLevel(this.getSession().getSessionLog().getLevel());
    }

    public synchronized void setCurrentEclipseLinkLogLevel(String newLevel) {
        this.getSession().setLogLevel(this.getLogLevelForName(newLevel));
    }

    private String getNameForLogLevel(int logLevel) {
        return switch (logLevel) {
            case 0 -> SessionLog.ALL_LABEL;
            case 7 -> SessionLog.SEVERE_LABEL;
            case 6 -> SessionLog.WARNING_LABEL;
            case 5 -> SessionLog.INFO_LABEL;
            case 4 -> SessionLog.CONFIG_LABEL;
            case 3 -> SessionLog.FINE_LABEL;
            case 2 -> SessionLog.FINER_LABEL;
            case 1 -> SessionLog.FINEST_LABEL;
            case 8 -> SessionLog.OFF_LABEL;
            default -> "N/A";
        };
    }

    private int getLogLevelForName(String levelName) {
        if (levelName.equals(SessionLog.ALL_LABEL)) {
            return 0;
        }
        if (levelName.equals(SessionLog.SEVERE_LABEL)) {
            return 7;
        }
        if (levelName.equals(SessionLog.WARNING_LABEL)) {
            return 6;
        }
        if (levelName.equals(SessionLog.INFO_LABEL)) {
            return 5;
        }
        if (levelName.equals(SessionLog.CONFIG_LABEL)) {
            return 4;
        }
        if (levelName.equals(SessionLog.FINE_LABEL)) {
            return 3;
        }
        if (levelName.equals(SessionLog.FINER_LABEL)) {
            return 2;
        }
        if (levelName.equals(SessionLog.FINEST_LABEL)) {
            return 1;
        }
        return 8;
    }

    protected void updateDeploymentTimeData() {
        this.deployedSessionLog = (SessionLog)this.session.getSessionLog().clone();
        this.deployedSessionProfileWeight = this.session.getProfiler() == null ? -1 : this.session.getProfiler().getProfileWeight();
    }

    public int getDeployedSessionProfileWeight() {
        return this.deployedSessionProfileWeight;
    }

    public SessionLog getDeployedSessionLog() {
        return this.deployedSessionLog;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isJPASession() {
        return true;
    }

    public String getSessionType() {
        return this.getSession().getClass().getSimpleName();
    }

    public Object[][] getClassSummaryDetailsUsingFilter(String filter) {
        try {
            return this.tabularDataTo2DArray(this.buildClassSummaryDetailsUsingFilter(filter), new String[]{"Class Name", "Parent Class Name", "Cache Type", "Configured Size", "Current Size"});
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "jmx_enabled_platform_mbean_runtime_exception", PLATFORM_NAME, (Object)exception);
            return null;
        }
    }

    public Object[][] getClassSummaryDetails() {
        try {
            return this.tabularDataTo2DArray(this.buildClassSummaryDetails(), new String[]{"Class Name", "Parent Class Name", "Cache Type", "Configured Size", "Current Size"});
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "jmx_enabled_platform_mbean_runtime_exception", PLATFORM_NAME, (Object)exception);
            return null;
        }
    }

    private List<String> getMappedClassNames() {
        HashMap<String, Boolean> alreadyAdded = new HashMap<String, Boolean>();
        ArrayList<String> mappedClassNames = new ArrayList<String>();
        String mappedClassName = null;
        for (ClassDescriptor nextDescriptor : this.getSession().getProject().getDescriptors().values()) {
            if (nextDescriptor.getCMPPolicy() != null && nextDescriptor.getCMPPolicy().getMappedClass() != null) {
                mappedClassName = nextDescriptor.getCMPPolicy().getMappedClass().getName();
            }
            if (mappedClassName == null) {
                mappedClassName = nextDescriptor.getJavaClassName();
            }
            if (alreadyAdded.get(mappedClassName) == null) {
                alreadyAdded.put(mappedClassName, Boolean.TRUE);
                mappedClassNames.add(mappedClassName);
            }
            mappedClassName = null;
        }
        return mappedClassNames;
    }

    public List<String> getMappedClassNamesUsingFilter(String filter) {
        ArrayList<String> outputVector = new ArrayList<String>();
        List<String> mappedClassNames = this.getMappedClassNames();
        ArrayList<String> filters = new ArrayList<String>();
        StringTokenizer lineTokens = new StringTokenizer(filter, ",");
        while (lineTokens.hasMoreTokens()) {
            filters.add(lineTokens.nextToken());
        }
        for (int i = 0; i < mappedClassNames.size(); ++i) {
            String className = mappedClassNames.get(i);
            String classNameLowerCase = mappedClassNames.get(i).toLowerCase();
            for (int j = 0; j < filters.size(); ++j) {
                String filterValue = Helper.rightTrimString((String)filters.get(j)).trim().toLowerCase();
                if (filterValue.indexOf(42) == 0) {
                    filterValue = filterValue.substring(1);
                }
                try {
                    if (!classNameLowerCase.matches("^.*" + filterValue + ".*$") || outputVector.contains(className)) continue;
                    outputVector.add(className);
                    continue;
                }
                catch (PatternSyntaxException exception) {
                    AbstractSessionLog.getLog().log(1, "pattern_syntax_error", exception);
                }
            }
        }
        Collections.sort(outputVector);
        return outputVector;
    }

    protected String getCacheTypeFor(Class<?> identityMapClass) {
        if (identityMapClass == CacheIdentityMap.class) {
            return "Cache";
        }
        if (identityMapClass == FullIdentityMap.class) {
            return "Full";
        }
        if (identityMapClass == HardCacheWeakIdentityMap.class) {
            return "HardWeak";
        }
        if (identityMapClass == NoIdentityMap.class) {
            return "None";
        }
        if (identityMapClass == SoftCacheWeakIdentityMap.class) {
            return "SoftWeak";
        }
        if (identityMapClass == WeakIdentityMap.class) {
            return "Weak";
        }
        if (identityMapClass == SoftIdentityMap.class) {
            return "Soft";
        }
        return "N/A";
    }

    public String getModuleName() {
        return this.getSession().getServerPlatform().getModuleName();
    }

    public String getApplicationName() {
        return ((JMXEnabledPlatform)((Object)this.getSession().getServerPlatform())).getApplicationName();
    }

    public Boolean getShouldBindAllParameters() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return Boolean.FALSE;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).shouldBindAllParameters();
    }

    public Integer getStringBindingSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return 0;
        }
        if (!this.getSession().getDatasourceLogin().getPlatform().usesStringBinding()) {
            return 0;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).getStringBindingSize();
    }

    public Boolean getUsesBatchWriting() {
        return this.getSession().getDatasourceLogin().getPlatform().usesBatchWriting();
    }

    public Long getTimeConnectionEstablished() {
        return ((DatabaseSessionImpl)this.getSession()).getConnectedTime();
    }

    public Boolean getUsesJDBCBatchWriting() {
        if (!(this.getSession().getDatasourceLogin().getDatasourcePlatform() instanceof DatabasePlatform)) {
            return Boolean.FALSE;
        }
        return this.getSession().getDatasourceLogin().getPlatform().usesJDBCBatchWriting();
    }

    public Boolean getUsesByteArrayBinding() {
        if (!(this.getSession().getDatasourceLogin().getDatasourcePlatform() instanceof DatabasePlatform)) {
            return Boolean.FALSE;
        }
        return this.getSession().getDatasourceLogin().getPlatform().usesByteArrayBinding();
    }

    public Boolean getUsesNativeSQL() {
        if (!(this.getSession().getDatasourceLogin().getDatasourcePlatform() instanceof DatabasePlatform)) {
            return Boolean.FALSE;
        }
        return this.getSession().getDatasourceLogin().getPlatform().usesNativeSQL();
    }

    public Boolean getUsesStreamsForBinding() {
        if (!(this.getSession().getDatasourceLogin().getDatasourcePlatform() instanceof DatabasePlatform)) {
            return Boolean.FALSE;
        }
        return this.getSession().getDatasourceLogin().getPlatform().usesStreamsForBinding();
    }

    public Boolean getUsesStringBinding() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return Boolean.FALSE;
        }
        return this.getSession().getDatasourceLogin().getPlatform().usesStringBinding();
    }

    public boolean getShouldCacheAllStatements() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return Boolean.FALSE;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).shouldCacheAllStatements();
    }

    public synchronized void clearStatementCache() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseAccessor)this.getSession().getAccessor()).clearStatementCache(this.getSession());
        ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_statement_cache_cleared");
    }

    public void printAvailableConnectionPools() {
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            Map<String, ConnectionPool> pools = ((ServerSession)this.getSession()).getConnectionPools();
            for (String poolName : pools.keySet()) {
                ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_pool_name", poolName);
            }
        } else {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_connection_pools_available");
        }
    }

    public Integer getMaxSizeForPool(String poolName) {
        ConnectionPool connectionPool;
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass()) && (connectionPool = ((ServerSession)this.getSession()).getConnectionPool(poolName)) != null) {
            return connectionPool.getMaxNumberOfConnections();
        }
        return -1;
    }

    public Integer getMinSizeForPool(String poolName) {
        ConnectionPool connectionPool;
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass()) && (connectionPool = ((ServerSession)this.getSession()).getConnectionPool(poolName)) != null) {
            return connectionPool.getMinNumberOfConnections();
        }
        return -1;
    }

    public void printClassesInSession() {
        List<String> classes = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        if (classes.isEmpty()) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_classes_in_session");
            return;
        }
        for (int index = 0; index < classes.size(); ++index) {
            this.getSession().getSessionLog().log(1, classes.get(index));
        }
    }

    public void printObjectsInIdentityMap(String className) throws ClassNotFoundException {
        Class classWithMap = this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, CoreClassConstants.CLASS);
        IdentityMap map = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(classWithMap);
        if (null == map) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_non_existent", className);
            return;
        }
        Enumeration<CacheKey> objects = map.keys();
        if (!objects.hasMoreElements()) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_empty", className);
        }
        while (objects.hasMoreElements()) {
            CacheKey cacheKey = objects.nextElement();
            if (null == cacheKey || null == cacheKey.getKey() || null == cacheKey.getObject()) continue;
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_print_cache_key_value", cacheKey.getKey().toString(), cacheKey.getObject().toString());
        }
    }

    public void printAllIdentityMapTypes() {
        List<String> classesRegistered = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        if (classesRegistered.isEmpty()) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_identity_maps_in_session");
            return;
        }
        for (int index = 0; index < classesRegistered.size(); ++index) {
            String registeredClassName = classesRegistered.get(index);
            Class registeredClass = this.getSession().getDatasourcePlatform().getConversionManager().convertObject(registeredClassName, CoreClassConstants.CLASS);
            IdentityMap map = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(registeredClass);
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_class", registeredClassName, map.getClass());
        }
    }

    public void printObjectsInIdentityMaps() {
        List<String> classesRegistered = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        if (classesRegistered.isEmpty()) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_identity_maps_in_session");
            return;
        }
        for (int index = 0; index < classesRegistered.size(); ++index) {
            String registeredClassName = classesRegistered.get(index);
            try {
                this.printObjectsInIdentityMap(registeredClassName);
                continue;
            }
            catch (ClassNotFoundException classNotFound) {
                classNotFound.printStackTrace();
                AbstractSessionLog.getLog().log(7, "jmx_enabled_platform_mbean_runtime_exception", PLATFORM_NAME, (Object)classNotFound);
            }
        }
    }

    public Integer getNumberOfObjectsInAllIdentityMaps() {
        List<String> classesRegistered = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        int sum = 0;
        if (classesRegistered.isEmpty()) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_identity_maps_in_session");
            return 0;
        }
        for (int index = 0; index < classesRegistered.size(); ++index) {
            String registeredClassName = classesRegistered.get(index);
            try {
                sum += this.getNumberOfObjectsInIdentityMap(registeredClassName).intValue();
                continue;
            }
            catch (ClassNotFoundException classNotFound) {
                classNotFound.printStackTrace();
                AbstractSessionLog.getLog().log(7, "jmx_enabled_platform_mbean_runtime_exception", PLATFORM_NAME, (Object)classNotFound);
            }
        }
        return sum;
    }

    public Integer getNumberOfPersistentClasses() {
        HashMap<String, Boolean> classesTable = new HashMap<String, Boolean>();
        for (ClassDescriptor currentDescriptor : this.getSession().getProject().getDescriptors().values()) {
            if (currentDescriptor.isAggregateDescriptor()) continue;
            classesTable.put(currentDescriptor.getJavaClassName(), Boolean.TRUE);
        }
        return classesTable.size();
    }

    public String getLogType() {
        if (this.getSession().getSessionLog().getClass() == DefaultSessionLog.class) {
            return EclipseLink_Product_Name;
        }
        return this.getSession().getSessionLog().getClass().getSimpleName();
    }

    public String getDatabasePlatform() {
        return this.getSession().getDatasourcePlatform().getClass().getName();
    }

    public synchronized String getJdbcConnectionDetails() {
        return this.getSession().getLogin().getConnector().getConnectionDetails();
    }

    public synchronized String getConnectionPoolType() {
        if (this.getSession().getLogin().shouldUseExternalConnectionPooling()) {
            return "External";
        }
        return "N/A";
    }

    public synchronized String getDriver() {
        if (this.getSession().getLogin().getConnector() instanceof DefaultConnector) {
            return this.getSession().getLogin().getDriverClassName();
        }
        return "N/A";
    }

    public String getLogFilename() {
        if (this.session.getSessionLog() instanceof DefaultSessionLog) {
            return ((DefaultSessionLog)this.session.getSessionLog()).getWriterFilename();
        }
        return null;
    }

    public synchronized void initializeAllIdentityMaps() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public synchronized void initializeIdentityMaps(String[] classNames) throws ClassNotFoundException {
        for (int index = 0; index < classNames.length; ++index) {
            this.initializeIdentityMap(classNames[index]);
        }
    }

    public synchronized void invalidateAllIdentityMaps() {
        List<String> classesRegistered = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        if (classesRegistered.isEmpty()) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_identity_maps_in_session");
        }
        for (int index = 0; index < classesRegistered.size(); ++index) {
            String registeredClassName = classesRegistered.get(index);
            Class registeredClass = this.getSession().getDatasourcePlatform().getConversionManager().convertObject(registeredClassName, CoreClassConstants.CLASS);
            this.getSession().getIdentityMapAccessor().invalidateClass(registeredClass);
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_invalidated", registeredClassName);
        }
    }

    public synchronized void invalidateIdentityMaps(String[] classNamesParam, Boolean recurse) throws ClassNotFoundException {
        String[] classNames = classNamesParam;
        for (int index = 0; index < classNames.length; ++index) {
            this.invalidateIdentityMap(classNames[index], recurse);
        }
    }

    public synchronized void invalidateIdentityMap(String className) throws ClassNotFoundException {
        this.invalidateIdentityMap(className, Boolean.FALSE);
    }

    public synchronized void invalidateIdentityMap(String className, Boolean recurse) throws ClassNotFoundException {
        Class registeredClass = this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, CoreClassConstants.CLASS);
        this.getSession().getIdentityMapAccessor().invalidateClass(registeredClass);
        ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_invalidated", className);
    }

    private Object[][] tabularDataTo2DArray(TabularData tdata, String[] names) throws Exception {
        if (tdata == null) {
            return null;
        }
        Object[] rows = tdata.values().toArray();
        Object[][] data = new Object[rows.length][];
        for (int i = 0; i < rows.length; ++i) {
            CompositeData cdata = (CompositeData)rows[i];
            Object[] returnRow = new Object[names.length];
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                Object value = cdata.get(name);
                returnRow[j] = name + " : " + String.valueOf(value);
            }
            data[i] = returnRow;
        }
        return data;
    }

    protected void setSession(AbstractSession newSession) {
        this.session = newSession;
        this.updateDeploymentTimeData();
    }

    private CompositeType buildCompositeTypeForClassSummaryDetails() throws OpenDataException {
        return new CompositeType("Class Details", "Details of class for Class Summary", new String[]{"Class Name", "Parent Class Name", "Cache Type", "Configured Size", "Current Size"}, new String[]{"Class Name", "Parent Class Name", "Cache Type", "Configured Size", "Current Size"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
    }

    public List<ClassSummaryDetailBase> getClassSummaryDetailsUsingFilterArray(String filter) {
        try {
            List<String> mappedClassNames = this.getMappedClassNamesUsingFilter(filter);
            ArrayList<ClassSummaryDetailBase> classSummaryDetails = new ArrayList<ClassSummaryDetailBase>();
            if (mappedClassNames.isEmpty()) {
                return null;
            }
            CompositeType type = this.buildCompositeTypeForClassSummaryDetails();
            for (int index = 0; index < mappedClassNames.size(); ++index) {
                String mappedClassName = mappedClassNames.get(index);
                Map<String, String> data = this.buildLowlevelDetailsFor(mappedClassName);
                CompositeDataSupport support = new CompositeDataSupport(type, this.buildLowlevelDetailsFor(mappedClassName));
                classSummaryDetails.add(ClassSummaryDetailBase.from(support));
            }
            return classSummaryDetails;
        }
        catch (Exception openTypeException) {
            AbstractSessionLog.getLog().log(7, "jmx_enabled_platform_mbean_runtime_exception", PLATFORM_NAME, (Object)openTypeException);
            openTypeException.printStackTrace();
            return null;
        }
    }

    public List<ClassSummaryDetailBase> getClassSummaryDetailsArray() {
        return this.getClassSummaryDetailsUsingFilterArray(".*");
    }

    private TabularType buildTabularTypeForClassSummaryDetails() throws OpenDataException {
        return new TabularType(this.getSessionName(), "Session description", this.buildCompositeTypeForClassSummaryDetails(), new String[]{"Class Name"});
    }

    private CompositeData buildDetailsFor(String mappedClassName, CompositeType detailsType) throws Exception {
        return new CompositeDataSupport(detailsType, this.buildLowlevelDetailsFor(mappedClassName));
    }

    private Map<String, String> buildLowlevelDetailsFor(String mappedClassName) {
        Class mappedClass = this.getSession().getDatasourcePlatform().getConversionManager().convertObject(mappedClassName, CoreClassConstants.CLASS);
        CoreDescriptor descriptor = this.getSession().getProject().getDescriptor(mappedClass);
        String cacheType = "";
        String configuredSize = "";
        String currentSize = "";
        String parentClassName = "";
        if (!((ClassDescriptor)descriptor).isAggregateDescriptor()) {
            IdentityMap identityMap = this.getSession().getIdentityMapAccessorInstance().getIdentityMap((ClassDescriptor)descriptor);
            cacheType = this.getCacheTypeFor(identityMap.getClass());
            configuredSize = String.valueOf(identityMap.getMaxSize());
            currentSize = String.valueOf(identityMap.getSize(mappedClass, true));
        }
        if (((ClassDescriptor)descriptor).hasInheritance() && ((ClassDescriptor)descriptor).getInheritancePolicy().getParentDescriptor() != null) {
            parentClassName = ((ClassDescriptor)descriptor).getInheritancePolicy().getParentClassName();
        }
        boolean isChildDescriptor = ((ClassDescriptor)descriptor).isChildDescriptor();
        HashMap<String, String> details = new HashMap<String, String>(5);
        details.put("Class Name", mappedClassName);
        details.put("Cache Type", isChildDescriptor ? "" : cacheType);
        details.put("Configured Size", isChildDescriptor ? "" : configuredSize);
        details.put("Current Size", currentSize);
        details.put("Parent Class Name", parentClassName);
        return details;
    }

    private TabularData buildClassSummaryDetailsUsingFilter(String filter) {
        if (filter == null) {
            return this.buildClassSummaryDetails();
        }
        try {
            List<String> mappedClassNames = this.getMappedClassNamesUsingFilter(filter);
            TabularDataSupport rowData = new TabularDataSupport(this.buildTabularTypeForClassSummaryDetails());
            if (mappedClassNames.isEmpty()) {
                return null;
            }
            for (int index = 0; index < mappedClassNames.size(); ++index) {
                String mappedClassName = mappedClassNames.get(index);
                String[] key = new String[]{mappedClassName};
                rowData.put(key, this.buildDetailsFor(mappedClassName, rowData.getTabularType().getRowType()));
            }
            return rowData;
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "jmx_enabled_platform_mbean_runtime_exception", PLATFORM_NAME, (Object)exception);
            return null;
        }
    }

    private TabularData buildClassSummaryDetails() {
        try {
            List<String> mappedClassNames = this.getMappedClassNames();
            TabularDataSupport rowData = new TabularDataSupport(this.buildTabularTypeForClassSummaryDetails());
            if (mappedClassNames.isEmpty()) {
                return null;
            }
            for (int index = 0; index < mappedClassNames.size(); ++index) {
                String mappedClassName = mappedClassNames.get(index);
                String[] key = new String[]{mappedClassName};
                rowData.put(key, this.buildDetailsFor(mappedClassName, rowData.getTabularType().getRowType()));
            }
            return rowData;
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "jmx_enabled_platform_mbean_runtime_exception", PLATFORM_NAME, (Object)exception);
            return null;
        }
    }
}

