/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.provider;

import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.util.ObjectAnalyzer;
import jakarta.inject.Inject;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.monitoring.DTraceContract;
import org.glassfish.api.monitoring.ProbeProviderInfo;
import org.glassfish.external.probe.provider.annotations.Probe;
import org.glassfish.external.probe.provider.annotations.ProbeProvider;
import org.glassfish.flashlight.FlashlightLoggerInfo;
import org.glassfish.flashlight.FlashlightUtils;
import org.glassfish.flashlight.impl.client.FlashlightProbeClientMediator;
import org.glassfish.flashlight.impl.core.FlashlightProbeProvider;
import org.glassfish.flashlight.impl.core.ProbeFactory;
import org.glassfish.flashlight.impl.core.ProbeProviderRegistry;
import org.glassfish.flashlight.impl.core.ProviderImplGenerator;
import org.glassfish.flashlight.impl.core.ProviderSubClassImplGenerator;
import org.glassfish.flashlight.impl.provider.DTraceMethodFinder;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeProviderEventListener;
import org.glassfish.flashlight.provider.ProbeProviderEventManager;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.glassfish.flashlight.xml.ProbeProviderStaxParser;
import org.glassfish.flashlight.xml.Provider;
import org.glassfish.flashlight.xml.XmlProbe;
import org.glassfish.flashlight.xml.XmlProbeParam;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
public class FlashlightProbeProviderFactory
implements ProbeProviderFactory,
PostConstruct {
    @Inject
    MonitoringService monitoringServiceConfig;
    @Inject
    ProbeProviderEventManager ppem;
    @Inject
    ServiceLocator habitat;
    private List<ProbeProviderEventListener> listeners = new ArrayList<ProbeProviderEventListener>();
    private static final Logger logger = FlashlightLoggerInfo.getLogger();
    private static final ResourceBundle rb = logger.getResourceBundle();
    private static final HashMap<String, Class> primTypes = new HashMap<String, Class>(){
        {
            this.put("int", Integer.TYPE);
            this.put("byte", Byte.TYPE);
            this.put("char", Character.TYPE);
            this.put("short", Short.TYPE);
            this.put("long", Long.TYPE);
            this.put("float", Float.TYPE);
            this.put("double", Double.TYPE);
            this.put("boolean", Boolean.TYPE);
            this.put("void", Void.TYPE);
        }
    };

    public void postConstruct() {
        FlashlightUtils.initialize(this.habitat, this.monitoringServiceConfig);
    }

    @Override
    public void dtraceEnabledChanged(boolean newValue) {
        FlashlightUtils.setDTraceEnabled(newValue);
        if (!newValue) {
            return;
        }
        if (!FlashlightUtils.isDtraceAvailable()) {
            return;
        }
        Collection<FlashlightProbeProvider> pps = ProbeProviderRegistry.getInstance().getAllProbeProviders();
        for (FlashlightProbeProvider pp : pps) {
            if (pp.isDTraceInstrumented()) continue;
            this.handleDTrace(pp);
        }
    }

    @Override
    public void monitoringEnabledChanged(boolean newValue) {
        FlashlightUtils.setMonitoringEnabled(newValue);
        if (newValue && FlashlightUtils.isDtraceEnabled()) {
            this.dtraceEnabledChanged(true);
        }
    }

    @Override
    public <T> T getProbeProvider(Class<T> providerClazz) throws InstantiationException, IllegalAccessException {
        return this.getProbeProvider(providerClazz, null);
    }

    @Override
    public <T> T getProbeProvider(Class<T> providerClazz, String invokerId) throws InstantiationException, IllegalAccessException {
        if (providerClazz == null) {
            throw new NullPointerException("providerClazz cannot be null");
        }
        ProbeProvider provAnn = providerClazz.getAnnotation(ProbeProvider.class);
        String moduleProviderName = null;
        String moduleName = null;
        String probeProviderName = null;
        if (provAnn != null) {
            moduleProviderName = provAnn.moduleProviderName();
            moduleName = provAnn.moduleName();
            probeProviderName = provAnn.probeProviderName();
        }
        if (moduleProviderName == null) {
            moduleProviderName = providerClazz.getName();
        }
        if (moduleName == null) {
            moduleName = providerClazz.getName();
        }
        if (probeProviderName == null) {
            probeProviderName = providerClazz.getSimpleName();
        }
        if (this.isValidString(moduleProviderName) && this.isValidString(moduleName) && this.isValidString(probeProviderName)) {
            return this.getProbeProvider(moduleProviderName, moduleName, probeProviderName, invokerId, providerClazz);
        }
        logger.log(Level.WARNING, "NCLS-MON-00305", new Object[]{providerClazz.getName()});
        return null;
    }

    @Override
    public <T> T getProbeProvider(String moduleName, String providerName, String appName, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        return this.getProbeProvider(moduleName, providerName, appName, null, clazz);
    }

    public <T> T getProbeProvider(String moduleProviderName, String moduleName, String probeProviderName, String invokerId, Class<T> providerClazz) throws InstantiationException, IllegalAccessException {
        FlashlightProbeProvider alreadyExists;
        String origProbeProviderName = probeProviderName;
        Class<T> oldProviderClazz = providerClazz;
        ProbeProviderRegistry ppRegistry = ProbeProviderRegistry.getInstance();
        FlashlightProbeProvider genericProvider = null;
        if (invokerId != null) {
            this.getProbeProvider(moduleProviderName, moduleName, (String)probeProviderName, null, providerClazz);
            genericProvider = new FlashlightProbeProvider(moduleProviderName, moduleName, (String)probeProviderName, providerClazz);
            genericProvider = ppRegistry.getProbeProvider(genericProvider);
            invokerId = FlashlightUtils.getUniqueInvokerId(invokerId);
            probeProviderName = (String)probeProviderName + invokerId;
            try {
                providerClazz = this.getGeneratedProbeProviderClass(oldProviderClazz, invokerId);
            }
            catch (Exception ex) {
                providerClazz = oldProviderClazz;
            }
        }
        FlashlightProbeProvider provider = new FlashlightProbeProvider(moduleProviderName, moduleName, (String)probeProviderName, providerClazz);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ModuleProviderName= " + moduleProviderName + " \tModule= " + moduleName + "\tProbeProviderName= " + (String)probeProviderName + "\tProviderClazz= " + providerClazz.toString());
        }
        if ((alreadyExists = ppRegistry.getProbeProvider(provider)) != null) {
            Object inst = alreadyExists.getProviderClass().newInstance();
            this.notifyListenersOnAdd(moduleProviderName, moduleName, (String)probeProviderName, invokerId, providerClazz, inst);
            return inst;
        }
        List<Method> methods = FlashlightUtils.getProbeMethods(providerClazz);
        boolean isProbeAnnotationPresent = false;
        for (Method m : methods) {
            Probe pnameAnn = m.getAnnotation(Probe.class);
            boolean self = false;
            boolean hidden = false;
            String probeName = m.getName();
            if (pnameAnn == null) continue;
            isProbeAnnotationPresent = true;
            self = pnameAnn.self();
            hidden = pnameAnn.hidden();
            if (pnameAnn.name() != null && !pnameAnn.name().isEmpty()) {
                probeName = pnameAnn.name();
            }
            this.createProbe(origProbeProviderName, genericProvider, provider, probeName, self, hidden, m, moduleProviderName, moduleName, (String)probeProviderName, invokerId, providerClazz, pnameAnn.stateful(), pnameAnn.statefulReturn(), pnameAnn.statefulException(), pnameAnn.profileNames());
        }
        if (!isProbeAnnotationPresent) {
            for (Method m : providerClazz.getDeclaredMethods()) {
                String methodName = m.getName();
                this.createProbe(origProbeProviderName, genericProvider, provider, methodName, false, false, m, moduleProviderName, moduleName, (String)probeProviderName, invokerId, providerClazz, false, false, false, null);
            }
        }
        this.handleDTrace(provider);
        Class<Object> tClazz = providerClazz;
        int mod = providerClazz.getModifiers();
        if (Modifier.isAbstract(mod)) {
            Object generatedClassName = provider.getModuleProviderName() + "_Flashlight_" + provider.getModuleName() + "_Probe_" + (provider.getProbeProviderName() == null ? providerClazz.getName() : provider.getProbeProviderName());
            generatedClassName = providerClazz.getName() + "_" + (String)generatedClassName;
            try {
                tClazz = providerClazz.getClassLoader().loadClass((String)generatedClassName);
                Object inst = tClazz.newInstance();
                this.notifyListenersOnAdd(moduleProviderName, moduleName, (String)probeProviderName, invokerId, providerClazz, inst);
                return (T)inst;
            }
            catch (ClassNotFoundException inst) {
                ProviderImplGenerator gen = new ProviderImplGenerator();
                generatedClassName = gen.defineClass(provider, providerClazz);
                try {
                    tClazz = providerClazz.getClassLoader().loadClass((String)generatedClassName);
                }
                catch (ClassNotFoundException cnfEx) {
                    throw new RuntimeException(cnfEx);
                }
            }
        }
        ppRegistry.getInstance().registerProbeProvider(provider, tClazz);
        T inst = tClazz.newInstance();
        this.notifyListenersOnAdd(moduleProviderName, moduleName, (String)probeProviderName, invokerId, providerClazz, inst);
        return inst;
    }

    private void createProbe(String origProbeProviderName, FlashlightProbeProvider genericProvider, FlashlightProbeProvider provider, String probeName, boolean self, boolean hidden, Method m, String moduleProviderName, String moduleName, String probeProviderName, String invokerId, Class providerClazz, boolean stateful, boolean statefulReturn, boolean statefulException, String profileNames) {
        FlashlightProbe fp;
        String probeDescriptor;
        String[] probeParamNames = FlashlightUtils.getParamNames(m);
        FlashlightProbe probe = ProbeFactory.createProbe(providerClazz, moduleProviderName, moduleName, probeProviderName, probeName, probeParamNames, m.getParameterTypes(), self, hidden, stateful, statefulReturn, statefulException, this.splitProfileNames(profileNames));
        probe.setProviderJavaMethodName(m.getName());
        probe.setProbeMethod(m);
        provider.addProbe(probe);
        if (invokerId != null && genericProvider != null && (probeDescriptor = FlashlightProbe.getProbeDesc(moduleProviderName, moduleName, origProbeProviderName, probeName)) != null && (fp = genericProvider.getProbe(probeDescriptor)) != null) {
            probe.setParent(fp);
        }
    }

    @Override
    public void unregisterProbeProvider(Object probeProvider) {
        block3: {
            try {
                ProbeProviderRegistry ppRegistry = ProbeProviderRegistry.getInstance();
                FlashlightProbeProvider fProbeProvider = ppRegistry.getProbeProvider(probeProvider.getClass());
                ProbeRegistry probeRegistry = ProbeRegistry.getInstance();
                for (FlashlightProbe probe : fProbeProvider.getProbes()) {
                    probeRegistry.unregisterProbe(probe);
                }
                ppRegistry.unregisterProbeProvider(probeProvider);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, "NCLS-MON-00506", t);
            }
        }
    }

    private <T> Class<T> getGeneratedProbeProviderClass(Class<T> oldProviderClazz, String invokerId) {
        Class<T> genClazz = null;
        try {
            ProviderSubClassImplGenerator gen = new ProviderSubClassImplGenerator(oldProviderClazz, invokerId);
            genClazz = gen.generateAndDefineClass(oldProviderClazz, invokerId);
            return genClazz;
        }
        catch (Throwable cnfEx) {
            throw new RuntimeException(cnfEx);
        }
    }

    @Override
    public void processXMLProbeProviders(ClassLoader cl, String xml, boolean inBundle) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("processProbeProviderXML for " + xml);
        }
        try {
            InputStream is = inBundle ? cl.getResourceAsStream(xml) : new FileInputStream(xml);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("InputStream = " + is);
            }
            ProbeProviderStaxParser providerXMLParser = new ProbeProviderStaxParser(is);
            List<Provider> providers = providerXMLParser.getProviders();
            for (Provider provider : providers) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(provider.toString());
                }
                this.registerProvider(cl, provider);
            }
        }
        catch (Exception e) {
            Object[] params = new Object[]{xml, e};
            logger.log(Level.SEVERE, "NCLS-MON-00301", params);
        }
    }

    private <T> void notifyListenersOnAdd(String moduleProviderName, String moduleName, String probeProviderName, String invokerId, Class<T> providerClazz, T provider) {
        for (ProbeProviderEventListener listener : this.listeners) {
            listener.probeProviderAdded(moduleProviderName, moduleName, probeProviderName, invokerId, providerClazz, provider);
        }
    }

    @Override
    public void addProbeProviderEventListener(ProbeProviderEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeProbeProviderEventListener(ProbeProviderEventListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return ObjectAnalyzer.toString((Object)this);
    }

    private void handleDTrace(FlashlightProbeProvider provider) {
        if (this.allHidden(provider)) {
            return;
        }
        DTraceContract dt = FlashlightUtils.getDtraceEngine();
        if (dt == null) {
            return;
        }
        Object dtraceProviderImpl = dt.getProvider((ProbeProviderInfo)provider);
        if (dtraceProviderImpl == null) {
            provider.setDTraceInstrumented(false);
            return;
        }
        provider.setDTraceInstrumented(true);
        Collection<FlashlightProbe> probes = provider.getProbes();
        boolean onlyHidden = true;
        for (FlashlightProbe probe : probes) {
            if (probe.isHidden()) continue;
            DTraceMethodFinder mf = new DTraceMethodFinder(probe, dtraceProviderImpl);
            probe.setDTraceMethod(mf.matchMethod());
            probe.setDTraceProviderImpl(dtraceProviderImpl);
            onlyHidden = false;
        }
        if (!onlyHidden) {
            FlashlightProbeClientMediator.getInstance().registerDTraceListener(provider);
        }
    }

    private boolean allHidden(FlashlightProbeProvider provider) {
        for (FlashlightProbe probe : provider.getProbes()) {
            if (probe.isHidden()) continue;
            return false;
        }
        return true;
    }

    private void registerProvider(ClassLoader cl, Provider provider) {
        String moduleProviderName = provider.getModuleProviderName();
        String moduleName = provider.getModuleName();
        String probeProviderName = provider.getProbeProviderName();
        String providerClass = provider.getProbeProviderClass();
        List<XmlProbe> probes = provider.getProbes();
        Class<?> providerClazz = null;
        try {
            providerClazz = cl.loadClass(providerClass);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("providerClazz = " + providerClazz);
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" Could not load the class ( " + providerClazz + " ) for the provider " + providerClass);
            }
            e.printStackTrace();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("moduleProviderName = " + moduleProviderName);
            logger.fine("moduleName = " + moduleName);
            logger.fine("probeProviderName = " + probeProviderName);
            logger.fine("probeProviderClass = " + providerClass);
        }
        FlashlightProbeProvider flProvider = new FlashlightProbeProvider(moduleProviderName, moduleName, probeProviderName, providerClazz);
        for (XmlProbe probe : probes) {
            String probeName = probe.getProbeName();
            String probeMethod = probe.getProbeMethod();
            boolean hasSelf = probe.hasSelf();
            boolean isHidden = probe.isHidden();
            boolean errorParsingProbe = false;
            String[] probeParams = new String[probe.getProbeParams().size()];
            Class[] paramTypes = new Class[probe.getProbeParams().size()];
            int i = 0;
            for (XmlProbeParam param : probe.getProbeParams()) {
                probeParams[i] = param.getName();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("          probeParam[" + i + "] = " + probeParams[i]);
                }
                paramTypes[i] = this.getParamType(cl, param.getType());
                if (paramTypes[i] == null) {
                    errorParsingProbe = true;
                    logger.log(Level.SEVERE, "NCLS-MON-00302", new Object[]{probeName});
                    break;
                }
                ++i;
            }
            if (errorParsingProbe) {
                errorParsingProbe = false;
                continue;
            }
            FlashlightProbe flProbe = ProbeFactory.createProbe(providerClazz, moduleProviderName, moduleName, probeProviderName, probeName, probeParams, paramTypes, hasSelf, isHidden, probe.getStateful(), probe.getStatefulReturn(), probe.getStatefulException(), this.splitProfileNames(probe.getProfileNames()));
            flProbe.setProviderJavaMethodName(probeMethod);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" Constructed probe = " + flProbe.toString());
            }
            flProvider.addProbe(flProbe);
        }
        if (flProvider.getProbes().size() == 0) {
            return;
        }
        this.handleDTrace(flProvider);
        ProbeProviderRegistry.getInstance().registerProbeProvider(flProvider, providerClazz);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" Provider registered successfully - " + probeProviderName);
        }
    }

    private Class<?> getParamType(ClassLoader cl, String paramTypeStr) {
        Class<?> paramType = null;
        try {
            Class primType = primTypes.get(paramTypeStr);
            if (primType != null) {
                return primType;
            }
            paramType = cl.loadClass(paramTypeStr);
        }
        catch (ClassNotFoundException ex) {
            try {
                paramType = cl.loadClass("java.lang." + paramTypeStr);
            }
            catch (Exception e) {
                Object[] params = new Object[]{paramTypeStr, e};
                logger.log(Level.SEVERE, "NCLS-MON-00303", params);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("          paramType = " + paramType);
        }
        return paramType;
    }

    private boolean isValidString(String str) {
        return str != null && str.length() > 0;
    }

    private String[] splitProfileNames(String profileNamesAll) {
        if (profileNamesAll == null) {
            return null;
        }
        String[] profileNames = profileNamesAll.split(",");
        for (int i = 0; i < profileNames.length; ++i) {
            profileNames[i] = profileNames[i] == null ? null : profileNames[i].trim();
        }
        return profileNames;
    }
}

