/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.glassfish.logging.annotation.LogMessageInfo;

public class DeploymentUtils {
    public static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    @LogMessageInfo(message="Exception caught {0}", level="WARNING")
    private static final String EXCEPTION_CAUGHT = "NCLS-DEPLOYMENT-00010";
    public static final String DEPLOYMENT_PROPERTY_JAVA_WEB_START_ENABLED = "java-web-start-enabled";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeploymentUtils.class);
    private static final String V2_COMPATIBILITY = "v2";
    private static final String INSTANCE_ROOT_URI_PROPERTY_NAME = "com.sun.aas.instanceRootURI";
    public static final String DAS_TARGET_NAME = "server";
    public static final String DOMAIN_TARGET_NAME = "domain";
    private static final String DOWNLOADABLE_ARTIFACTS_KEY_PREFIX = "downloadable";
    private static final String GENERATED_ARTIFACTS_KEY_PREFIX = "generated";

    public static boolean isDASTarget(String targetName) {
        return DAS_TARGET_NAME.equals(targetName);
    }

    public static boolean isDomainTarget(String targetName) {
        return DOMAIN_TARGET_NAME.equals(targetName);
    }

    public static long checksum(File directory) {
        if (!directory.isDirectory()) {
            String msg = localStrings.getLocalString("enterprise.deployment.remoteDirPathUnusable", "The directory deployment path {0} is not a directory or is inaccessible", new Object[]{directory.getAbsolutePath()});
            throw new IllegalArgumentException(msg);
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        DeploymentUtils.scanDirectory(directory.toURI(), directory, uris);
        Collections.sort(uris);
        Adler32 checksum = new Adler32();
        for (URI uri : uris) {
            checksum.update(uri.toASCIIString().getBytes());
        }
        return checksum.getValue();
    }

    public static Artifacts downloadableArtifacts(DeploymentContext dc) {
        return Artifacts.get(dc, DOWNLOADABLE_ARTIFACTS_KEY_PREFIX);
    }

    public static Artifacts downloadableArtifacts(Application app) {
        return Artifacts.get(app.getDeployProperties(), DOWNLOADABLE_ARTIFACTS_KEY_PREFIX);
    }

    public static Artifacts generatedArtifacts(DeploymentContext dc) {
        return Artifacts.get(dc, GENERATED_ARTIFACTS_KEY_PREFIX);
    }

    public static Artifacts generatedArtifacts(Application app) {
        return Artifacts.get(app.getDeployProperties(), GENERATED_ARTIFACTS_KEY_PREFIX);
    }

    private static void scanDirectory(URI anchorDirURI, File directory, List<URI> uris) {
        for (File f : directory.listFiles()) {
            uris.add(anchorDirURI.relativize(f.toURI()));
            if (!f.isDirectory()) continue;
            DeploymentUtils.scanDirectory(anchorDirURI, f, uris);
        }
    }

    public static boolean isArchiveOfType(ReadableArchive archive, ArchiveType archiveType, DeploymentContext context, ServiceLocator locator) {
        if (archive == null || archiveType == null) {
            return false;
        }
        String type = archiveType.toString();
        if (context != null && context.getArchiveHandler() != null) {
            return type.equals(context.getArchiveHandler().getArchiveType());
        }
        try {
            ArchiveDetector detector = (ArchiveDetector)locator.getService(ArchiveDetector.class, type, new Annotation[0]);
            if (detector == null) {
                return false;
            }
            return detector.handles(archive);
        }
        catch (IOException ioe) {
            LogRecord lr = new LogRecord(Level.WARNING, EXCEPTION_CAUGHT);
            Object[] args = new Object[]{ioe.getMessage()};
            lr.setParameters(args);
            lr.setThrown(ioe);
            deplLogger.log(lr);
            return false;
        }
    }

    public static boolean isArchiveOfType(ReadableArchive archive, ArchiveType archiveType, ServiceLocator locator) {
        return DeploymentUtils.isArchiveOfType(archive, archiveType, null, locator);
    }

    public static String getDefaultEEName(String pathName) {
        if (pathName == null) {
            return null;
        }
        if ((pathName = pathName.replace('\\', '/')).endsWith("/")) {
            pathName = pathName.substring(0, pathName.length() - 1);
        }
        if (pathName.lastIndexOf("/") != -1) {
            pathName = pathName.substring(pathName.lastIndexOf("/") + 1);
        }
        if (pathName.endsWith(".jar") || pathName.endsWith(".war") || pathName.endsWith(".rar") || pathName.endsWith(".ear")) {
            return pathName.substring(0, pathName.length() - 4);
        }
        return pathName;
    }

    public static String getRelativeEmbeddedModulePath(String appRootPath, String moduleUri) {
        if (FileUtils.safeIsDirectory((File)new File(appRootPath, moduleUri = FileUtils.makeLegalNoBlankFileName((String)moduleUri)))) {
            return moduleUri;
        }
        return FileUtils.makeFriendlyFilenameExtension((String)moduleUri);
    }

    public static String getEmbeddedModulePath(String appRootPath, String moduleUri) {
        return appRootPath + File.separator + DeploymentUtils.getRelativeEmbeddedModulePath(appRootPath, moduleUri);
    }

    public static boolean useV2Compatibility(DeploymentContext context) {
        return V2_COMPATIBILITY.equals(context.getAppProps().getProperty("compatibility"));
    }

    public static String relativizeWithinDomainIfPossible(URI absURI) throws URISyntaxException {
        URI instanceRootURI = new URI(System.getProperty(INSTANCE_ROOT_URI_PROPERTY_NAME));
        URI appURI = instanceRootURI.relativize(absURI);
        Object appLocation = appURI.isAbsolute() ? appURI.toString() : "${com.sun.aas.instanceRootURI}/" + appURI.toString();
        return appLocation;
    }

    public static void validateApplicationName(String name) {
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException(localStrings.getLocalString("illegal_char_in_name", "Illegal character [{0}] in the name [{1}].", new Object[]{"/", name}));
        }
        if (name.indexOf(35) != -1) {
            throw new IllegalArgumentException(localStrings.getLocalString("illegal_char_in_name", "Illegal character [{0}] in the name [{1}].", new Object[]{"#", name}));
        }
        if (name.indexOf(59) != -1) {
            throw new IllegalArgumentException(localStrings.getLocalString("illegal_char_in_name", "Illegal character [{0}] in the name [{1}].", new Object[]{";", name}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expand(ReadableArchive source, WritableArchive target) throws IOException {
        Enumeration e = source.entries();
        while (e.hasMoreElements()) {
            String entryName = (String)e.nextElement();
            BufferedInputStream is = new BufferedInputStream(source.getEntry(entryName));
            OutputStream os = null;
            try {
                os = target.putNextEntry(entryName);
                FileUtils.copy((InputStream)is, (OutputStream)os, (long)source.getEntrySize(entryName));
            }
            finally {
                if (os != null) {
                    target.closeEntry();
                }
                ((InputStream)is).close();
            }
        }
        Manifest m = source.getManifest();
        if (m != null) {
            OutputStream os = target.putNextEntry("META-INF/MANIFEST.MF");
            m.write(os);
            target.closeEntry();
        }
    }

    public static String getInternalNameForTenant(String appname, String tenantname) {
        return appname + "___" + tenantname;
    }

    public static String propertiesValue(Properties props, char sep) {
        StringBuilder sb = new StringBuilder();
        String currentSep = "";
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            Object v = props.get(key);
            sb.append(currentSep).append(key.toString()).append("=").append(v.toString());
            currentSep = String.valueOf(sep);
        }
        return sb.toString();
    }

    public static List<URL> getManifestLibraries(DeploymentContext context) throws IOException {
        return DeploymentUtils.getManifestLibraries(context.getSource());
    }

    public static List<URL> getManifestLibraries(DeploymentContext context, Manifest manifest) throws IOException {
        return DeploymentUtils.getManifestLibraries(context.getSource(), manifest);
    }

    public static List<URL> getManifestLibraries(ReadableArchive archive) throws IOException {
        return DeploymentUtils.getManifestLibraries(archive, archive.getManifest());
    }

    private static List<URL> getManifestLibraries(ReadableArchive archive, Manifest manifest) {
        String appRootPath = null;
        ReadableArchive parentArchive = archive.getParentArchive();
        if (parentArchive != null) {
            appRootPath = new File(parentArchive.getURI()).getPath();
        } else {
            try {
                appRootPath = new File(archive.getURI().getPath()).getParent();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ASClassLoaderUtil.getManifestClassPathAsURLs(manifest, appRootPath);
    }

    public static List<URI> getExternalLibraries(ReadableArchive archive) {
        ArrayList<URI> externalLibURIs = new ArrayList<URI>();
        try {
            List<URL> manifestURLs = DeploymentUtils.getManifestLibraries(archive);
            URI archiveURI = archive.getURI();
            if (archive.getParentArchive() != null) {
                archiveURI = archive.getParentArchive().getURI();
            }
            for (URL manifestURL : manifestURLs) {
                File externalLib;
                URI manifestLibURI = archiveURI.relativize(manifestURL.toURI());
                if (!manifestLibURI.isAbsolute() || !(externalLib = new File(manifestLibURI)).exists()) continue;
                externalLibURIs.add(manifestLibURI);
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.WARNING, e.getMessage(), e);
        }
        return externalLibURIs;
    }

    public static FileArchive openAsFileArchive(File dir, ArchiveFactory archiveFactory) throws IOException {
        return (FileArchive)archiveFactory.openArchive(dir);
    }

    public static String getVirtualServers(String target, ServerEnvironment env, Domain domain) {
        List hosts;
        HttpService httpService;
        if (target == null) {
            target = DAS_TARGET_NAME;
        }
        if (env.isDas() && DeploymentUtils.isDomainTarget(target)) {
            target = DAS_TARGET_NAME;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Server server = domain.getServerNamed(target);
        Config config = null;
        if (server != null) {
            config = domain.getConfigs().getConfigByName(server.getConfigRef());
        } else {
            Cluster cluster = domain.getClusterNamed(target);
            if (cluster != null) {
                config = domain.getConfigs().getConfigByName(cluster.getConfigRef());
            }
        }
        if (config != null && (httpService = config.getHttpService()) != null && (hosts = httpService.getVirtualServer()) != null) {
            for (VirtualServer host : hosts) {
                if ("__asadmin".equals(host.getId())) continue;
                if (first) {
                    sb.append(host.getId());
                    first = false;
                    continue;
                }
                sb.append(",");
                sb.append(host.getId());
            }
        }
        return sb.toString();
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }
}

