/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.glassfish.ejb.deployment.descriptor.ContainerTransaction;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.w3c.dom.Node;

public class ContainerTransactionNode
extends DeploymentDescriptorNode {
    private String trans_attribute;
    private String description;
    private Vector methods = new Vector();

    public ContainerTransactionNode() {
        this.registerElementHandler(new XMLElement("method"), MethodNode.class);
    }

    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof MethodDescriptor) {
            this.methods.add(newDescriptor);
        }
    }

    public Object getDescriptor() {
        return null;
    }

    public boolean endElement(XMLElement element) {
        boolean doneWithNode = super.endElement(element);
        if (doneWithNode) {
            ContainerTransaction ct = new ContainerTransaction(this.trans_attribute, this.description);
            for (MethodDescriptor md : this.methods) {
                EjbBundleDescriptorImpl bundle = (EjbBundleDescriptorImpl)((Object)this.getParentNode().getDescriptor());
                EjbDescriptor ejb = bundle.getEjbByName(md.getEjbName(), true);
                ejb.getMethodContainerTransactions().put(md, ct);
            }
        }
        return doneWithNode;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("description".equals(element.getQName())) {
            this.description = value;
        }
        if ("trans-attribute".equals(element.getQName())) {
            this.trans_attribute = value;
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, EjbDescriptor ejb) {
        Hashtable methodToTransactions = ejb.getMethodContainerTransactions();
        MethodNode mn = new MethodNode();
        Iterator iterator = methodToTransactions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            MethodDescriptor md = (MethodDescriptor)entry.getKey();
            Node ctNode = super.writeDescriptor(parent, nodeName, (Object)ejb);
            ContainerTransaction ct = (ContainerTransaction)((Object)entry.getValue());
            ContainerTransactionNode.appendTextChild((Node)ctNode, (String)"description", (String)ct.getDescription());
            mn.writeDescriptor(ctNode, "method", md, ejb.getName());
            ContainerTransactionNode.appendTextChild((Node)ctNode, (String)"trans-attribute", (String)ct.getTransactionAttribute());
        }
        return null;
    }
}

