/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.common.util.logging.LoggingOutputStream;
import com.sun.common.util.logging.LoggingXMLNames;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.bootstrap.EarlyLogHandler;
import com.sun.enterprise.server.logging.GFFileHandler;
import com.sun.enterprise.server.logging.LogFacade;
import com.sun.enterprise.server.logging.ODLLogFormatter;
import com.sun.enterprise.server.logging.UniformLogFormatter;
import com.sun.enterprise.util.EarlyLogger;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.logging.AgentFormatterDelegate;
import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.api.admin.FileMonitoring;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.Rank;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.internal.config.UnprocessedConfigListener;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@RunLevel(value=1)
@Rank(value=50)
public class LogManagerService
implements PostConstruct,
PreDestroy,
org.glassfish.internal.api.LogManager {
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    ServiceLocator habitat;
    @Inject
    @Optional
    Agent agent = null;
    @Inject
    FileMonitoring fileMonitoring;
    @Inject
    LoggingConfigImpl loggingConfig;
    @Inject
    UnprocessedConfigListener ucl;
    @Inject
    Domain domain;
    final Map<String, Handler> gfHandlers = new HashMap<String, Handler>();
    private static final Logger LOGGER = LogFacade.LOGGING_LOGGER;
    PrintStream oStdOutBackup = System.out;
    PrintStream oStdErrBackup = System.err;
    String serverLogFileDetail = "";
    String handlerDetail = "";
    String handlerServices = "";
    String consoleHandlerFormatterDetail = "";
    String gffileHandlerFormatterDetail = "";
    String rotationOnTimeLimitInMinutesDetail = "";
    String flushFrequencyDetail = "";
    String filterHandlerDetails = "";
    String logToConsoleDetail = "";
    String rotationInTimeLimitInBytesDetail = "";
    String useSystemLoggingDetail = "";
    String fileHandlerCountDetail = "";
    String retainErrorsStaticticsDetail = "";
    String log4jVersionDetail = "";
    String maxHistoryFilesDetail = "";
    String rotationOnDateChangeDetail = "";
    String fileHandlerPatternDetail = "";
    String fileHandlerFormatterDetail = "";
    String logFormatDateFormatDetail = "";
    private static final String SERVER_LOG_FILE_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.file";
    private static final String HANDLER_PROPERTY = "handlers";
    private static final String HANDLER_SERVICES_PROPERTY = "handlerServices";
    private static final String CONSOLEHANDLER_FORMATTER_PROPERTY = "java.util.logging.ConsoleHandler.formatter";
    private static final String GFFILEHANDLER_FORMATTER_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.formatter";
    private static final String ROTATIONTIMELIMITINMINUTES_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.rotationTimelimitInMinutes";
    private static final String FLUSHFREQUENCY_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.flushFrequency";
    private static final String FILEHANDLER_LIMIT_PROPERTY = "java.util.logging.FileHandler.limit";
    private static final String LOGTOCONSOLE_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.logtoConsole";
    private static final String ROTATIONLIMITINBYTES_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.rotationLimitInBytes";
    private static final String USESYSTEMLOGGING_PROPERTY = "com.sun.enterprise.server.logging.SyslogHandler.useSystemLogging";
    private static final String FILEHANDLER_COUNT_PROPERTY = "java.util.logging.FileHandler.count";
    private static final String RETAINERRORSSTATICTICS_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.retainErrorsStasticsForHours";
    private static final String LOG4J_VERSION_PROPERTY = "log4j.logger.org.hibernate.validator.util.Version";
    private static final String MAXHISTORY_FILES_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.maxHistoryFiles";
    private static final String ROTATIONONDATECHANGE_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.rotationOnDateChange";
    private static final String FILEHANDLER_PATTERN_PROPERTY = "java.util.logging.FileHandler.pattern";
    private static final String FILEHANDLER_FORMATTER_PROPERTY = "java.util.logging.FileHandler.formatter";
    private static final String LOGFORMAT_DATEFORMAT_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.logFormatDateFormat";
    static final String EXCLUDE_FIELDS_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.excludeFields";
    static final String MULTI_LINE_MODE_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.multiLineMode";
    private String RECORD_BEGIN_MARKER = "[#|";
    private String RECORD_END_MARKER = "|#]";
    private String RECORD_FIELD_SEPARATOR = "|";
    private String RECORD_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    String recordBeginMarker;
    String recordEndMarker;
    String recordFieldSeparator;
    String recordDateFormat;
    Vector<Logger> loggerReference = new Vector();
    private String excludeFields;
    private boolean multiLineMode = false;
    private LoggingOutputStream stdoutOutputStream = null;
    private LoggingOutputStream stderrOutputStream = null;

    public Map<String, String> getLoggingProperties() throws IOException {
        Server targetServer = this.domain.getServerNamed(this.env.getInstanceName());
        Map props = null;
        props = targetServer != null ? (targetServer.isDas() ? this.loggingConfig.getLoggingProperties() : (targetServer.getCluster() != null ? this.loggingConfig.getLoggingProperties(targetServer.getCluster().getConfigRef()) : (targetServer.isInstance() ? this.loggingConfig.getLoggingProperties(targetServer.getConfigRef()) : this.loggingConfig.getLoggingProperties()))) : this.loggingConfig.getLoggingProperties();
        return props;
    }

    public File getLoggingFile() throws IOException {
        File file = null;
        Server targetServer = this.domain.getServerNamed(this.env.getInstanceName());
        if (targetServer != null) {
            if (targetServer.isDas()) {
                file = new File(this.env.getConfigDirPath(), "logging.properties");
            } else if (targetServer.getCluster() != null) {
                String pathForLogging = this.env.getConfigDirPath() + File.separator + targetServer.getCluster().getConfigRef();
                File dirForLogging = new File(pathForLogging);
                file = new File(dirForLogging, "logging.properties");
            } else if (targetServer.isInstance()) {
                String pathForLogging = this.env.getConfigDirPath() + File.separator + targetServer.getConfigRef();
                File dirForLogging = new File(pathForLogging);
                file = new File(dirForLogging, "logging.properties");
            } else {
                file = new File(this.env.getConfigDirPath(), "logging.properties");
            }
        } else {
            file = new File(this.env.getConfigDirPath(), "logging.properties");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConstruct() {
        Object formatter;
        if (System.getProperty("java.util.logging.config.file") != null) {
            System.out.println("\n\n\n#!## LogManagerService.postConstruct : java.util.logging.config.file=" + System.getProperty("java.util.logging.config.file"));
            return;
        }
        LogManager logMgr = LogManager.getLogManager();
        File logging = null;
        try {
            logging = this.getLoggingFile();
            System.setProperty("java.util.logging.config.file", logging.getAbsolutePath());
            String rootFolder = (String)this.env.getProps().get("com.sun.aas.installRoot");
            String templateDir = rootFolder + File.separator + "lib" + File.separator + "templates";
            File src = new File(templateDir, "logging.properties");
            File dest = new File(this.env.getConfigDirPath(), "logging.properties");
            System.out.println("\n\n\n#!## LogManagerService.postConstruct : rootFolder=" + rootFolder);
            System.out.println("#!## LogManagerService.postConstruct : templateDir=" + templateDir);
            System.out.println("#!## LogManagerService.postConstruct : src=" + src);
            System.out.println("#!## LogManagerService.postConstruct : dest=" + dest);
            if (!logging.exists()) {
                LOGGER.log(Level.FINE, logging.getAbsolutePath() + " not found, creating new file from template.");
                FileUtils.copy((File)src, (File)dest);
                logging = new File(this.env.getConfigDirPath(), "logging.properties");
            }
            logMgr.readConfiguration();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00001", e);
        }
        AgentFormatterDelegate agentDelegate = null;
        if (this.agent != null) {
            agentDelegate = new AgentFormatterDelegate(this.agent);
        }
        String formatterClassName = null;
        try {
            Map<String, String> props = this.getLoggingProperties();
            formatterClassName = props.get(CONSOLEHANDLER_FORMATTER_PROPERTY);
            if (formatterClassName == null || formatterClassName.isEmpty()) {
                formatterClassName = UniformLogFormatter.class.getName();
            }
            this.consoleHandlerFormatterDetail = formatterClassName;
            this.excludeFields = props.get(EXCLUDE_FIELDS_PROPERTY);
            this.multiLineMode = Boolean.parseBoolean(props.get(MULTI_LINE_MODE_PROPERTY));
            if (formatterClassName.equals(UniformLogFormatter.class.getName())) {
                formatter = new UniformLogFormatter();
                String string = "com.sun.enterprise.server.logging.GFFileHandler";
                this.recordBeginMarker = props.get(string + ".logFormatBeginMarker");
                if (this.recordBeginMarker == null || "".equals(this.recordBeginMarker)) {
                    LOGGER.log(Level.FINE, "Record begin marker is not a proper value so using default.");
                    this.recordBeginMarker = this.RECORD_BEGIN_MARKER;
                }
                this.recordEndMarker = props.get(string + ".logFormatEndMarker");
                if (this.recordEndMarker == null || "".equals(this.recordEndMarker)) {
                    LOGGER.log(Level.FINE, "Record end marker is not a proper value so using default.");
                    this.recordEndMarker = this.RECORD_END_MARKER;
                }
                this.recordFieldSeparator = props.get(string + ".logFormatFieldSeparator");
                if (this.recordFieldSeparator == null || "".equals(this.recordFieldSeparator) || this.recordFieldSeparator.length() > 1) {
                    LOGGER.log(Level.FINE, "Log Format field separator is not a proper value so using default.");
                    this.recordFieldSeparator = this.RECORD_FIELD_SEPARATOR;
                }
                this.recordDateFormat = props.get(string + ".logFormatDateFormat");
                if (this.recordDateFormat != null && !"".equals(this.recordDateFormat)) {
                    Handler[] sdf = new SimpleDateFormat(this.recordDateFormat);
                    try {
                        sdf.format(new Date());
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Date Format specified is wrong so using default.");
                        this.recordDateFormat = this.RECORD_DATE_FORMAT;
                    }
                } else {
                    LOGGER.log(Level.FINE, "Date Format specified is wrong so using default.");
                    this.recordDateFormat = this.RECORD_DATE_FORMAT;
                }
                ((UniformLogFormatter)formatter).setRecordBeginMarker(this.recordBeginMarker);
                ((UniformLogFormatter)formatter).setRecordEndMarker(this.recordEndMarker);
                ((UniformLogFormatter)formatter).setRecordDateFormat(this.recordDateFormat);
                ((UniformLogFormatter)formatter).setRecordFieldSeparator(this.recordFieldSeparator);
                ((UniformLogFormatter)formatter).setExcludeFields(this.excludeFields);
                ((UniformLogFormatter)formatter).setMultiLineMode(this.multiLineMode);
                for (Handler handler : logMgr.getLogger("").getHandlers()) {
                    if (!handler.getClass().equals(ConsoleHandler.class)) continue;
                    handler.setFormatter((Formatter)formatter);
                    break;
                }
            } else if (formatterClassName.equals(ODLLogFormatter.class.getName())) {
                formatter = new ODLLogFormatter();
                ((ODLLogFormatter)formatter).setExcludeFields(this.excludeFields);
                ((ODLLogFormatter)formatter).setMultiLineMode(this.multiLineMode);
                for (Handler handler : logMgr.getLogger("").getHandlers()) {
                    if (!handler.getClass().equals(ConsoleHandler.class)) continue;
                    handler.setFormatter((Formatter)formatter);
                    break;
                }
            }
            this.serverLogFileDetail = props.get(SERVER_LOG_FILE_PROPERTY);
            this.handlerDetail = props.get(HANDLER_PROPERTY);
            this.handlerServices = props.get(HANDLER_SERVICES_PROPERTY);
            if (this.handlerServices == null) {
                this.handlerServices = "";
            }
            this.consoleHandlerFormatterDetail = props.get(CONSOLEHANDLER_FORMATTER_PROPERTY);
            this.gffileHandlerFormatterDetail = props.get(GFFILEHANDLER_FORMATTER_PROPERTY);
            this.rotationOnTimeLimitInMinutesDetail = props.get(ROTATIONTIMELIMITINMINUTES_PROPERTY);
            this.flushFrequencyDetail = props.get(FLUSHFREQUENCY_PROPERTY);
            this.filterHandlerDetails = props.get(FILEHANDLER_LIMIT_PROPERTY);
            this.logToConsoleDetail = props.get(LOGTOCONSOLE_PROPERTY);
            this.rotationInTimeLimitInBytesDetail = props.get(ROTATIONLIMITINBYTES_PROPERTY);
            this.useSystemLoggingDetail = props.get(USESYSTEMLOGGING_PROPERTY);
            this.fileHandlerCountDetail = props.get(FILEHANDLER_COUNT_PROPERTY);
            this.retainErrorsStaticticsDetail = props.get(RETAINERRORSSTATICTICS_PROPERTY);
            this.log4jVersionDetail = props.get(LOG4J_VERSION_PROPERTY);
            this.maxHistoryFilesDetail = props.get(MAXHISTORY_FILES_PROPERTY);
            this.rotationOnDateChangeDetail = props.get(ROTATIONONDATECHANGE_PROPERTY);
            this.fileHandlerPatternDetail = props.get(FILEHANDLER_PATTERN_PROPERTY);
            this.fileHandlerFormatterDetail = props.get(FILEHANDLER_FORMATTER_PROPERTY);
            this.logFormatDateFormatDetail = props.get(LOGFORMAT_DATEFORMAT_PROPERTY);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00002", e);
        }
        Collection<Handler> handlers = this.getHandlerServices();
        if (handlers != null && handlers.size() > 0) {
            for (Handler handler : handlers) {
                this.addHandler(handler);
            }
        }
        formatter = Logger.class;
        synchronized (Logger.class) {
            List catchUp;
            LogManager logManager = logMgr;
            synchronized (logManager) {
                Enumeration<String> loggerNames = logMgr.getLoggerNames();
                while (loggerNames.hasMoreElements()) {
                    String loggerName = loggerNames.nextElement();
                    Logger logger = logMgr.getLogger(loggerName);
                    if (logger == null) continue;
                    for (Handler handler2 : logger.getHandlers()) {
                        Formatter formatter2 = handler2.getFormatter();
                        if (formatter2 == null || !(formatter2 instanceof UniformLogFormatter)) continue;
                        ((UniformLogFormatter)formatter2).setDelegate(agentDelegate);
                    }
                }
            }
            // ** MonitorExit[formatter] (shouldn't be in output)
            try {
                Map<String, String> map = this.getLoggingProperties();
                String string = map.get(LoggingXMLNames.xmltoPropsMap.get("log-filter"));
                if (string != null) {
                    java.util.logging.Filter filterClass = (java.util.logging.Filter)this.habitat.getService(java.util.logging.Filter.class, string, new Annotation[0]);
                    Logger rootLogger = Logger.getLogger("");
                    if (rootLogger != null) {
                        rootLogger.setFilter(filterClass);
                    }
                }
            }
            catch (IOException map) {
                // empty catch block
            }
            Logger _ologger = LogFacade.STDOUT_LOGGER;
            LoggingOutputStream loggingOutputStream = this.stdoutOutputStream = new LoggingOutputStream(_ologger, Level.INFO);
            Objects.requireNonNull(loggingOutputStream);
            LoggingOutputStream.LoggingPrintStream loggingPrintStream = new LoggingOutputStream.LoggingPrintStream(loggingOutputStream, (ByteArrayOutputStream)this.stdoutOutputStream);
            System.setOut((PrintStream)loggingPrintStream);
            Logger _elogger = LogFacade.STDERR_LOGGER;
            LoggingOutputStream loggingOutputStream2 = this.stderrOutputStream = new LoggingOutputStream(_elogger, Level.SEVERE);
            Objects.requireNonNull(loggingOutputStream2);
            LoggingOutputStream.LoggingPrintStream perr = new LoggingOutputStream.LoggingPrintStream(loggingOutputStream2, (ByteArrayOutputStream)this.stderrOutputStream);
            System.setErr((PrintStream)perr);
            if (logging != null) {
                this.fileMonitoring.monitors(logging, new FileMonitoring.FileChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void changed(File changedFile) {
                        Map<String, Handler> map = LogManagerService.this.gfHandlers;
                        synchronized (map) {
                            try {
                                Map<String, String> props = LogManagerService.this.getLoggingProperties();
                                LogManagerService.this.loggerReference = new Vector();
                                if (props == null) {
                                    return;
                                }
                                for (Map.Entry<String, String> entry : props.entrySet()) {
                                    String oldVal;
                                    String a = entry.getKey();
                                    String val = entry.getValue();
                                    if (a.endsWith(".level")) {
                                        String n = a.substring(0, a.lastIndexOf(".level"));
                                        Level l = Level.parse(val);
                                        if (LogManagerService.this.gfHandlers.containsKey(n)) {
                                            Handler h = LogManagerService.this.gfHandlers.get(n);
                                            h.setLevel(l);
                                            continue;
                                        }
                                        if (n.equals("java.util.logging.ConsoleHandler")) {
                                            Logger logger = Logger.getLogger("");
                                            Handler[] h = logger.getHandlers();
                                            for (int i = 0; i < h.length; ++i) {
                                                String name = h[i].toString();
                                                if (!name.contains("java.util.logging.ConsoleHandler")) continue;
                                                h[i].setLevel(l);
                                            }
                                            continue;
                                        }
                                        Logger appLogger = Logger.getLogger(n);
                                        appLogger.setLevel(l);
                                        LogManagerService.this.loggerReference.add(appLogger);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.SERVER_LOG_FILE_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.serverLogFileDetail)) continue;
                                        PropertyChangeEvent pce = new PropertyChangeEvent(this, a, LogManagerService.this.serverLogFileDetail, val);
                                        UnprocessedChangeEvents ucel = new UnprocessedChangeEvents(new UnprocessedChangeEvent(pce, "server log filename changed."));
                                        ArrayList<UnprocessedChangeEvents> b = new ArrayList<UnprocessedChangeEvents>();
                                        b.add(ucel);
                                        LogManagerService.this.ucl.unprocessedTransactedEvents(b);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.HANDLER_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.handlerDetail)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.HANDLER_PROPERTY, LogManagerService.this.handlerDetail, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.HANDLER_SERVICES_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.handlerServices)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.HANDLER_SERVICES_PROPERTY, LogManagerService.this.handlerServices, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.CONSOLEHANDLER_FORMATTER_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.consoleHandlerFormatterDetail)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.CONSOLEHANDLER_FORMATTER_PROPERTY, LogManagerService.this.consoleHandlerFormatterDetail, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.GFFILEHANDLER_FORMATTER_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.gffileHandlerFormatterDetail)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.GFFILEHANDLER_FORMATTER_PROPERTY, LogManagerService.this.gffileHandlerFormatterDetail, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.ROTATIONTIMELIMITINMINUTES_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.rotationOnTimeLimitInMinutesDetail)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.ROTATIONTIMELIMITINMINUTES_PROPERTY, LogManagerService.this.rotationOnTimeLimitInMinutesDetail, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.FLUSHFREQUENCY_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.flushFrequencyDetail)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.FLUSHFREQUENCY_PROPERTY, LogManagerService.this.flushFrequencyDetail, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.FILEHANDLER_LIMIT_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.filterHandlerDetails)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.FILEHANDLER_LIMIT_PROPERTY, LogManagerService.this.filterHandlerDetails, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.LOGTOCONSOLE_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.logToConsoleDetail)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.LOGTOCONSOLE_PROPERTY, LogManagerService.this.logToConsoleDetail, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.ROTATIONLIMITINBYTES_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.rotationInTimeLimitInBytesDetail)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.ROTATIONLIMITINBYTES_PROPERTY, LogManagerService.this.rotationInTimeLimitInBytesDetail, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.USESYSTEMLOGGING_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.useSystemLoggingDetail)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.USESYSTEMLOGGING_PROPERTY, LogManagerService.this.useSystemLoggingDetail, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.FILEHANDLER_COUNT_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.fileHandlerCountDetail)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.FILEHANDLER_COUNT_PROPERTY, LogManagerService.this.fileHandlerCountDetail, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.RETAINERRORSSTATICTICS_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.retainErrorsStaticticsDetail)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.RETAINERRORSSTATICTICS_PROPERTY, LogManagerService.this.retainErrorsStaticticsDetail, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.LOG4J_VERSION_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.log4jVersionDetail)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.LOG4J_VERSION_PROPERTY, LogManagerService.this.log4jVersionDetail, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.MAXHISTORY_FILES_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.maxHistoryFilesDetail)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.MAXHISTORY_FILES_PROPERTY, LogManagerService.this.maxHistoryFilesDetail, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.ROTATIONONDATECHANGE_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.rotationOnDateChangeDetail)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.ROTATIONONDATECHANGE_PROPERTY, LogManagerService.this.rotationOnDateChangeDetail, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.FILEHANDLER_PATTERN_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.fileHandlerPatternDetail)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.FILEHANDLER_PATTERN_PROPERTY, LogManagerService.this.fileHandlerPatternDetail, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.FILEHANDLER_FORMATTER_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.fileHandlerFormatterDetail)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.FILEHANDLER_FORMATTER_PROPERTY, LogManagerService.this.fileHandlerFormatterDetail, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.LOGFORMAT_DATEFORMAT_PROPERTY)) {
                                        if (val.equals(LogManagerService.this.logFormatDateFormatDetail)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.LOGFORMAT_DATEFORMAT_PROPERTY, LogManagerService.this.logFormatDateFormatDetail, props);
                                        continue;
                                    }
                                    if (a.equals(LogManagerService.EXCLUDE_FIELDS_PROPERTY)) {
                                        val = val == null ? "" : val;
                                        String string = LogManagerService.this.excludeFields = LogManagerService.this.excludeFields == null ? "" : LogManagerService.this.excludeFields;
                                        if (val.equals(LogManagerService.this.excludeFields)) continue;
                                        LogManagerService.this.generateAttributeChangeEvent(LogManagerService.EXCLUDE_FIELDS_PROPERTY, LogManagerService.this.excludeFields, props);
                                        continue;
                                    }
                                    if (!a.equals(LogManagerService.MULTI_LINE_MODE_PROPERTY) || val.equalsIgnoreCase(oldVal = Boolean.toString(LogManagerService.this.multiLineMode))) continue;
                                    LogManagerService.this.generateAttributeChangeEvent(LogManagerService.MULTI_LINE_MODE_PROPERTY, oldVal, props);
                                }
                                LOGGER.log(Level.INFO, "NCLS-LOGGING-00003");
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00002", e);
                            }
                        }
                    }

                    @Override
                    public void deleted(File deletedFile) {
                        LOGGER.log(Level.WARNING, "NCLS-LOGGING-00004", deletedFile.getAbsolutePath());
                    }
                });
            }
            if (!(catchUp = EarlyLogger.getEarlyMessages()).isEmpty()) {
                for (EarlyLogger.LevelAndMessage levelAndMessage : catchUp) {
                    LOGGER.log(levelAndMessage.getLevel(), levelAndMessage.getMessage());
                }
                catchUp.clear();
            }
            ArrayBlockingQueue catchEarlyMessage = EarlyLogHandler.earlyMessages;
            while (!catchEarlyMessage.isEmpty()) {
                LogRecord logRecord = (LogRecord)catchEarlyMessage.poll();
                if (logRecord == null) continue;
                LOGGER.log(logRecord);
            }
            return;
        }
    }

    private Collection<Handler> getHandlerServices() {
        String[] handlerServicesArray;
        HashSet<String> handlerServicesSet = new HashSet<String>();
        handlerServicesSet.add(GFFileHandler.class.getName());
        for (String handlerService : handlerServicesArray = this.handlerServices.split(",")) {
            handlerServicesSet.add(handlerService);
        }
        List handlers = this.habitat.getAllServices(Handler.class, new Annotation[0]);
        ArrayList<Handler> result = new ArrayList<Handler>();
        ArrayList<Handler> customHandlers = new ArrayList<Handler>();
        GFFileHandler gfFileHandler = null;
        for (Handler handler : handlers) {
            String handlerClassName = handler.getClass().getName();
            if (handlerServicesSet.contains(handlerClassName)) {
                result.add(handler);
            }
            if (handlerClassName.equals(GFFileHandler.class.getName())) {
                gfFileHandler = (GFFileHandler)handler;
                continue;
            }
            customHandlers.add(handler);
        }
        for (Handler handler : customHandlers) {
            try {
                String handlerClassName;
                Map<String, String> props = this.getLoggingProperties();
                String formatterClassName = props.get((handlerClassName = handler.getClass().getName()) + ".formatter");
                Formatter formatter = this.getCustomFormatter(formatterClassName, gfFileHandler);
                if (formatter == null) continue;
                handler.setFormatter(formatter);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00002", e);
            }
        }
        return result;
    }

    private Formatter getCustomFormatter(String formatterClassName, GFFileHandler gfFileHandler) {
        try {
            Class<?> customFormatterClass = ClassLoader.getSystemClassLoader().loadClass(formatterClassName);
            return (Formatter)customFormatterClass.newInstance();
        }
        catch (Exception e) {
            return gfFileHandler.findFormatterService(formatterClassName);
        }
    }

    public void generateAttributeChangeEvent(String property, String propertyDetail, Map props) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, property, propertyDetail, props.get(property));
        UnprocessedChangeEvents ucel = new UnprocessedChangeEvents(new UnprocessedChangeEvent(pce, "server log file attribute " + property + " changed."));
        ArrayList<UnprocessedChangeEvents> b = new ArrayList<UnprocessedChangeEvents>();
        b.add(ucel);
        this.ucl.unprocessedTransactedEvents(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(Handler handler) {
        Logger rootLogger = Logger.getLogger("");
        if (rootLogger != null) {
            Map<String, Handler> map = this.gfHandlers;
            synchronized (map) {
                rootLogger.addHandler(handler);
                String handlerName = handler.toString();
                this.gfHandlers.put(handlerName.substring(0, handlerName.indexOf("@")), handler);
            }
        }
    }

    public void preDestroy() {
        try {
            for (ServiceHandle i : this.habitat.getAllServiceHandles((Filter)BuilderHelper.createContractFilter((String)Handler.class.getName()))) {
                i.destroy();
            }
            System.setOut(this.oStdOutBackup);
            System.setErr(this.oStdErrBackup);
            if (this.stdoutOutputStream != null) {
                this.stdoutOutputStream.close();
            }
            if (this.stderrOutputStream != null) {
                this.stderrOutputStream.close();
            }
            System.out.println("Completed shutdown of Log manager service");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

