/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf.core;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.faces.application.Application;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIPanel;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagConfig;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MetadataHandler
extends TagHandlerImpl {
    private static final Logger LOGGER = FacesLogger.TAGLIB.getLogger();

    public MetadataHandler(TagConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        Util.notNull("parent", parent);
        UIViewRoot root = parent instanceof UIViewRoot ? (UIViewRoot)parent : ctx.getFacesContext().getViewRoot();
        if (root == null) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "jsf.metadata.uiviewroot.unavailable");
            }
            return;
        }
        UIComponent facetComponent = null;
        if (root.getFacetCount() > 0) {
            facetComponent = root.getFacets().get("jakarta_faces_metadata");
        }
        if (facetComponent == null) {
            root.getAttributes().put("facelets.FACET_NAME", "jakarta_faces_metadata");
            try {
                this.nextHandler.apply(ctx, root);
            }
            finally {
                root.getAttributes().remove("facelets.FACET_NAME");
            }
            facetComponent = root.getFacets().get("jakarta_faces_metadata");
            if (facetComponent != null && !(facetComponent instanceof UIPanel)) {
                Application app = ctx.getFacesContext().getApplication();
                UIComponent panelGroup = app.createComponent("jakarta.faces.Panel");
                panelGroup.getChildren().add(facetComponent);
                root.getFacets().put("jakarta_faces_metadata", panelGroup);
                facetComponent = panelGroup;
            }
            if (null != facetComponent) {
                facetComponent.setId("jakarta_faces_metadata");
            }
        }
    }
}

