/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.ViewScopeContext;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import com.sun.faces.util.cdi11.CDIUtil;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.faces.view.ViewScoped;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ViewScopeExtension
implements Extension {
    private boolean isCdiOneOneOrGreater = false;
    private CDIUtil cdiUtil = null;
    private static final Logger LOGGER = FacesLogger.APPLICATION_VIEW.getLogger();

    public ViewScopeExtension() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Constructor @ViewScoped CDI Extension called");
        }
        this.isCdiOneOneOrGreater = Util.isCdiOneOneOrLater(null);
    }

    public void processBean(@Observes ProcessBean<?> event) {
        ViewScoped viewScoped = (ViewScoped)event.getAnnotated().getAnnotation(ViewScoped.class);
        if (viewScoped != null && LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Processing occurrence of @ViewScoped");
        }
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        event.addScope(ViewScoped.class, true, true);
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Adding @ViewScoped context to CDI runtime");
        }
        event.addContext((Context)new ViewScopeContext());
        if (this.isCdiOneOneOrGreater) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.sun.faces.application.view.ViewScopedCDIEventFireHelperImpl");
            }
            catch (ClassNotFoundException ex) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "CDI 1.1 events not enabled", ex);
                }
                return;
            }
            if (null == this.cdiUtil) {
                ServiceLoader<CDIUtil> oneCdiUtil = ServiceLoader.load(CDIUtil.class);
                for (CDIUtil oneAndOnly : oneCdiUtil) {
                    if (null != this.cdiUtil) {
                        String message = "Must only have one implementation of CDIUtil available";
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, message);
                        }
                        throw new IllegalStateException(message);
                    }
                    this.cdiUtil = oneAndOnly;
                }
            }
            if (null != this.cdiUtil) {
                Bean bean = this.cdiUtil.createHelperBean(beanManager, clazz);
                event.addBean(bean);
            } else if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unable to obtain CDI 1.1 utilities for Mojarra");
            }
        }
    }
}

