/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.regex.Pattern;
import org.testng.IExpectedExceptionsHolder;
import org.testng.ITestNGMethod;
import org.testng.annotations.IExpectedExceptionsAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.internal.annotations.IAnnotationFinder;

public class RegexpExpectedExceptionsHolder
implements IExpectedExceptionsHolder {
    public static final String DEFAULT_REGEXP = ".*";
    private final IAnnotationFinder finder;
    private final ITestNGMethod method;

    public RegexpExpectedExceptionsHolder(IAnnotationFinder finder, ITestNGMethod method) {
        this.finder = finder;
        this.method = method;
    }

    @Override
    public boolean isThrowableMatching(Throwable ite) {
        String messageRegExp = this.getRegExp();
        if (DEFAULT_REGEXP.equals(messageRegExp)) {
            return true;
        }
        String message = ite.getMessage();
        return message != null && Pattern.compile(messageRegExp, 32).matcher(message).matches();
    }

    @Override
    public String getWrongExceptionMessage(Throwable ite) {
        return "The exception was thrown with the wrong message: expected \"" + this.getRegExp() + "\"" + " but got \"" + ite.getMessage() + "\"";
    }

    private String getRegExp() {
        IExpectedExceptionsAnnotation expectedExceptions = this.finder.findAnnotation(this.method, IExpectedExceptionsAnnotation.class);
        if (expectedExceptions != null) {
            return DEFAULT_REGEXP;
        }
        ITestAnnotation testAnnotation = this.finder.findAnnotation(this.method, ITestAnnotation.class);
        if (testAnnotation != null) {
            return testAnnotation.getExpectedExceptionsMessageRegExp();
        }
        return DEFAULT_REGEXP;
    }
}

