/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.valueextraction.declaration;

import java.util.Optional;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.valueextraction.declaration.model.Cinema;
import org.hibernate.beanvalidation.tck.tests.valueextraction.declaration.model.Reference;
import org.hibernate.beanvalidation.tck.tests.valueextraction.declaration.model.ReferenceValueExtractor2;
import org.hibernate.beanvalidation.tck.tests.valueextraction.declaration.model.ReferenceValueExtractor3;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ValueExtractorsPrecedenceTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ValueExtractorsPrecedenceTest.webArchiveBuilder().withTestClass(ValueExtractorsPrecedenceTest.class)).withPackage(Cinema.class.getPackage())).withValidationXml("value-extractors-precedence-validation.xml")).withResource("javax.validation.valueextraction.ValueExtractor", "META-INF/services/javax.validation.valueextraction.ValueExtractor", true)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-registering", id="e"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="n")})
    public void valueExtractorPrecedenceIsAppliedCorrectly() {
        Cinema cinema = Cinema.invalidReference();
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        Set violations = validator.validate((Object)cinema, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("visitor").containerElement("1", false, null, null, Reference.class, 0));
        ValidatorFactory validatorFactory = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new ReferenceValueExtractor2()).buildValidatorFactory();
        validator = validatorFactory.getValidator();
        violations = validator.validate((Object)cinema, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("visitor").containerElement("2", false, null, null, Reference.class, 0));
        validator = validatorFactory.usingContext().addValueExtractor((ValueExtractor)new ReferenceValueExtractor3()).getValidator();
        violations = validator.validate((Object)cinema, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("visitor").containerElement("3", false, null, null, Reference.class, 0));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-registering", id="e"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="n")})
    public void valueExtractorDefinedInXmlHasPrecedenceOverBuiltInValueExtractors() {
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        Set violations = validator.validate((Object)Cinema.invalidName(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("name").containerElement("<optional>", false, null, null, Optional.class, 0));
    }
}

