/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.groups.Default;
import javax.validation.metadata.ContainerElementTypeDescriptor;
import javax.validation.metadata.GroupConversionDescriptor;
import javax.validation.metadata.ReturnValueDescriptor;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.metadata.BasicChecks;
import org.hibernate.beanvalidation.tck.tests.metadata.ComplexChecks;
import org.hibernate.beanvalidation.tck.tests.metadata.ComplexProductTypeChecks;
import org.hibernate.beanvalidation.tck.tests.metadata.CustomerService;
import org.hibernate.beanvalidation.tck.tests.metadata.Executables;
import org.hibernate.beanvalidation.tck.tests.metadata.MetaDataTestUtil;
import org.hibernate.beanvalidation.tck.tests.metadata.ProductOrderLine;
import org.hibernate.beanvalidation.tck.tests.metadata.ProductType;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ReturnValueDescriptorTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ReturnValueDescriptorTest.webArchiveBuilder().withTestClassPackage(ReturnValueDescriptorTest.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="a")
    public void testGetElementClassForMethod() {
        ReturnValueDescriptor descriptor = Executables.returnValueConstrainedMethod().getReturnValueDescriptor();
        Assert.assertEquals((Object)descriptor.getElementClass(), Integer.TYPE);
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="a")
    public void testGetElementClassForVoidMethod() {
        ReturnValueDescriptor descriptor = Executables.parameterConstrainedMethod().getReturnValueDescriptor();
        Assert.assertEquals((Object)descriptor.getElementClass(), Void.TYPE);
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="a")
    public void testGetElementClassForConstructor() {
        ReturnValueDescriptor descriptor = Executables.returnValueConstrainedConstructor().getReturnValueDescriptor();
        Assert.assertEquals((Object)descriptor.getElementClass(), CustomerService.class);
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="a")
    public void testIsCascadedForMethodReturnValue() {
        ReturnValueDescriptor descriptor = Executables.returnValueConstrainedMethod().getReturnValueDescriptor();
        Assert.assertFalse((boolean)descriptor.isCascaded(), (String)"Should not be cascaded");
        descriptor = Executables.cascadedReturnValueMethod().getReturnValueDescriptor();
        Assert.assertTrue((boolean)descriptor.isCascaded(), (String)"Should be cascaded");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="a")
    public void testIsCascadedForConstructorReturnValue() {
        ReturnValueDescriptor descriptor = Executables.returnValueConstrainedConstructor().getReturnValueDescriptor();
        Assert.assertFalse((boolean)descriptor.isCascaded(), (String)"Should not be cascaded");
        descriptor = Executables.cascadedReturnValueConstructor().getReturnValueDescriptor();
        Assert.assertTrue((boolean)descriptor.isCascaded(), (String)"Should be cascaded");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="a")
    public void testIsCascadedForVoidMethod() {
        ReturnValueDescriptor descriptor = Executables.parameterConstrainedMethod().getReturnValueDescriptor();
        Assert.assertFalse((boolean)descriptor.isCascaded());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="a"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="b")})
    public void testGetGroupConversionsForConstructorReturnValue() {
        ReturnValueDescriptor returnValueDescriptor = Executables.constructorWithGroupConversionOnReturnValue().getReturnValueDescriptor();
        Set groupConversions = returnValueDescriptor.getGroupConversions();
        Assert.assertEquals((int)groupConversions.size(), (int)2);
        for (GroupConversionDescriptor groupConversionDescriptor : groupConversions) {
            if (groupConversionDescriptor.getFrom().equals(Default.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), BasicChecks.class);
                continue;
            }
            if (groupConversionDescriptor.getFrom().equals(CustomerService.StrictCustomerServiceChecks.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), CustomerService.StrictChecks.class);
                continue;
            }
            Assert.fail((String)String.format("Encountered unexpected group conversion from %s to %s", groupConversionDescriptor.getFrom().getName(), groupConversionDescriptor.getTo().getName()));
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="a"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="b")})
    public void testGetGroupConversionsForVoidMethod() {
        ReturnValueDescriptor descriptor = Executables.parameterConstrainedMethod().getReturnValueDescriptor();
        Assert.assertTrue((boolean)descriptor.getGroupConversions().isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="a"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="b")})
    public void testGetGroupConversionsForMethodReturnValue() {
        ReturnValueDescriptor returnValueDescriptor = Executables.methodWithGroupConversionOnReturnValue().getReturnValueDescriptor();
        Set groupConversions = returnValueDescriptor.getGroupConversions();
        Assert.assertEquals((int)groupConversions.size(), (int)2);
        for (GroupConversionDescriptor groupConversionDescriptor : groupConversions) {
            if (groupConversionDescriptor.getFrom().equals(Default.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), BasicChecks.class);
                continue;
            }
            if (groupConversionDescriptor.getFrom().equals(CustomerService.StrictCustomerServiceChecks.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), CustomerService.StrictChecks.class);
                continue;
            }
            Assert.fail((String)String.format("Encountered unexpected group conversion from %s to %s", groupConversionDescriptor.getFrom().getName(), groupConversionDescriptor.getTo().getName()));
        }
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b")
    public void testGetGroupConversionsReturnsEmptySetForConstructorReturnValue() {
        ReturnValueDescriptor returnValueDescriptor = Executables.cascadedReturnValueMethod().getReturnValueDescriptor();
        Set groupConversions = returnValueDescriptor.getGroupConversions();
        Assert.assertNotNull((Object)groupConversions);
        Assert.assertTrue((boolean)groupConversions.isEmpty());
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b")
    public void testGetGroupConversionsReturnsEmptySetForMethodReturnValue() {
        ReturnValueDescriptor returnValueDescriptor = Executables.cascadedReturnValueConstructor().getReturnValueDescriptor();
        Set groupConversions = returnValueDescriptor.getGroupConversions();
        Assert.assertNotNull((Object)groupConversions);
        Assert.assertTrue((boolean)groupConversions.isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="c"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="d"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="e")})
    public void testGetContainerElementMetaDataForReturnValue() {
        ReturnValueDescriptor returnValueDescriptor = Executables.returnValueWithCascadedContainerElements().getReturnValueDescriptor();
        Set containerElementTypes = returnValueDescriptor.getConstrainedContainerElementTypes();
        Assert.assertEquals((int)containerElementTypes.size(), (int)2);
        ContainerElementTypeDescriptor productType = MetaDataTestUtil.getContainerElementDescriptor(containerElementTypes, Map.class, 0);
        Assert.assertEquals((Object)productType.getElementClass(), ProductType.class);
        MetaDataTestUtil.assertConstraintDescriptors(productType.getConstraintDescriptors(), NotNull.class);
        Assert.assertEquals((int)productType.getConstrainedContainerElementTypes().size(), (int)0);
        Assert.assertTrue((boolean)productType.isCascaded());
        Assert.assertEquals((int)productType.getGroupConversions().size(), (int)2);
        for (GroupConversionDescriptor groupConversionDescriptor : productType.getGroupConversions()) {
            if (groupConversionDescriptor.getFrom().equals(Default.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), BasicChecks.class);
                continue;
            }
            if (groupConversionDescriptor.getFrom().equals(ComplexChecks.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), ComplexProductTypeChecks.class);
                continue;
            }
            Assert.fail((String)String.format("Encountered unexpected group conversion from %s to %s", groupConversionDescriptor.getFrom().getName(), groupConversionDescriptor.getTo().getName()));
        }
        ContainerElementTypeDescriptor orderLineList = MetaDataTestUtil.getContainerElementDescriptor(containerElementTypes, Map.class, 1);
        Assert.assertEquals((Object)orderLineList.getElementClass(), List.class);
        MetaDataTestUtil.assertConstraintDescriptors(orderLineList.getConstraintDescriptors(), Size.class);
        Assert.assertFalse((boolean)orderLineList.isCascaded());
        Assert.assertEquals((int)orderLineList.getGroupConversions().size(), (int)0);
        Assert.assertEquals((int)orderLineList.getConstrainedContainerElementTypes().size(), (int)1);
        ContainerElementTypeDescriptor orderLine = MetaDataTestUtil.getContainerElementDescriptor(orderLineList.getConstrainedContainerElementTypes(), List.class, 0);
        Assert.assertEquals((Object)orderLine.getElementClass(), ProductOrderLine.class);
        MetaDataTestUtil.assertConstraintDescriptors(orderLine.getConstraintDescriptors(), NotNull.class);
        Assert.assertEquals((int)orderLine.getConstrainedContainerElementTypes().size(), (int)0);
        Assert.assertFalse((boolean)orderLine.isCascaded());
    }
}

