/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.releng.p2.to.maven;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.scada.releng.p2.to.maven.Activator;
import org.eclipse.scada.releng.p2.to.maven.DefaultMavenMapping;
import org.eclipse.scada.releng.p2.to.maven.MavenDependency;
import org.eclipse.scada.releng.p2.to.maven.MavenMapping;
import org.eclipse.scada.releng.p2.to.maven.MavenReference;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Processor {
    private static final SimpleDateFormat META_DF = new SimpleDateFormat("yyyyMMddHHmmss");
    private final boolean dryRun = Boolean.getBoolean("dryRun");
    private final boolean fakeForCentral = Boolean.getBoolean("fakeForCentral");
    private final IProvisioningAgent agent;
    private final File output;
    private final MavenMapping mapping;
    private final URI repositoryLocation;
    private final Properties properties;
    private final DocumentBuilderFactory documentBuilderFactor;
    private final DocumentBuilder documentBuilder;
    private final TransformerFactory transformerFactory;
    private IMetadataRepository metaRepo;
    private IArtifactRepository artRepo;
    private final IMetadataRepositoryManager metaManager;
    private final IArtifactRepositoryManager artManager;
    private final Set<URI> validationRepositoryUris = new HashSet<URI>();
    private final Map<URI, IMetadataRepository> validationRepositories = new HashMap<URI, IMetadataRepository>();
    private final Map<MavenReference, Set<String>> metadata = new HashMap<MavenReference, Set<String>>();
    private final List<Developer> developers = new LinkedList<Developer>();
    private final Set<MavenDependency> mavenDependencies = new HashSet<MavenDependency>();
    private final Set<MavenReference> mavenExports = new HashSet<MavenReference>();
    private final List<String> errors = new LinkedList<String>();

    public Processor(IProvisioningAgent agent, File output, URI repositoryLocation, Properties properties) throws Exception {
        this.mapping = Processor.makeMappingInstance(properties);
        this.agent = agent;
        this.output = output;
        this.properties = properties;
        this.repositoryLocation = repositoryLocation;
        this.metaManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        this.artManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        this.documentBuilderFactor = DocumentBuilderFactory.newInstance();
        this.documentBuilder = this.documentBuilderFactor.newDocumentBuilder();
        this.transformerFactory = TransformerFactory.newInstance();
        this.loadDevelopers();
    }

    private void loadDevelopers() {
        String devs = this.properties.getProperty("developers");
        String[] stringArray = devs.split("\\s*,+\\s*");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String dev = stringArray[n2];
            this.developers.add(this.loadDeveloper(dev));
            ++n2;
        }
    }

    private Developer loadDeveloper(String dev) {
        Developer result = new Developer();
        result.id = dev;
        result.name = this.properties.getProperty(String.format("developer.%s.name", dev));
        result.email = this.properties.getProperty(String.format("developer.%s.email", dev));
        result.url = this.properties.getProperty(String.format("developer.%s.url", dev));
        return result;
    }

    private static MavenMapping makeMappingInstance(Properties properties) throws Exception {
        String clazzName = properties.getProperty("implementation.mavenMapping", DefaultMavenMapping.class.getName());
        if (clazzName == null || clazzName.isEmpty()) {
            return new DefaultMavenMapping(properties);
        }
        BundleContext context = Activator.getDefault().getContext();
        Class clazz = context.getBundle().loadClass(clazzName);
        Constructor ctor = clazz.getConstructor(Properties.class);
        return (MavenMapping)MavenMapping.class.cast(ctor.newInstance(properties));
    }

    public void addValidationRepository(URI uri) {
        this.validationRepositoryUris.add(uri);
    }

    public void process(IProgressMonitor pm) throws Exception {
        this.output.mkdirs();
        System.out.println("Loading metadata...");
        this.metaRepo = this.metaManager.loadRepository(this.repositoryLocation, pm);
        System.out.println("Loading artifacts...");
        this.artRepo = this.artManager.loadRepository(this.repositoryLocation, pm);
        System.out.println("done!");
        for (URI uri : this.validationRepositoryUris) {
            System.out.println("Loading validation repository: " + uri);
            IMetadataRepository repo = this.metaManager.loadRepository(uri, pm);
            this.validationRepositories.put(uri, repo);
            System.out.println("Done!");
        }
        IQuery query = QueryUtil.createIUAnyQuery();
        IQueryResult result = this.metaRepo.query(query, pm);
        for (IInstallableUnit iu : result) {
            this.processUnit(iu, pm);
        }
        this.writeUploadScript();
        for (Map.Entry<MavenReference, Set<String>> entry : this.metadata.entrySet()) {
            this.writeMetaData(entry.getKey(), entry.getValue());
        }
    }

    private void writeUploadScript() throws IOException {
        Path path = this.output.toPath().resolve("upload.sh");
        int maxJobs = Integer.getInteger("maxUploadJobs", 1);
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter script = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));){
            script.println("#!/bin/bash");
            script.println();
            script.println("set -e");
            script.println();
            script.println("REPO=${REPO:-https://oss.sonatype.org/service/local/staging/deploy/maven2/}");
            script.println("ID=${ID:-ossrh}");
            script.println("MVN=${MVN:-mvn}");
            script.println();
            if (maxJobs > 1) {
                script.format("function waitMax { while [ $(jobs -rp | wc -l) -ge %s ] ; do sleep 1; done }%n%n", maxJobs);
            }
            List<MavenReference> exports = this.getMavenExports();
            Collections.sort(exports, MavenReference.COMPARATOR);
            for (MavenReference export : exports) {
                if (maxJobs > 1) {
                    script.print("waitMax; ");
                }
                script.print("\"$MVN\" gpg:sign-and-deploy-file -Durl=\"$REPO\" -DrepositoryId=$ID ");
                script.format(" -DpomFile=%s", Processor.makePomName(export));
                script.format(" -Dfile=%s", Processor.makeFileName(export));
                if (export.getClassifier() != null) {
                    script.format(" -Dclassifier=%s", export.getClassifier());
                }
                if (maxJobs <= 1) continue;
                script.println(" &");
            }
            script.println();
            if (maxJobs > 1) {
                script.println("wait");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String makePomName(MavenReference export) {
        return String.format("%1$s/%2$s/%3$s/%2$s-%3$s.pom", export.getGroupId().replace('.', File.separatorChar), export.getArtifactId(), export.getVersion());
    }

    private static String makeFileName(MavenReference export) {
        String groupPath = export.getGroupId().replace('.', File.separatorChar);
        if (export.getClassifier() == null) {
            return String.format("%1$s/%2$s/%3$s/%2$s-%3$s.jar", groupPath, export.getArtifactId(), export.getVersion());
        }
        return String.format("%1$s/%2$s/%3$s/%2$s-%3$s-%4$s.jar", groupPath, export.getArtifactId(), export.getVersion(), export.getClassifier());
    }

    private void writeMetaData(MavenReference key, Set<String> value) throws Exception {
        File base = this.makeBase(key.getGroupId(), key.getArtifactId());
        File file = new File(base, "maven-metadata.xml");
        System.out.println("Write meta data: " + file);
        Document doc = this.documentBuilder.newDocument();
        Element main = doc.createElement("metadata");
        doc.appendChild(main);
        this.addElement(main, "groupId", key.getGroupId());
        this.addElement(main, "artifactId", key.getArtifactId());
        this.addElement(main, "version", key.getVersion());
        Element v = doc.createElement("versioning");
        main.appendChild(v);
        Element vs = doc.createElement("versions");
        v.appendChild(vs);
        for (String version : value) {
            this.addElement(vs, "version", version);
        }
        this.addElement(v, "lastUpdated", META_DF.format(new Date()));
        this.saveXml(doc, file);
        this.makeChecksum("MD5", file, new File(base, "maven-metadata.xml.md5"));
        this.makeChecksum("SHA1", file, new File(base, "maven-metadata.xml.sha1"));
    }

    private void processUnit(IInstallableUnit iu, IProgressMonitor pm) throws Exception {
        IArtifactKey art = this.findArtifact(iu);
        if (art == null) {
            System.out.println("Ignore: " + iu);
            return;
        }
        System.out.println("IU : " + iu + " -> " + art);
        if (this.ignoreMirror(iu)) {
            System.out.println("Action: SKIP");
            return;
        }
        for (Map.Entry entry : iu.getProperties().entrySet()) {
            System.out.println(String.format("\t%s -> %s", entry.getKey(), entry.getValue()));
        }
        MavenReference ref = this.mapping.makeReference(iu);
        System.out.println("POM : " + ref);
        File base = this.makeBase(ref.getGroupId(), ref.getArtifactId());
        File versionBase = new File(base, ref.getVersion());
        versionBase.mkdirs();
        System.out.println("\tStoring to: " + base);
        this.mirrorArtifact(art, versionBase, ref, pm);
        if (ref.getClassifier() == null) {
            Set<MavenDependency> deps = this.makeDependencies(iu, pm);
            this.makePom(ref, versionBase, deps, iu);
            this.makeMetaData(ref, versionBase);
            this.makeFake(ref, versionBase, "javadoc");
            this.makeFake(ref, versionBase, "sources");
            this.mavenDependencies.addAll(deps);
        }
        this.mavenExports.add(ref);
    }

    private Set<MavenDependency> makeDependencies(IInstallableUnit iu, IProgressMonitor pm) throws Exception {
        HashSet<MavenDependency> result = new HashSet<MavenDependency>();
        for (IRequirement req : iu.getRequirements()) {
            MavenDependency dep;
            if (!(req instanceof IRequiredCapability) || (dep = this.makeDependency(iu, (IRequiredCapability)req, pm)) == null) continue;
            result.add(dep);
        }
        return result;
    }

    private MavenDependency makeDependency(IInstallableUnit iu, IRequiredCapability req, IProgressMonitor pm) throws Exception {
        if (this.ignoreDependency(req)) {
            return null;
        }
        System.out.println("\tDep: " + req + " NS: " + req.getNamespace());
        IInstallableUnit depIu = this.findBest(this.findCandidates((IRequirement)req, pm));
        if (depIu == null) {
            if (req.getMin() <= 0) {
                return null;
            }
            throw new IllegalArgumentException(String.format("Unable to find dependency - req: %s (min: %s)", req, req.getMin()));
        }
        if (iu.equals((Object)depIu)) {
            return null;
        }
        MavenReference ref = this.mapping.makeReference(depIu);
        if (ref == null) {
            return null;
        }
        MavenDependency result = new MavenDependency();
        result.setGroupId(ref.getGroupId());
        result.setArtifactId(ref.getArtifactId());
        result.setVersion(ref.getVersion());
        result.setOptional(req.getMin() <= 0);
        System.out.println("\t\tResolve to: " + result);
        return result;
    }

    private Set<IInstallableUnit> findCandidates(IRequirement req, IProgressMonitor pm) {
        IQuery query = QueryUtil.createMatchQuery((IExpression)req.getMatches(), (Object[])new Object[0]);
        Set result = this.metaRepo.query(query, pm).toUnmodifiableSet();
        if (!result.isEmpty()) {
            return result;
        }
        for (IMetadataRepository repo : this.validationRepositories.values()) {
            Set result2 = repo.query(query, pm).toUnmodifiableSet();
            if (result2.isEmpty()) continue;
            return result2;
        }
        return Collections.emptySet();
    }

    private IInstallableUnit findBest(Set<IInstallableUnit> candidates) {
        if (candidates.isEmpty()) {
            return null;
        }
        return candidates.iterator().next();
    }

    private void makeMetaData(MavenReference ref, File versionBase) throws Exception {
        Document doc = this.documentBuilder.newDocument();
        Element metadata = doc.createElement("metadata");
        doc.appendChild(metadata);
        this.addElement(metadata, "groupId", ref.getGroupId());
        this.addElement(metadata, "artifactId", ref.getArtifactId());
        this.addElement(metadata, "version", ref.getVersion());
        File file = new File(versionBase, "maven-metadata.xml");
        this.saveXml(doc, file);
        this.makeChecksum("MD5", file, new File(versionBase, "maven-metadata.xml.md5"));
        this.makeChecksum("SHA1", file, new File(versionBase, "maven-metadata.xml.sha1"));
    }

    private void makeFake(MavenReference ref, File versionBase, String classifier) throws Exception {
        if (!this.fakeForCentral) {
            return;
        }
        String name = String.valueOf(ref.getArtifactId()) + "-" + ref.getVersion() + "-" + classifier + ".jar";
        File file = new File(versionBase, name);
        this.mavenExports.add(new MavenReference(ref.getGroupId(), ref.getArtifactId(), ref.getVersion(), classifier));
        if (file.exists()) {
            return;
        }
        Throwable throwable = null;
        Object var7_7 = null;
        try {
            JarOutputStream jar = new JarOutputStream(new FileOutputStream(file));
            if (jar != null) {
                jar.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.makeChecksum("MD5", file, new File(versionBase, String.valueOf(name) + ".md5"));
        this.makeChecksum("SHA1", file, new File(versionBase, String.valueOf(name) + ".sha1"));
    }

    private void makePom(MavenReference ref, File versionBase, Set<MavenDependency> deps, IInstallableUnit iu) throws Exception {
        String description;
        Document doc = this.documentBuilder.newDocument();
        Element project = doc.createElementNS("http://maven.apache.org/POM/4.0.0", "project");
        project.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd");
        doc.appendChild(project);
        this.addElement(project, "modelVersion", "4.0.0");
        this.addElement(project, "groupId", ref.getGroupId());
        this.addElement(project, "artifactId", ref.getArtifactId());
        this.addElement(project, "version", ref.getVersion());
        this.addElement(project, "url", this.makeProjectUrl(iu));
        String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
        if (name == null) {
            name = String.format("%s:%s", ref.getGroupId(), ref.getArtifactId());
        }
        if ((description = iu.getProperty("org.eclipse.equinox.p2.description", null)) == null) {
            description = name;
        }
        this.addElement(project, "name", name);
        this.addElement(project, "description", description);
        this.addDevelopers(project);
        if (ref.getArtifactId().startsWith("org.eclipse.")) {
            this.addEpl(project);
        } else {
            this.errors.add(String.format("%s: no license information", ref));
        }
        String scm = this.loadScm(versionBase, ref);
        if (scm == null) {
            this.errors.add(String.format("%s: no scm information", ref));
        } else {
            this.makeScm(doc, project, scm);
        }
        if (!deps.isEmpty()) {
            Element depsEle = doc.createElement("dependencies");
            project.appendChild(depsEle);
            for (MavenDependency dep : deps) {
                Element depEle = doc.createElement("dependency");
                depsEle.appendChild(depEle);
                this.addElement(depEle, "groupId", dep.getGroupId());
                this.addElement(depEle, "artifactId", dep.getArtifactId());
                this.addElement(depEle, "version", dep.getVersion());
                if (!dep.isOptional()) continue;
                this.addElement(depEle, "optional", "true");
            }
        }
        File pomFile = new File(versionBase, String.valueOf(ref.getArtifactId()) + "-" + ref.getVersion() + ".pom");
        this.saveXml(doc, pomFile);
        this.makeChecksum("MD5", pomFile, new File(versionBase, String.valueOf(ref.getArtifactId()) + "-" + ref.getVersion() + ".pom.md5"));
        this.makeChecksum("SHA1", pomFile, new File(versionBase, String.valueOf(ref.getArtifactId()) + "-" + ref.getVersion() + ".pom.sha1"));
        this.addMetaDataVersion(ref);
    }

    private void makeScm(Document doc, Element project, String scm) {
        String[] scmToks = scm.split(";", 2);
        Element scmEle = doc.createElement("scm");
        project.appendChild(scmEle);
        this.addElement(scmEle, "connection", scm);
        this.addElement(scmEle, "developerConnection", scm);
        if (scmToks.length > 0) {
            String key = "scm.url." + scmToks[0];
            String url = this.properties.getProperty(key);
            if (url == null) {
                throw new IllegalStateException(String.format("SCM URL missing for key '%s'", key));
            }
            this.addElement(scmEle, "url", url);
        }
    }

    private void addDevelopers(Element project) {
        Document doc = project.getOwnerDocument();
        Element devs = doc.createElement("developers");
        project.appendChild(devs);
        for (Developer dev : this.developers) {
            Element devNode = doc.createElement("developer");
            devs.appendChild(devNode);
            this.addElement(devNode, "id", dev.id);
            this.addElement(devNode, "name", dev.name);
            this.addElement(devNode, "email", dev.email);
            this.addElement(devNode, "url", dev.url);
        }
    }

    private String loadScm(File versionBase, MavenReference ref) {
        File jarFile;
        block13: {
            try {
                jarFile = new File(versionBase, String.valueOf(ref.getArtifactId()) + "-" + ref.getVersion() + ".jar");
                if (jarFile.isFile()) break block13;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        Throwable throwable = null;
        Object var5_7 = null;
        try (JarFile jar = new JarFile(jarFile);){
            Manifest mf = jar.getManifest();
            String scm = mf.getMainAttributes().getValue("Eclipse-SourceReferences");
            return scm;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void addEpl(Element project) {
        Document doc = project.getOwnerDocument();
        Element lics = doc.createElement("licenses");
        project.appendChild(lics);
        Element lic = doc.createElement("license");
        lics.appendChild(lic);
        this.addElement(lic, "name", "The Eclipse Public License Version 1.0");
        this.addElement(lic, "url", "http://www.eclipse.org/legal/epl-v10.html");
        this.addElement(lic, "distribution", "repo");
    }

    private String makeProjectUrl(IInstallableUnit iu) {
        String url = iu.getProperty("org.eclipse.equinox.p2.doc.url", null);
        if (url == null || url.isEmpty()) {
            url = this.properties.getProperty("default.project.url");
        }
        return url;
    }

    private void addMetaDataVersion(MavenReference ref) {
        MavenReference metaRef = new MavenReference(ref.getGroupId(), ref.getArtifactId(), "1");
        Set<String> versions = this.metadata.get(metaRef);
        if (versions == null) {
            versions = new HashSet<String>();
            this.metadata.put(metaRef, versions);
        }
        versions.add(ref.getVersion());
    }

    private void addElement(Element parent, String name, String value) {
        if (value == null) {
            return;
        }
        Element ele = parent.getOwnerDocument().createElement(name);
        parent.appendChild(ele);
        ele.appendChild(parent.getOwnerDocument().createTextNode(value));
    }

    private void saveXml(Document doc, File file) throws Exception {
        Transformer transformer = this.transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        transformer.transform(source, result);
    }

    private void mirrorArtifact(IArtifactKey art, File versionBase, MavenReference ref, IProgressMonitor pm) throws Exception {
        if (this.dryRun) {
            return;
        }
        File jarFile = new File(versionBase, ref.toFileName());
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileOutputStream output = new FileOutputStream(jarFile);){
            IArtifactDescriptor desc = this.artRepo.createArtifactDescriptor(art);
            System.out.println("Storing to: " + jarFile);
            this.artRepo.getArtifact(desc, (OutputStream)output, pm);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.makeChecksum("MD5", jarFile, new File(versionBase, ref.toFileName("md5")));
        this.makeChecksum("SHA1", jarFile, new File(versionBase, ref.toFileName("sha1")));
    }

    private void makeChecksum(String mdName, File sourceFile, File targetFile) throws Exception {
        MessageDigest md = MessageDigest.getInstance(mdName);
        byte[] buffer = new byte[4096];
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(sourceFile));){
            int len;
            while ((len = ((InputStream)input).read(buffer)) > 0) {
                md.update(buffer, 0, len);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        byte[] result = md.digest();
        StringBuilder sb = new StringBuilder(result.length * 2);
        byte[] byArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02x", b));
            ++n2;
        }
        Throwable throwable3 = null;
        Object var9_15 = null;
        try (PrintWriter pw = new PrintWriter(targetFile);){
            pw.print(sb.toString());
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
    }

    private boolean ignoreMirror(IInstallableUnit iu) {
        String value = this.properties.getProperty("mirror." + iu.getId(), null);
        if (value != null) {
            return !Boolean.parseBoolean(value);
        }
        value = this.properties.getProperty("external." + iu.getId());
        return value != null;
    }

    private boolean ignoreDependency(IRequiredCapability req) {
        String ns = req.getNamespace();
        String name = req.getName();
        String value = this.properties.getProperty("dependency." + ns + "." + name + ".ignore", "false");
        return Boolean.parseBoolean(value);
    }

    private File makeBase(String groupId, String artifactId) {
        String[] toks = groupId.split("\\.");
        File file = this.output;
        String[] stringArray = toks;
        int n = toks.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            file = new File(file, tok);
            ++n2;
        }
        return new File(file, artifactId);
    }

    private IArtifactKey findArtifact(IInstallableUnit iu) {
        for (IArtifactKey key : iu.getArtifacts()) {
            if (!"osgi.bundle".equals(key.getClassifier())) continue;
            return key;
        }
        return null;
    }

    public List<MavenDependency> getMavenDependencies() {
        ArrayList<MavenDependency> refs = new ArrayList<MavenDependency>(this.mavenDependencies);
        Collections.sort(refs, MavenDependency.COMPARATOR);
        return refs;
    }

    public List<MavenReference> getMavenExports() {
        ArrayList<MavenReference> result = new ArrayList<MavenReference>(this.mavenExports);
        Collections.sort(result, MavenReference.COMPARATOR);
        return result;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    private static class Developer {
        String id;
        String name;
        String email;
        String url;

        private Developer() {
        }
    }
}

