/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;


/**
 * The persistent class for the message_content database table.
 * 
 */
@Entity
@Table(name="EBAM_MESSAGE_CONTENT")
public class MessageContent implements Serializable {
	private static final long serialVersionUID = 1L;
	
    @TableGenerator(name="MCId", table="ID_GEN",
            pkColumnName="ID_NAME", valueColumnName="ID_VAL",
            pkColumnValue="MSG_CONTENT_ID", allocationSize=100)
	@Id
    @GeneratedValue(generator="MCId", strategy=GenerationType.TABLE)
	@Column(name="MSG_CONTENT_ID")
	private Double msgContentId;

	@Column(name="NAME")
	private String name;

	@Column(name="VALUE")
	private String value;
	
	@Column(name="FATHER_ID")
	private Double fatherId;
	
	@Column(name="DETAIL_LIST")
	private String detailList;
	
	@Column(name="DETAIL_XML")
	private String detailXml;


	@Column(name="\"LEVEL\"")
	private Integer level;
	
	@Column(name="\"ID_SERVICE_INSTANCE\"")
	private Double serviceInstanceId;	

	//bi-directional many-to-one association to DataAttribute
    @ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="ATTRIBUTE_ID")
	private DataAttribute dataAttribute;

	//bi-directional many-to-one association to Journal
    @ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="JOURNAL_ID",insertable=true, updatable=true)
	private Journal journal;

    public MessageContent() {
    }

	
	public Double getServiceInstanceId() {
		return serviceInstanceId;
	}

	public void setServiceInstanceId(Double serviceInstanceId) {
		this.serviceInstanceId = serviceInstanceId;
	}
	
	public double getMsgContentId() {
		return this.msgContentId;
	}

	public void setMsgContentId(double msgContentId) {
		this.msgContentId = msgContentId;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getValue() {
		return this.value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public DataAttribute getDataAttribute() {
		return this.dataAttribute;
	}

	public void setDataAttribute(DataAttribute dataAttribute) {
		this.dataAttribute = dataAttribute;
	}
	
	public Journal getJournal() {
		return this.journal;
	}

	public void setJournal(Journal journal) {
		this.journal = journal;
	}

	public Double getFatherId() {
		return fatherId;
	}

	public void setFatherId(Double fatherId) {
		this.fatherId = fatherId;
	}

	public String getDetailList() {
		return detailList;
	}

	public void setDetailList(String detailList) {
		this.detailList = detailList;
	}

	public String getDetailXml() {
		return detailXml;
	}

	public void setDetailXml(String detailXml) {
		this.detailXml = detailXml;
	}

	public Integer getLevel() {
		return level;
	}

	public void setLevel(Integer level) {
		this.level = level;
	}
	
}