/*******************************************************************************
 * Copyright (c) 2004, 2009 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.EdgeCursor;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.DrilledEdgeAxis;
import org.eclipse.birt.data.engine.olap.driver.IEdgeAxis;
import org.eclipse.birt.data.engine.olap.impl.query.DrillQueryHelper;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.BirtEdgeView;


public class MergedCubeCursor extends AbstractCursorSupport implements CubeCursor
{

	private CubeCursor baseCursor;
	private List<EdgeCursor> ordinateEdge = new ArrayList<EdgeCursor>( );

	public MergedCubeCursor( CubeCursor baseCursor, BirtCubeView originalView,
			BirtCubeView baseView, DrillQueryHelper drillQueryHelper )
			throws IOException, DataException
	{
		super( null, new DrilledAggregationAccessor( baseCursor,
				baseView,
				drillQueryHelper ) );
	    this.baseCursor = baseCursor;

		if ( baseView.getColumnEdgeView( ) != null )
		{
			List<IAggregationResultSet> drillOnColumnRs = new ArrayList<IAggregationResultSet>( );
			BirtEdgeView metaView = baseView.getColumnEdgeView( );
			for ( int i = 0; i < drillQueryHelper.getCubeViewOnColumnEdge( ).length; i++ )
			{
				drillOnColumnRs.add( drillQueryHelper.getCubeViewOnColumnEdge( )[i].getColumnEdgeView( )
						.getEdgeAxis( )
						.getRowDataAccessor( )
						.getAggregationResultSet( ) );
			}

			IEdgeAxis edgeAxis = new DrilledEdgeAxis( originalView.getColumnEdgeView( )
					.getEdgeAxis( )
					.getRowDataAccessor( )
					.getAggregationResultSet( ),
					drillOnColumnRs,
					metaView,
					null,
					originalView.getColumnEdgeView( )
							.getEdgeDefinition( )
							.getDrillFilter( ) );
			EdgeCursor columnEdgeCursor = new EdgeCursorImpl( metaView,
					false,
					edgeAxis,
					this );

			edgeAxis.populateEdgeInfo( false );
			ordinateEdge.add( columnEdgeCursor );
			originalView.getColumnEdgeView( ).setEdgeCursor( columnEdgeCursor );
			originalView.getColumnEdgeView( ).setEdgeAxis( edgeAxis );

		}
		// create row edge cursor
		if ( baseView.getRowEdgeView( ) != null )
		{
			List<IAggregationResultSet> drillOnRowRs = new ArrayList<IAggregationResultSet>( );
			BirtEdgeView metaView = baseView.getRowEdgeView( );
			for ( int i = 0; i < drillQueryHelper.getCubeViewOnRowEdge( ).length; i++ )
			{
				drillOnRowRs.add( drillQueryHelper.getCubeViewOnRowEdge( )[i].getRowEdgeView( )
						.getEdgeAxis( )
						.getRowDataAccessor( )
						.getAggregationResultSet( ) );
			}

			IEdgeAxis edgeAxis = new DrilledEdgeAxis( originalView.getRowEdgeView( )
					.getEdgeAxis( )
					.getRowDataAccessor( )
					.getAggregationResultSet( ),
					drillOnRowRs,
					metaView,
					null,
					originalView.getRowEdgeView( )
							.getEdgeDefinition( )
							.getDrillFilter( ) );
			EdgeCursor rowEdgeCursor = new EdgeCursorImpl( metaView,
					false,
					edgeAxis,
					this );

			edgeAxis.populateEdgeInfo( false );
			ordinateEdge.add( rowEdgeCursor );
			originalView.getRowEdgeView( ).setEdgeCursor( rowEdgeCursor );
			originalView.getRowEdgeView( ).setEdgeAxis( edgeAxis );

		}
	}
	
	public List getOrdinateEdge( ) throws OLAPException
	{
		return ordinateEdge;
	}

	public Collection getPageEdge( ) throws OLAPException
	{
		return baseCursor.getPageEdge( );
	}

	public void synchronizePages( ) throws OLAPException
	{
		baseCursor.synchronizePages( );
	}

}
