/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.remote.ProxyRemoteMessages;
import org.eclipse.jem.internal.proxy.remote.REMMasterServerThread;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;

public class REMRegistryController {
    private Map fActiveRegistries = new HashMap();
    private static final long CLEANUP_INTERVAL = 60000L;
    protected boolean inShutdown;
    private Job processQueueJob = new Job(ProxyRemoteMessages.CleanupJob_title){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor m) {
            REMProxyFactoryRegistry[] registries = null;
            REMRegistryController rEMRegistryController = REMRegistryController.this;
            synchronized (rEMRegistryController) {
                registries = REMRegistryController.this.fActiveRegistries.values().toArray(new REMProxyFactoryRegistry[REMRegistryController.this.fActiveRegistries.size()]);
            }
            int i = 0;
            while (i < registries.length) {
                try {
                    ((REMStandardBeanProxyFactory)registries[i].getBeanProxyFactory()).processQueue();
                }
                catch (RuntimeException runtimeException) {}
                ++i;
            }
            1 var3_5 = this;
            synchronized (var3_5) {
                if (!m.isCanceled()) {
                    this.schedule(60000L);
                }
            }
            return Status.OK_STATUS;
        }
    };
    protected REMMasterServerThread masterThread;

    public REMRegistryController() {
        ProxyPlugin.getPlugin().addProxyShutdownListener(new ProxyPlugin.IProxyPluginShutdownListener(){

            public void shutdown() {
                REMRegistryController.this.shutdown();
            }
        });
        this.masterThread = new REMMasterServerThread(this);
        this.masterThread.start();
        this.processQueueJob.setSystem(true);
        this.processQueueJob.setPriority(20);
        this.processQueueJob.schedule(60000L);
    }

    public boolean inShutDown() {
        return this.inShutdown;
    }

    synchronized Integer registerRegistry(REMProxyFactoryRegistry registry) {
        REMProxyFactoryRegistry existing;
        Integer hashcode = new Integer(registry.hashCode());
        while ((existing = (REMProxyFactoryRegistry)this.fActiveRegistries.get(hashcode)) != null) {
            if (existing != registry) {
                hashcode = new Integer(hashcode + 1);
                continue;
            }
            return hashcode;
        }
        this.fActiveRegistries.put(hashcode, registry);
        return hashcode;
    }

    synchronized void deregisterRegistry(Integer key) {
        this.fActiveRegistries.remove(key);
    }

    synchronized REMProxyFactoryRegistry getRegistry(Integer key) {
        return (REMProxyFactoryRegistry)this.fActiveRegistries.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Job job = this.processQueueJob;
        synchronized (job) {
            this.processQueueJob.cancel();
        }
        REMProxyFactoryRegistry[] registries = null;
        REMRegistryController rEMRegistryController = this;
        synchronized (rEMRegistryController) {
            registries = this.fActiveRegistries.values().toArray(new REMProxyFactoryRegistry[this.fActiveRegistries.size()]);
        }
        this.inShutdown = true;
        int i = 0;
        while (i < registries.length) {
            registries[i].terminateRegistry();
            ++i;
        }
        if (this.masterThread != null) {
            try {
                this.masterThread.requestShutdown();
                this.masterThread.join(20000L);
                this.masterThread = null;
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.processQueueJob.join();
        }
        catch (InterruptedException interruptedException) {}
        REMProxyFactoryRegistry.cancelAllTerminateJobs();
    }

    public int getMasterSocketPort() {
        return this.masterThread != null ? this.masterThread.getMasterSocket().getLocalPort() : -1;
    }
}

