/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.contactwidgets.detailtabs;

import org.eclipse.ebam.designers.exception.DatabaseConnectionException;
import org.eclipse.ebam.designers.wizards.pages.contactwidgets.ContactsDetailComposite;
import org.eclipse.ebam.designers.wizards.pages.contactwidgets.ContactsListComposite;
import org.eclipse.ebam.model.entities.SbiAlarmContact;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactDetailTabItem
extends CTabItem {
    private ContactsDetailComposite contactsDetailComposite;
    private Text nameText;
    private Text eMailText;
    private Text cellText;
    public static final int tabIndex = 0;
    private static Logger logger = LoggerFactory.getLogger(ContactDetailTabItem.class);

    public ContactDetailTabItem(CTabFolder parent, int style, ContactsDetailComposite alComposite) {
        super(parent, style);
        this.contactsDetailComposite = alComposite;
    }

    public void drawComp(CTabFolder folder) {
        logger.debug("IN");
        Composite detailComposite = new Composite((Composite)folder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        detailComposite.setLayout((Layout)gridLayout);
        Label nameLabel = new Label(detailComposite, 0);
        nameLabel.setText("Name: ");
        GridData gLabel = new GridData(32);
        nameLabel.setLayoutData((Object)gLabel);
        this.nameText = new Text(detailComposite, 2048);
        GridData gNameText = new GridData(768);
        gNameText.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gNameText);
        Label emailLabel = new Label(detailComposite, 0);
        emailLabel.setText("E-Mail: ");
        GridData gEMail = new GridData(32);
        emailLabel.setLayoutData((Object)gEMail);
        this.eMailText = new Text(detailComposite, 2048);
        GridData gEMailText = new GridData(768);
        gEMailText.horizontalSpan = 2;
        this.eMailText.setLayoutData((Object)gEMailText);
        Label cellLabel = new Label(detailComposite, 0);
        cellLabel.setText("Cell: ");
        GridData gCell = new GridData(32);
        cellLabel.setLayoutData((Object)gCell);
        this.cellText = new Text(detailComposite, 2048);
        GridData gCellText = new GridData(768);
        gCellText.horizontalSpan = 2;
        this.cellText.setLayoutData((Object)gCellText);
        this.setControl((Control)detailComposite);
        logger.debug("OUT");
    }

    public void fillEmptyValues() {
        this.nameText.setText("");
        this.eMailText.setText("");
        this.cellText.setText("");
    }

    public void fillContactValues(SbiAlarmContact sbiContact) throws DatabaseConnectionException {
        String name = "";
        if (sbiContact.getName() != null) {
            name = sbiContact.getName();
        }
        this.nameText.setText(name);
        String eMail = "";
        if (sbiContact.getEmail() != null) {
            eMail = sbiContact.getEmail();
        }
        this.eMailText.setText(eMail);
        String cell = "";
        if (sbiContact.getMobile() != null) {
            cell = sbiContact.getMobile();
        }
        this.cellText.setText(cell);
        logger.debug("OUT");
    }

    public void recoverSavingInformations(SbiAlarmContact sbiContact) throws DatabaseConnectionException {
        logger.debug("IN");
        String name = this.nameText.getText();
        String eMail = this.eMailText.getText();
        String cell = this.cellText.getText();
        ContactsListComposite contactListComposite = this.getContactsDetailComposite().getContactWizardPage().getListComposite();
        Table contactsTable = contactListComposite.getContactsTable();
        contactsTable.getSelectionIndex();
        sbiContact.setName(name);
        sbiContact.setEmail(eMail);
        sbiContact.setMobile(cell);
    }

    public ContactsDetailComposite getContactsDetailComposite() {
        return this.contactsDetailComposite;
    }

    public void setContactsDetailComposite(ContactsDetailComposite contactsDetailComposite) {
        this.contactsDetailComposite = contactsDetailComposite;
    }

    public Text getNameText() {
        return this.nameText;
    }

    public void setNameText(Text nameText) {
        this.nameText = nameText;
    }
}

