/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassesGenerator {
    public static String LAUNCH_CONFIG_NAME = "JAXB Run Config";
    public static String JAXB_GENERIC_GEN_CLASS = "com.sun.tools.xjc.XJCFacade";
    public static String JAXB_ECLIPSELINK_GEN_CLASS = "org.eclipse.persistence.jaxb.xjc.MOXyXJC";
    private IVMInstall jre;
    private ILaunchConfigurationWorkingCopy launchConfig;
    private ILaunch launch;
    private final IJavaProject javaProject;
    private final String xmlSchemaName;
    private final String outputDir;
    private final String targetPackage;
    private final String catalog;
    private final String[] bindingsFileNames;
    private final String mainType;
    private final boolean isDebug = false;

    public static void generate(IJavaProject javaProject, String xmlSchemaName, String outputDir, String targetPackage, String catalog, boolean useMoxyGenerator, String[] bindingsFileNames, IProgressMonitor monitor) {
        if (javaProject == null) {
            throw new NullPointerException();
        }
        new ClassesGenerator(javaProject, xmlSchemaName, outputDir, targetPackage, catalog, useMoxyGenerator, bindingsFileNames, monitor).generate();
    }

    protected ClassesGenerator(IJavaProject javaProject, String xmlSchemaName, String outputDir, String targetPackage, String catalog, boolean useMoxyGenerator, String[] bindingsFileNames, IProgressMonitor monitor) {
        this.javaProject = javaProject;
        this.xmlSchemaName = xmlSchemaName;
        this.outputDir = outputDir;
        this.targetPackage = targetPackage;
        this.catalog = catalog;
        this.bindingsFileNames = bindingsFileNames;
        this.mainType = useMoxyGenerator ? JAXB_ECLIPSELINK_GEN_CLASS : JAXB_GENERIC_GEN_CLASS;
        this.initialize();
    }

    protected void initialize() {
        try {
            this.jre = this.getProjectJRE();
            if (this.jre == null) {
                String message = "Could not identify the VM.";
                throw new RuntimeException(message);
            }
            this.launchConfig = this.buildLaunchConfiguration();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected void generate() {
        String projectLocation = this.javaProject.getProject().getLocation().toString();
        this.initializeLaunchConfiguration(projectLocation);
        this.addLaunchListener();
        this.launch = this.saveAndLaunchConfig();
    }

    private void initializeLaunchConfiguration(String projectLocation) {
        this.specifyJRE(this.jre.getName(), this.jre.getVMInstallType().getId());
        this.specifyProject(this.javaProject.getProject().getName());
        this.specifyMainType(this.mainType);
        this.specifyProgramArguments(this.xmlSchemaName, this.outputDir, this.targetPackage, this.catalog, this.bindingsFileNames);
        this.specifyWorkingDir(projectLocation);
        this.specifyClasspathProperties(this.javaProject);
    }

    protected void postGenerate() {
        try {
            this.removeLaunchConfiguration(LAUNCH_CONFIG_NAME);
            this.javaProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private void specifyClasspathProperties(IJavaProject project) {
        ArrayList<String> classpath = new ArrayList<String>();
        try {
            classpath.add(this.getDefaultProjectClasspathEntry(project).getMemento());
            classpath.add(this.getSystemLibraryClasspathEntry().getMemento());
            for (IRuntimeClasspathEntry containerClasspathEntry : this.getContainersClasspathEntries()) {
                classpath.add(containerClasspathEntry.getMemento());
            }
        }
        catch (CoreException e) {
            throw new RuntimeException("An error occurs generating a memento", e);
        }
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
    }

    private void specifyJRE(String jreName, String vmId) {
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, jreName);
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, vmId);
    }

    private void specifyProject(String projectName) {
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
    }

    private void specifyMainType(String mainType) {
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainType);
    }

    private void specifyProgramArguments(String xmlSchemaName, String outputDir, String targetPackage, String catalog, String[] bindingsFileNames) {
        StringBuffer programArguments = new StringBuffer();
        programArguments.append("-d ");
        programArguments.append(outputDir);
        if (!StringTools.stringIsEmpty((String)targetPackage)) {
            programArguments.append(" -p ");
            programArguments.append(targetPackage);
        }
        if (!StringTools.stringIsEmpty((String)catalog)) {
            programArguments.append(" -catalog ");
            programArguments.append(catalog);
        }
        programArguments.append(' ');
        programArguments.append(xmlSchemaName);
        if (bindingsFileNames.length > 0) {
            String[] stringArray = bindingsFileNames;
            int n = bindingsFileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String bindingsFileName = stringArray[n2];
                programArguments.append(" -b ");
                programArguments.append(bindingsFileName);
                ++n2;
            }
        }
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArguments.toString());
    }

    private void specifyWorkingDir(String projectLocation) {
        File workingDir = new Path(projectLocation).toFile();
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, workingDir.getAbsolutePath());
    }

    private ILaunchConfigurationWorkingCopy buildLaunchConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy launchConfig = null;
        this.removeLaunchConfiguration(LAUNCH_CONFIG_NAME);
        ILaunchConfigurationType type = this.getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        launchConfig = type.newInstance(null, LAUNCH_CONFIG_NAME);
        return launchConfig;
    }

    private void removeLaunchConfiguration(String launchConfigurationName) throws CoreException {
        ILaunchManager manager = this.getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfiguration[] configurations = manager.getLaunchConfigurations(type);
        int i = 0;
        while (i < configurations.length) {
            ILaunchConfiguration configuration = configurations[i];
            if (configuration.getName().equals(launchConfigurationName)) {
                configuration.delete();
                break;
            }
            ++i;
        }
    }

    private ILaunch saveAndLaunchConfig() {
        ILaunchConfiguration configuration = null;
        ILaunch result = null;
        try {
            configuration = this.launchConfig.doSave();
        }
        catch (CoreException saveException) {
            throw new RuntimeException("Could not save LaunchConfig", saveException);
        }
        try {
            result = configuration.launch("run", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException lauchException) {
            throw new RuntimeException("An error occured during launch", lauchException);
        }
        return result;
    }

    private void addLaunchListener() {
        this.getLaunchManager().addLaunchListener((ILaunchesListener)this.buildLaunchListener());
    }

    private ILaunchesListener2 buildLaunchListener() {
        return new ILaunchesListener2(){

            public void launchesTerminated(ILaunch[] launches) {
                int i = 0;
                while (i < launches.length) {
                    ILaunch launch = launches[i];
                    if (launch.equals(ClassesGenerator.this.getLaunch())) {
                        ClassesGenerator.this.postGenerate();
                        return;
                    }
                    ++i;
                }
            }

            public void launchesAdded(ILaunch[] launches) {
            }

            public void launchesChanged(ILaunch[] launches) {
            }

            public void launchesRemoved(ILaunch[] launches) {
            }
        };
    }

    private IRuntimeClasspathEntry getSystemLibraryClasspathEntry() throws CoreException {
        Path systemLibsPath = new Path(JavaRuntime.JRE_CONTAINER);
        return JavaRuntime.newRuntimeContainerClasspathEntry((IPath)systemLibsPath, (int)1);
    }

    private IRuntimeClasspathEntry getDefaultProjectClasspathEntry(IJavaProject project) {
        IRuntimeClasspathEntry projectEntry = JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)project);
        projectEntry.setClasspathProperty(3);
        return projectEntry;
    }

    private List<IRuntimeClasspathEntry> getContainersClasspathEntries() throws CoreException {
        ArrayList<IRuntimeClasspathEntry> classpathEntries = new ArrayList<IRuntimeClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = this.javaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathContainer container;
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (classpathEntry.getEntryKind() == 5 && (container = JavaCore.getClasspathContainer((IPath)classpathEntry.getPath(), (IJavaProject)this.javaProject)) != null && container.getKind() == 2) {
                classpathEntries.add(JavaRuntime.newRuntimeContainerClasspathEntry((IPath)container.getPath(), (int)2, (IJavaProject)this.javaProject));
            }
            ++n2;
        }
        return classpathEntries;
    }

    private IVMInstall getProjectJRE() throws CoreException {
        return JavaRuntime.getVMInstall((IJavaProject)this.javaProject);
    }

    protected ILaunch getLaunch() {
        return this.launch;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

