/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WorkingSetGroup;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.frameworks.internal.ui.NewProjectGroup;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetsChangedEvent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.core.util.AbstractFilter;
import org.eclipse.wst.common.project.facet.core.util.FilterEvent;
import org.eclipse.wst.common.project.facet.core.util.IFilter;
import org.eclipse.wst.common.project.facet.ui.ModifyFacetedProjectWizard;
import org.eclipse.wst.common.project.facet.ui.PresetSelectionPanel;
import org.eclipse.wst.project.facet.ProductManager;
import org.eclipse.wst.server.ui.ServerUIUtil;
import org.eclipse.wst.web.internal.ResourceHandler;
import org.eclipse.wst.web.internal.facet.RuntimePresetMappingRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataModelFacetCreationWizardPage
extends DataModelWizardPage
implements IFacetProjectCreationDataModelProperties {
    private static final String NULL_RUNTIME = "NULL_RUNTIME";
    private static final String MRU_RUNTIME_STORE = "MRU_RUNTIME_STORE";
    protected static final String RESOURCE_WORKING_SET = "org.eclipse.ui.resourceWorkingSetPage";
    protected static final String JAVA_WORKING_SET = "org.eclipse.jdt.ui.JavaWorkingSetPage";
    protected IProjectFacet primaryProjectFacet = null;
    protected Combo primaryVersionCombo = null;
    protected WorkingSetGroup workingSetGroup;
    private static final String[] VALIDATION_PROPERTIES = new String[]{"IProjectCreationPropertiesNew.PROJECT_NAME", "IProjectCreationPropertiesNew.PROJECT_LOCATION", "IFacetProjectCreationDataModelProperties.FACET_RUNTIME", "IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY"};
    protected Combo serverTargetCombo;
    protected NewProjectGroup projectNameGroup;
    private final IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
    private final IFacetedProjectListener fpjwcListener = new IFacetedProjectListener(){

        public void handleEvent(IFacetedProjectEvent event) {
            Runnable runnable = new Runnable(){

                public void run() {
                    DataModelFacetCreationWizardPage.this.validatePage();
                }
            };
            DataModelFacetCreationWizardPage.this.getContainer().getShell().getDisplay().asyncExec(runnable);
        }
    };

    protected Set<IProjectFacetVersion> getFacetConfiguration(IProjectFacetVersion primaryFacetVersion) {
        HashSet<IProjectFacetVersion> config = new HashSet<IProjectFacetVersion>();
        for (IProjectFacet fixedFacet : this.fpjwc.getFixedProjectFacets()) {
            if (fixedFacet == primaryFacetVersion.getProjectFacet()) {
                config.add(primaryFacetVersion);
                continue;
            }
            config.add(this.fpjwc.getHighestAvailableVersion(fixedFacet));
        }
        return config;
    }

    protected static GridData gdhfill() {
        return new GridData(768);
    }

    protected static GridData hspan(GridData gd, int span) {
        gd.horizontalSpan = span;
        return gd;
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite top = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)top, this.getInfopopID());
        top.setLayout((Layout)new GridLayout());
        top.setLayoutData((Object)new GridData(1808));
        this.createProjectGroup(top);
        this.createServerTargetComposite(top);
        this.createPrimaryFacetComposite(top);
        this.createPresetPanel(top);
        return top;
    }

    private String getPrimaryFacetCompositeLabel() {
        StringBuilder buf = new StringBuilder();
        boolean firstWord = true;
        String[] stringArray = this.primaryProjectFacet.getLabel().split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (firstWord) {
                buf.append(word);
                firstWord = false;
            } else {
                buf.append(' ');
                if (word.length() == 1 || !Character.isUpperCase(word.charAt(1))) {
                    buf.append(Character.toLowerCase(word.charAt(0)));
                    buf.append(word.substring(1));
                } else {
                    buf.append(word);
                }
            }
            ++n2;
        }
        buf.append(' ');
        buf.append(Messages.FACET_VERSION);
        return buf.toString();
    }

    protected void createPrimaryFacetComposite(Composite top) {
        this.primaryProjectFacet = ProjectFacetsManager.getProjectFacet((String)this.getModuleTypeID());
        if (this.primaryProjectFacet.getVersions().size() <= 1) {
            return;
        }
        Group group = new Group(top, 0);
        group.setLayoutData((Object)DataModelFacetCreationWizardPage.gdhfill());
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(this.getPrimaryFacetCompositeLabel());
        this.primaryVersionCombo = new Combo((Composite)group, 2056);
        this.primaryVersionCombo.setLayoutData((Object)DataModelFacetCreationWizardPage.gdhfill());
        this.updatePrimaryVersions();
        this.primaryVersionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataModelFacetCreationWizardPage.this.handlePrimaryFacetVersionSelectedEvent();
            }
        });
        this.fpjwc.addListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                if (event.getType() == IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED) {
                    IProjectFacetsChangedEvent actionEvent = (IProjectFacetsChangedEvent)event;
                    Set changedVersions = actionEvent.getFacetsWithChangedVersions();
                    boolean foundComboVersion = false;
                    Iterator iterator = changedVersions.iterator();
                    while (iterator.hasNext() && !foundComboVersion) {
                        IProjectFacetVersion next = (IProjectFacetVersion)iterator.next();
                        if (!next.getProjectFacet().equals(DataModelFacetCreationWizardPage.this.primaryProjectFacet)) continue;
                        foundComboVersion = true;
                        final IProjectFacetVersion selectedVersion = next;
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                String selectedText = (this).DataModelFacetCreationWizardPage.this.primaryVersionCombo.getItem((this).DataModelFacetCreationWizardPage.this.primaryVersionCombo.getSelectionIndex());
                                if (!selectedText.equals(selectedVersion.getVersionString())) {
                                    String[] items = (this).DataModelFacetCreationWizardPage.this.primaryVersionCombo.getItems();
                                    int selectedVersionIndex = -1;
                                    int i = 0;
                                    while (i < items.length && selectedVersionIndex == -1) {
                                        if (items[i].equals(selectedVersion.getVersionString())) {
                                            selectedVersionIndex = i;
                                            (this).DataModelFacetCreationWizardPage.this.primaryVersionCombo.select(selectedVersionIndex);
                                        }
                                        ++i;
                                    }
                                }
                            }
                        });
                    }
                } else if (event.getType() == IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            DataModelFacetCreationWizardPage.this.updatePrimaryVersions();
                        }
                    });
                }
            }
        }, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED, IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED});
    }

    protected IProjectFacet getPrimaryFacet() {
        return this.primaryProjectFacet;
    }

    public IProjectFacetVersion getPrimaryFacetVersion() {
        IProjectFacetVersion fv = null;
        if (this.primaryProjectFacet.getVersions().size() > 1) {
            int selectedIndex = this.primaryVersionCombo.getSelectionIndex();
            if (selectedIndex != -1) {
                String fvstr = this.primaryVersionCombo.getItem(selectedIndex);
                fv = this.primaryProjectFacet.getVersion(fvstr);
            }
        } else {
            fv = this.primaryProjectFacet.getDefaultVersion();
        }
        return fv;
    }

    protected void handlePrimaryFacetVersionSelectedEvent() {
        IProjectFacetVersion fv = this.getPrimaryFacetVersion();
        if (fv != null) {
            Set<IProjectFacetVersion> facets;
            String presetID = null;
            IRuntime runtime = (IRuntime)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
            if (runtime != null && runtime.getRuntimeComponents().size() > 0) {
                IRuntimeComponent runtimeComponent = (IRuntimeComponent)runtime.getRuntimeComponents().get(0);
                String facetRuntimeTypeID = runtimeComponent.getRuntimeComponentType().getId();
                String facetRuntimeVersion = runtimeComponent.getRuntimeComponentVersion().getVersionString();
                String facetID = fv.getProjectFacet().getId();
                String facetVersion = fv.getVersionString();
                presetID = RuntimePresetMappingRegistry.INSTANCE.getPresetID(facetRuntimeTypeID, facetRuntimeVersion, facetID, facetVersion);
            }
            if (presetID == null) {
                facets = this.getFacetConfiguration(fv);
                this.fpjwc.setProjectFacets(facets);
            } else {
                facets = this.getFacetConfiguration(fv);
                this.fpjwc.setProjectFacets(facets);
                this.fpjwc.setSelectedPreset(presetID);
            }
        }
    }

    protected void updatePrimaryVersions() {
        IProjectFacetVersion selectedVersion = this.fpjwc.getProjectFacetVersion(this.primaryProjectFacet);
        SortedSet initialVersions = this.fpjwc.getAvailableVersions(this.primaryProjectFacet);
        String[] items = new String[initialVersions.size()];
        int i = 0;
        int selectedVersionIndex = -1;
        Iterator iterator = initialVersions.iterator();
        while (iterator.hasNext()) {
            items[i] = ((IProjectFacetVersion)iterator.next()).getVersionString();
            if (selectedVersionIndex == -1 && items[i].equals(selectedVersion.getVersionString())) {
                selectedVersionIndex = i;
            }
            ++i;
        }
        this.primaryVersionCombo.clearSelection();
        this.primaryVersionCombo.setItems(items);
        this.primaryVersionCombo.select(selectedVersionIndex);
    }

    protected void createPresetPanel(Composite top) {
        IFacetedProjectWorkingCopy fpjwc = ((ModifyFacetedProjectWizard)this.getWizard()).getFacetedProjectWorkingCopy();
        AbstractFilter<IPreset> filter = new AbstractFilter<IPreset>(fpjwc){
            {
                iFacetedProjectWorkingCopy.addListener(new IFacetedProjectListener(){

                    public void handleEvent(IFacetedProjectEvent event) {
                        this.handleProjectFacetsChangedEvent((IProjectFacetsChangedEvent)event);
                    }
                }, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED});
            }

            public boolean check(IPreset preset) {
                IProjectFacetVersion primaryFacetVersion = DataModelFacetCreationWizardPage.this.getPrimaryFacetVersion();
                return preset.getProjectFacets().contains(primaryFacetVersion);
            }

            private void handleProjectFacetsChangedEvent(IProjectFacetsChangedEvent event) {
                for (IProjectFacetVersion fv : event.getFacetsWithChangedVersions()) {
                    if (fv.getProjectFacet() != DataModelFacetCreationWizardPage.this.getPrimaryFacet()) continue;
                    FilterEvent filterEvent = new FilterEvent((IFilter)this, IFilter.IFilterEvent.Type.FILTER_CHANGED);
                    this.notifyListeners((IFilter.IFilterEvent)filterEvent);
                }
            }
        };
        PresetSelectionPanel ppanel = new PresetSelectionPanel(top, fpjwc, (IFilter)filter);
        ppanel.setLayoutData((Object)DataModelFacetCreationWizardPage.gdhfill());
    }

    public static boolean launchNewRuntimeWizard(Shell shell, IDataModel model) {
        return DataModelFacetCreationWizardPage.launchNewRuntimeWizard(shell, model, null);
    }

    public static boolean launchNewRuntimeWizard(Shell shell, final IDataModel model, String serverTypeID) {
        if (model == null) {
            return false;
        }
        final DataModelPropertyDescriptor[] preAdditionDescriptors = model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        final boolean[] keepWaiting = new boolean[]{true};
        IDataModelListener listener = new IDataModelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void propertyChanged(DataModelEvent event) {
                if (!event.getPropertyName().equals("IFacetProjectCreationDataModelProperties.FACET_RUNTIME") || event.getFlag() != 4) return;
                boolean[] blArray = keepWaiting;
                synchronized (keepWaiting) {
                    keepWaiting[0] = false;
                    keepWaiting.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    model.removeListener((IDataModelListener)this);
                    return;
                }
            }
        };
        model.addListener(listener);
        boolean isOK = ServerUIUtil.showNewRuntimeWizard((Shell)shell, (String)serverTypeID, null);
        if (isOK) {
            Thread newRuntimeSelectionThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    RuntimeManager.getRuntimes();
                    boolean[] blArray = keepWaiting;
                    synchronized (keepWaiting) {
                        while (true) {
                            if (!keepWaiting[0]) {
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                break;
                            }
                            try {
                                keepWaiting.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        DataModelPropertyDescriptor[] postAdditionDescriptors = model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                        Object[] preAddition = new Object[preAdditionDescriptors.length];
                        int i = 0;
                        while (i < preAddition.length) {
                            preAddition[i] = preAdditionDescriptors[i].getPropertyValue();
                            ++i;
                        }
                        Object[] postAddition = new Object[postAdditionDescriptors.length];
                        int i2 = 0;
                        while (i2 < postAddition.length) {
                            postAddition[i2] = postAdditionDescriptors[i2].getPropertyValue();
                            ++i2;
                        }
                        Object newAddition = DataModelFacetCreationWizardPage.getNewObject(preAddition, postAddition);
                        if (newAddition != null) {
                            model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", newAddition);
                        }
                        return;
                    }
                }
            };
            newRuntimeSelectionThread.start();
            return true;
        }
        model.removeListener(listener);
        return false;
    }

    public boolean internalLaunchNewRuntimeWizard(Shell shell, IDataModel model) {
        return DataModelFacetCreationWizardPage.launchNewRuntimeWizard(shell, model, this.getModuleTypeID());
    }

    protected String getModuleTypeID() {
        return null;
    }

    public DataModelFacetCreationWizardPage(IDataModel dataModel, String pageName) {
        super(dataModel, pageName);
        this.fpjwc.addListener(this.fpjwcListener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.VALIDATION_PROBLEMS_CHANGED});
    }

    protected void createServerTargetComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(ResourceHandler.TargetRuntime);
        group.setLayoutData((Object)DataModelFacetCreationWizardPage.gdhfill());
        group.setLayout((Layout)new GridLayout(2, false));
        this.serverTargetCombo = new Combo((Composite)group, 2056);
        this.serverTargetCombo.setLayoutData((Object)DataModelFacetCreationWizardPage.gdhfill());
        Button newServerTargetButton = new Button((Composite)group, 0);
        newServerTargetButton.setText(Resources.newRuntimeButton);
        GridDataFactory.defaultsFor((Control)newServerTargetButton).applyTo((Control)newServerTargetButton);
        newServerTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataModelFacetCreationWizardPage.this.internalLaunchNewRuntimeWizard(DataModelFacetCreationWizardPage.this.getShell(), DataModelFacetCreationWizardPage.this.model);
            }
        });
        Control[] deps = new Control[]{newServerTargetButton};
        this.synchHelper.synchCombo(this.serverTargetCombo, "IFacetProjectCreationDataModelProperties.FACET_RUNTIME", deps);
        if (this.serverTargetCombo.getSelectionIndex() == -1 && this.serverTargetCombo.getVisibleItemCount() != 0) {
            this.serverTargetCombo.select(0);
        }
    }

    protected void createProjectGroup(Composite parent) {
        IDataModel nestedProjectDM = this.model.getNestedModel("IFacetProjectCreationDataModelProperties.NESTED_PROJECT_DM");
        nestedProjectDM.addListener((IDataModelListener)this);
        this.projectNameGroup = new NewProjectGroup(parent, nestedProjectDM);
    }

    protected String[] getValidationPropertyNames() {
        return VALIDATION_PROPERTIES;
    }

    public void dispose() {
        super.dispose();
        if (this.projectNameGroup != null) {
            this.projectNameGroup.dispose();
        }
        this.fpjwc.removeListener(this.fpjwcListener);
    }

    public void storeDefaultSettings() {
        IDialogSettings settings = this.getDialogSettings();
        DataModelFacetCreationWizardPage.saveRuntimeSettings(settings, this.model);
    }

    public void restoreDefaultSettings() {
        IDialogSettings settings = this.getDialogSettings();
        DataModelFacetCreationWizardPage.restoreRuntimeSettings(settings, this.model);
    }

    public static void saveRuntimeSettings(IDialogSettings settings, IDataModel model) {
        if (settings != null) {
            IRuntime runtime;
            String runtimeName;
            String[] mruRuntimeArray = settings.getArray(MRU_RUNTIME_STORE);
            ArrayList<String> mruRuntimes = new ArrayList<String>();
            if (mruRuntimeArray != null) {
                mruRuntimes.addAll(Arrays.asList(mruRuntimeArray));
            }
            String string = runtimeName = (runtime = (IRuntime)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) == null ? NULL_RUNTIME : runtime.getName();
            if (mruRuntimes.contains(runtimeName)) {
                mruRuntimes.remove(runtimeName);
            }
            mruRuntimes.add(0, runtimeName);
            while (mruRuntimes.size() > 5) {
                mruRuntimes.remove(5);
            }
            mruRuntimeArray = new String[mruRuntimes.size()];
            int i = 0;
            while (i < mruRuntimeArray.length) {
                mruRuntimeArray[i] = (String)mruRuntimes.get(i);
                ++i;
            }
            settings.put(MRU_RUNTIME_STORE, mruRuntimeArray);
        }
    }

    public static void restoreRuntimeSettings(IDialogSettings settings, IDataModel model) {
        if (settings != null && !model.isPropertySet("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) {
            boolean runtimeSet = false;
            String[] mruRuntimeArray = settings.getArray(MRU_RUNTIME_STORE);
            DataModelPropertyDescriptor[] descriptors = model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
            ArrayList<String> mruRuntimes = new ArrayList<String>();
            if (mruRuntimeArray == null) {
                List defRuntimes = ProductManager.getDefaultRuntimes();
                Iterator iter = defRuntimes.iterator();
                while (iter.hasNext()) {
                    mruRuntimes.add(((IRuntime)iter.next()).getName());
                }
            } else {
                mruRuntimes.addAll(Arrays.asList(mruRuntimeArray));
            }
            if (!mruRuntimes.isEmpty()) {
                int i = 0;
                while (i < mruRuntimes.size() && !runtimeSet) {
                    int j = 0;
                    while (j < descriptors.length - 1 && !runtimeSet) {
                        if (mruRuntimes.get(i).equals(((IRuntime)descriptors[j].getPropertyValue()).getName())) {
                            model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", descriptors[j].getPropertyValue());
                            runtimeSet = true;
                        }
                        ++j;
                    }
                    if (!runtimeSet && mruRuntimes.get(i).equals(NULL_RUNTIME)) {
                        model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", descriptors[descriptors.length - 1].getPropertyValue());
                        runtimeSet = true;
                    }
                    ++i;
                }
            }
            if (!runtimeSet && descriptors.length > 0) {
                model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", descriptors[0].getPropertyValue());
            }
        }
    }

    private static Object getNewObject(Object[] oldObjects, Object[] newObjects) {
        if (oldObjects != null && newObjects != null && oldObjects.length < newObjects.length) {
            int i = 0;
            while (i < newObjects.length) {
                boolean found = false;
                Object object = newObjects[i];
                int j = 0;
                while (j < oldObjects.length) {
                    if (oldObjects[j] == object) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    return object;
                }
                ++i;
            }
        }
        if (oldObjects == null && newObjects != null && newObjects.length == 1) {
            return newObjects[0];
        }
        return null;
    }

    protected WorkingSetGroup createWorkingSetGroup(Composite composite, IStructuredSelection selection, String[] supportedWorkingSetTypes) {
        if (this.workingSetGroup != null) {
            return this.workingSetGroup;
        }
        this.workingSetGroup = new WorkingSetGroup(composite, selection, supportedWorkingSetTypes);
        return this.workingSetGroup;
    }

    protected WorkingSetGroup createWorkingSetGroupPanel(Composite composite, String[] workingSetTypes) {
        IStructuredSelection structuredSelection = null;
        ISelection currentSelection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)currentSelection;
        }
        WorkingSetGroup group = this.createWorkingSetGroup(composite, structuredSelection, workingSetTypes);
        return group;
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        return this.workingSetGroup == null ? new IWorkingSet[]{} : this.workingSetGroup.getSelectedWorkingSets();
    }

    public static class Messages
    extends NLS {
        private static final String BUNDLE_NAME = "org.eclipse.wst.web.ui.internal.wizards.facetcreationpagemessages";
        public static String FACET_VERSION;

        static {
            NLS.initializeMessages((String)BUNDLE_NAME, Messages.class);
        }

        private Messages() {
        }
    }

    private static final class Resources
    extends NLS {
        public static String newRuntimeButton;

        static {
            Resources.initializeMessages((String)DataModelFacetCreationWizardPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

