/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.aggregate.IAggregateFunction;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.GroupingUnitType;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.DataPackage;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.impl.DataFactoryImpl;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesGroupingImpl;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ColumnBindingInfo;
import org.eclipse.birt.chart.ui.swt.DataDefinitionTextManager;
import org.eclipse.birt.chart.ui.swt.DataTextDropListener;
import org.eclipse.birt.chart.ui.swt.DefaultSelectDataComponent;
import org.eclipse.birt.chart.ui.swt.IQueryExpressionManager;
import org.eclipse.birt.chart.ui.swt.SimpleTextTransfer;
import org.eclipse.birt.chart.ui.swt.composites.BaseGroupSortingDialog;
import org.eclipse.birt.chart.ui.swt.composites.GroupSortingDialog;
import org.eclipse.birt.chart.ui.swt.fieldassist.AssistField;
import org.eclipse.birt.chart.ui.swt.fieldassist.CComboAssistField;
import org.eclipse.birt.chart.ui.swt.fieldassist.FieldAssistHelper;
import org.eclipse.birt.chart.ui.swt.fieldassist.TextAssistField;
import org.eclipse.birt.chart.ui.swt.interfaces.IAssistField;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.IExpressionButton;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.ui.swt.type.GanttChart;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.AggregateEditorComposite;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class BaseDataDefinitionComponent
extends DefaultSelectDataComponent
implements SelectionListener,
IQueryExpressionManager {
    protected Composite cmpTop;
    private CCombo cmbDefinition;
    protected Text txtDefinition = null;
    private IExpressionButton btnBuilder = null;
    private Button btnGroup = null;
    protected Query query = null;
    protected SeriesDefinition seriesdefinition = null;
    protected ChartWizardContext context = null;
    private String description = "";
    private String tooltipWhenBlank = Messages.getString("BaseDataDefinitionComponent.Tooltip.InputValueExpression");
    private final String queryType;
    private int style = 0;
    private AggregateEditorComposite fAggEditorComposite;
    public static final int BUTTON_NONE = 0;
    public static final int BUTTON_GROUP = 1;
    public static final int BUTTON_AGGREGATION = 2;
    protected final ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
    private final SharedBindingHelper sbHelper = new SharedBindingHelper();

    public BaseDataDefinitionComponent(String queryType, SeriesDefinition seriesdefinition, Query query, ChartWizardContext context, String sTitle) {
        this(0, queryType, seriesdefinition, query, context, sTitle);
    }

    public BaseDataDefinitionComponent(int style, String queryType, SeriesDefinition seriesdefinition, Query query, ChartWizardContext context, String sTitle) {
        this.query = query;
        this.queryType = queryType;
        this.seriesdefinition = seriesdefinition;
        this.context = context;
        this.style = style;
    }

    public Composite createArea(Composite parent) {
        boolean isCubeNoMultiDimensions;
        GridLayout gl;
        GridData gd;
        Composite control;
        int numColumns = 2;
        if (this.description != null && this.description.length() > 0) {
            ++numColumns;
        }
        if ((this.style & 2) == 2) {
            ++numColumns;
        }
        if ((this.style & 1) == 1) {
            ++numColumns;
        }
        this.cmpTop = new Composite(parent, 0);
        GridLayout glContent = new GridLayout();
        glContent.numColumns = numColumns;
        glContent.marginHeight = 0;
        glContent.marginWidth = 0;
        glContent.horizontalSpacing = 2;
        this.cmpTop.setLayout((Layout)glContent);
        GridData gd2 = new GridData(768);
        this.cmpTop.setLayoutData((Object)gd2);
        Label lblDesc = null;
        if (this.description != null && this.description.length() > 0) {
            lblDesc = new Label(this.cmpTop, 0);
            lblDesc.setText(this.description);
            lblDesc.setToolTipText(this.tooltipWhenBlank);
        }
        if ((this.style & 2) == 2) {
            this.createAggregationItem(this.cmpTop);
        }
        boolean isSharingChart = this.context.getDataServiceProvider().checkState(2048);
        final Object[] predefinedQuery = this.context.getPredefinedQuery(this.queryType);
        this.sbHelper.reset(predefinedQuery);
        IDataServiceProvider provider = this.context.getDataServiceProvider();
        boolean needComboField = predefinedQuery != null && predefinedQuery.length > 0 && (provider.checkState(16) || provider.checkState(2) || provider.checkState(8192) && !provider.checkState(32) || provider.checkState(1024));
        boolean hasContentAssist = !isSharingChart && predefinedQuery != null && predefinedQuery.length > 0;
        AssistField assistField = null;
        if (needComboField &= !isSharingChart) {
            control = new Composite(this.cmpTop, 0);
            gd = new GridData(1808);
            gd.widthHint = 80;
            control.setLayoutData((Object)gd);
            gl = new GridLayout();
            FieldAssistHelper.getInstance().initDecorationMargin(gl);
            control.setLayout((Layout)gl);
            this.cmbDefinition = new CCombo(control, this.context.getDataServiceProvider().checkState(32) ? 2056 : 2048);
            gd = new GridData(768);
            gd.grabExcessHorizontalSpace = true;
            this.cmbDefinition.setLayoutData((Object)gd);
            if (hasContentAssist) {
                assistField = new CComboAssistField(this.cmbDefinition, null, null);
            }
            this.cmbDefinition.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    String oldQuery = BaseDataDefinitionComponent.this.query.getDefinition() == null ? "" : BaseDataDefinitionComponent.this.query.getDefinition();
                    String text = BaseDataDefinitionComponent.this.btnBuilder.getExpression();
                    if (!BaseDataDefinitionComponent.this.isTableSharedBinding() && !BaseDataDefinitionComponent.this.isInXTabNonAggrCellAndInheritCube() && text.equals(oldQuery)) {
                        return;
                    }
                    if (!oldQuery.equals(text) && BaseDataDefinitionComponent.this.queryType == "value") {
                        BaseDataDefinitionComponent.this.context.getDataServiceProvider().update("value", (Object)text);
                    }
                    if (BaseDataDefinitionComponent.this.context.getDataServiceProvider().checkState(32) && "category".equals(BaseDataDefinitionComponent.this.queryType) && BaseDataDefinitionComponent.this.context.getModel() instanceof ChartWithAxes) {
                        ((ChartWithAxes)BaseDataDefinitionComponent.this.context.getModel()).setTransposed(BaseDataDefinitionComponent.this.cmbDefinition.getSelectionIndex() > 0);
                    }
                    if (predefinedQuery.length == 0 && (BaseDataDefinitionComponent.this.getQuery().getDefinition() == null || BaseDataDefinitionComponent.this.getQuery().getDefinition().equals(""))) {
                        BaseDataDefinitionComponent.this.cmbDefinition.setEnabled(false);
                        BaseDataDefinitionComponent.this.btnBuilder.setEnabled(false);
                    }
                }
            });
        } else {
            control = this.cmpTop;
            if (hasContentAssist) {
                control = new Composite(this.cmpTop, 0);
                gd = new GridData(1808);
                gd.widthHint = 80;
                control.setLayoutData((Object)gd);
                gl = new GridLayout();
                FieldAssistHelper.getInstance().initDecorationMargin(gl);
                control.setLayout((Layout)gl);
            }
            this.txtDefinition = new Text(control, 2052);
            GridData gdTXTDefinition = new GridData(768);
            gdTXTDefinition.widthHint = 80;
            gdTXTDefinition.grabExcessHorizontalSpace = true;
            this.txtDefinition.setLayoutData((Object)gdTXTDefinition);
            if (hasContentAssist) {
                assistField = new TextAssistField(this.txtDefinition, null, null);
            }
        }
        try {
            this.btnBuilder = (IExpressionButton)this.context.getUIServiceProvider().invoke(IUIServiceProvider.Command.EXPRESS_BUTTON_CREATE, new Object[]{this.cmpTop, this.getInputControl(), this.context.getExtendedItem(), 1, new Listener(){

                public void handleEvent(Event event) {
                    BaseDataDefinitionComponent.this.onModifyExpression();
                }
            }});
        }
        catch (ChartException e) {
            WizardBase.displayException((Throwable)e);
        }
        if (needComboField && predefinedQuery.length == 0 && (this.getQuery().getDefinition() == null || this.getQuery().getDefinition().equals(""))) {
            this.cmbDefinition.setEnabled(false);
            this.btnBuilder.setEnabled(false);
        }
        this.btnBuilder.setPredefinedQuery(predefinedQuery);
        this.btnBuilder.setAssitField((IAssistField)assistField);
        if (this.query != null) {
            this.btnBuilder.setExpression(this.query.getDefinition());
        }
        Control dropControl = this.getInputControl();
        DropTarget target = new DropTarget(dropControl, 1);
        Transfer[] types = new Transfer[]{SimpleTextTransfer.getInstance()};
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DataTextDropListener(dropControl, this.btnBuilder));
        DataDefinitionTextManager.getInstance().addDataDefinitionText(dropControl, (IQueryExpressionManager)this);
        if ((this.style & 1) == 1) {
            this.btnGroup = new Button(this.cmpTop, 8);
            GridData gdBTNGroup = new GridData();
            ChartUIUtil.setChartImageButtonSizeByPlatform((GridData)gdBTNGroup);
            this.btnGroup.setLayoutData((Object)gdBTNGroup);
            this.btnGroup.setImage(UIHelper.getImage((String)"icons/obj16/group.gif"));
            this.btnGroup.addSelectionListener((SelectionListener)this);
            this.btnGroup.setToolTipText(Messages.getString("BaseDataDefinitionComponent.Label.EditGroupSorting"));
        }
        boolean bl = isCubeNoMultiDimensions = (provider.checkState(2) || provider.checkState(256)) && !provider.checkState(64);
        if (this.context.getDataServiceProvider().checkState(32) || this.context.getDataServiceProvider().checkState(16)) {
            if (!(this.txtDefinition == null || this.context.getDataServiceProvider().checkState(256) && !isSharingChart || "optional".equals(this.queryType) && provider.checkState(128) && this.getQuery().getDefinition() != null && this.getQuery().getDefinition().trim().length() != 0)) {
                this.txtDefinition.setEnabled(false);
                this.btnBuilder.setEnabled(false);
            }
            if (this.btnGroup != null) {
                this.btnGroup.setEnabled(false);
            }
        }
        if (this.cmbDefinition != null && "optional".equals(this.queryType) && isCubeNoMultiDimensions) {
            this.cmbDefinition.setEnabled(false);
            this.btnBuilder.setEnabled(false);
        }
        this.setTooltipForInputControl();
        boolean isRequiredField = "category".equals(this.queryType);
        if (lblDesc != null && isRequiredField) {
            FieldAssistHelper.getInstance().addRequiredFieldIndicator(lblDesc);
        }
        return this.cmpTop;
    }

    private boolean isTableSharedBinding() {
        return this.cmbDefinition != null && !this.cmbDefinition.isDisposed() && (this.context.getDataServiceProvider().checkState(16) || this.context.getDataServiceProvider().checkState(1024));
    }

    private boolean isInXTabNonAggrCellAndInheritCube() {
        IDataServiceProvider provider = this.context.getDataServiceProvider();
        int state = provider.getState();
        return (state & 3) == 0 && (state & 0x2000) != 0 && (state & 0x10) == 0 && (state & 0x20) == 0;
    }

    public void selectArea(boolean selected, Object data) {
        if (data instanceof Object[]) {
            Object[] array = (Object[])data;
            this.seriesdefinition = (SeriesDefinition)array[0];
            this.query = (Query)array[1];
            this.updateText(this.query.getDefinition());
            DataDefinitionTextManager.getInstance().addDataDefinitionText(this.getInputControl(), (IQueryExpressionManager)this);
            this.setTooltipForInputControl();
            if (this.fAggEditorComposite != null) {
                this.fAggEditorComposite.setAggregation(this.query, this.seriesdefinition);
            }
        }
    }

    public void dispose() {
        if (this.getInputControl() != null) {
            DataDefinitionTextManager.getInstance().removeDataDefinitionText(this.getInputControl());
        }
        super.dispose();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnGroup)) {
            this.handleGroupAction();
        }
    }

    protected void handleGroupAction() {
        SeriesDefinition sdBackup = this.seriesdefinition.copyInstance();
        GroupSortingDialog groupDialog = this.createGroupSortingDialog(sdBackup);
        if (groupDialog.open() == 0) {
            if (!sdBackup.eIsSet((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Sorting())) {
                this.seriesdefinition.eUnset((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Sorting());
            } else {
                this.seriesdefinition.setSorting(sdBackup.getSorting());
            }
            this.seriesdefinition.setSortKey(sdBackup.getSortKey());
            this.seriesdefinition.getSortKey().eAdapters().addAll((Collection)this.seriesdefinition.eAdapters());
            this.seriesdefinition.setSortLocale(sdBackup.getSortLocale());
            if (sdBackup.isSetSortStrength()) {
                this.seriesdefinition.setSortStrength(sdBackup.getSortStrength());
            } else {
                this.seriesdefinition.unsetSortStrength();
            }
            this.seriesdefinition.setGrouping(sdBackup.getGrouping());
            this.seriesdefinition.getGrouping().eAdapters().addAll((Collection)this.seriesdefinition.eAdapters());
            ChartUIUtil.checkGroupType((ChartWizardContext)this.context, (Chart)this.context.getModel());
            ChartUIUtil.checkAggregateType((ChartWizardContext)this.context);
            DataDefinitionTextManager.getInstance().updateTooltip();
        }
    }

    protected void onModifyExpression() {
        String newExpr = this.btnBuilder.getExpression();
        this.updateQuery(newExpr);
        this.setTooltipForInputControl();
        Event e = new Event();
        e.widget = this.getInputControl();
        e.type = 2;
        e.detail = 4;
        this.context.getDataSheet().notifyListeners(e);
    }

    protected GroupSortingDialog createGroupSortingDialog(SeriesDefinition sdBackup) {
        return new BaseGroupSortingDialog(this.cmpTop.getShell(), this.context, sdBackup);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setTooltipForInputControl() {
        Control control = this.getInputControl();
        if (control != null && !control.isDisposed()) {
            this.getInputControl().setToolTipText(this.getTooltipForDataText(ChartUIUtil.getText((Control)control)));
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private String getTooltipForDataText(String queryText) {
        if (this.isTableSharedBinding()) {
            return this.cmbDefinition.getToolTipText();
        }
        if (queryText.trim().length() == 0) {
            return this.tooltipWhenBlank;
        }
        if ("value".equals(this.queryType) && this.context.getDataServiceProvider().checkState(1)) {
            boolean baseEnabled;
            SeriesDefinition baseSd = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)this.context.getModel()).get(0);
            SeriesGrouping sg = null;
            boolean bl = baseEnabled = baseSd.getGrouping() != null && baseSd.getGrouping().isEnabled();
            if (baseEnabled) {
                sg = baseSd.getGrouping();
                if (this.seriesdefinition.getGrouping() != null && this.seriesdefinition.getGrouping().isEnabled()) {
                    sg = this.seriesdefinition.getGrouping();
                }
            }
            if (this.query.getGrouping() != null && this.query.getGrouping().isEnabled()) {
                sg = this.query.getGrouping();
            }
            if (sg != null) {
                StringBuffer sbuf = new StringBuffer();
                sbuf.append(sg.getAggregateExpression());
                sbuf.append("( ");
                sbuf.append(queryText);
                IAggregateFunction aFunc = null;
                try {
                    aFunc = PluginSettings.instance().getAggregateFunction(sg.getAggregateExpression());
                }
                catch (ChartException chartException) {}
                if (!baseEnabled && aFunc != null && aFunc.getType() == 0) {
                    return queryText;
                }
                int count = aFunc != null ? aFunc.getParametersCount() : sg.getAggregateParameters().size();
                int i = 0;
                while (i < sg.getAggregateParameters().size()) {
                    if (i < count) {
                        sbuf.append(", ");
                        sbuf.append((String)sg.getAggregateParameters().get(i));
                    }
                    ++i;
                }
                sbuf.append(" )");
                return sbuf.toString();
            }
        }
        return queryText;
    }

    public void setTooltipWhenBlank(String tootipWhenBlank) {
        this.tooltipWhenBlank = tootipWhenBlank;
    }

    private void createAggregationItem(Composite composite) {
        boolean enabled;
        SeriesDefinition baseSD = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)this.context.getModel()).get(0);
        boolean bl = enabled = ChartUIUtil.isGroupingSupported((ChartWizardContext)this.context) && (PluginSettings.instance().inEclipseEnv() || baseSD.getGrouping().isEnabled());
        if (this.query.getGrouping() == null) {
            SeriesGrouping aggGrouping = SeriesGroupingImpl.create();
            if (this.seriesdefinition.getGrouping() != null) {
                aggGrouping.setAggregateExpression(this.seriesdefinition.getGrouping().getAggregateExpression());
            }
            this.query.setGrouping(aggGrouping);
        }
        this.fAggEditorComposite = new AggregateEditorComposite(composite, this.seriesdefinition, this.context, enabled, this.query);
    }

    private Control getInputControl() {
        if (this.txtDefinition != null) {
            return this.txtDefinition;
        }
        if (this.cmbDefinition != null) {
            return this.cmbDefinition;
        }
        return null;
    }

    public void updateQuery(String expression) {
        Object checkResult;
        if (this.getInputControl() instanceof CCombo && (checkResult = this.context.getDataServiceProvider().checkData(this.queryType, (Object)expression)) != null && checkResult instanceof Boolean && !((Boolean)checkResult).booleanValue()) {
            return;
        }
        if (this.isTableSharedBinding()) {
            this.updateQueryForSharedBinding(expression);
        } else {
            this.setQueryExpression(expression);
        }
    }

    private void updateQueryForSharedBinding(String expression) {
        if ("category".equals(this.queryType) || "optional".equals(this.queryType)) {
            boolean isGroupExpr;
            String grpName = this.sbHelper.findGroupName(expression);
            boolean bl = isGroupExpr = grpName != null;
            if ("category".equals(this.queryType)) {
                ChartAdapter.beginIgnoreNotifications();
                this.seriesdefinition.getGrouping().setEnabled(isGroupExpr);
                this.query.setDefinition(null);
                ChartAdapter.endIgnoreNotifications();
            }
            if (isGroupExpr) {
                expression = this.sbHelper.translateToBindingName(expression, grpName);
            }
        } else if ("value".equals(this.queryType)) {
            String aggrName = this.sbHelper.findAggrName(expression);
            boolean isAggregationExpr = aggrName != null;
            String chartAggr = isAggregationExpr ? this.sbHelper.getChartAggr(aggrName) : null;
            ChartAdapter.beginIgnoreNotifications();
            this.query.getGrouping().setEnabled(isAggregationExpr);
            this.query.getGrouping().setAggregateExpression(chartAggr);
            ChartAdapter.endIgnoreNotifications();
            if (isAggregationExpr) {
                expression = this.sbHelper.translateToBindingName(expression, aggrName);
            }
        }
        this.setQueryExpression(expression);
    }

    private void setQueryExpression(String expression) {
        if ("value".equals(this.queryType)) {
            if (!(this.context.getChartType() instanceof GanttChart) && !this.context.getDataServiceProvider().checkState(16) && this.context.getDataServiceProvider().checkState(1) && this.context.getDataServiceProvider().getDataType(expression) == DataType.DATE_TIME_LITERAL) {
                ChartAdapter.beginIgnoreNotifications();
                if (this.query.getGrouping() == null) {
                    this.query.setGrouping(DataFactoryImpl.init().createSeriesGrouping());
                }
                SeriesGrouping group = this.query.getGrouping();
                group.setEnabled(true);
                group.setAggregateExpression("First");
                ChartAdapter.endIgnoreNotifications();
            }
        } else if ("category".equals(this.queryType)) {
            DataType type = this.context.getDataServiceProvider().getDataType(expression);
            ChartAdapter.beginIgnoreNotifications();
            if (this.seriesdefinition.getGrouping() == null) {
                this.seriesdefinition.setGrouping(DataFactoryImpl.init().createSeriesGrouping());
            }
            this.seriesdefinition.getGrouping().setGroupType(type);
            if (type == DataType.DATE_TIME_LITERAL) {
                this.seriesdefinition.getGrouping().setGroupingUnit(GroupingUnitType.YEARS_LITERAL);
            }
            if (ChartUIUtil.hasLimitOnCategorySortKey((ChartWizardContext)this.context) && ChartUtil.hasSorting((SeriesDefinition)this.seriesdefinition)) {
                Query sortQuery = this.seriesdefinition.getSortKey();
                if (sortQuery == null) {
                    sortQuery = QueryImpl.create((String)expression);
                    sortQuery.eAdapters().addAll((Collection)this.seriesdefinition.eAdapters());
                    this.seriesdefinition.setSortKey(sortQuery);
                } else {
                    sortQuery.setDefinition(expression);
                }
            }
            ChartAdapter.endIgnoreNotifications();
        } else if ("optional".equals(this.queryType)) {
            ChartAdapter.beginIgnoreNotifications();
            if (expression == null || expression.trim().length() == 0) {
                this.seriesdefinition.eUnset((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Sorting());
                if (this.seriesdefinition.getSortKey() != null) {
                    this.seriesdefinition.getSortKey().setDefinition(null);
                }
            } else {
                if (this.seriesdefinition.getSortKey() != null && this.seriesdefinition.getSortKey().getDefinition() != null && this.seriesdefinition.getSortKey().getDefinition().equals(this.query.getDefinition())) {
                    this.seriesdefinition.getSortKey().setDefinition(expression);
                }
                DataType type = this.context.getDataServiceProvider().getDataType(expression);
                if (this.query.getGrouping() == null) {
                    this.query.setGrouping(DataFactoryImpl.init().createSeriesGrouping());
                }
                this.query.getGrouping().setGroupType(type);
                if (type == DataType.DATE_TIME_LITERAL) {
                    this.query.getGrouping().setGroupingUnit(GroupingUnitType.YEARS_LITERAL);
                }
            }
            ChartAdapter.endIgnoreNotifications();
        }
        if (this.query != null) {
            this.query.setDefinition(expression);
        } else {
            this.query = QueryImpl.create((String)expression);
            this.query.eAdapters().addAll((Collection)this.seriesdefinition.eAdapters());
            this.seriesdefinition.setQuery(this.query);
        }
    }

    public Query getQuery() {
        if (this.query == null) {
            this.query = DataFactory.eINSTANCE.createQuery();
            this.query.eAdapters().addAll((Collection)this.seriesdefinition.eAdapters());
            ChartAdapter.beginIgnoreNotifications();
            this.seriesdefinition.setQuery(this.query);
            ChartAdapter.endIgnoreNotifications();
        }
        return this.query;
    }

    public String getDisplayExpression() {
        String expr = this.btnBuilder.getExpression();
        return expr == null ? "" : expr;
    }

    public boolean isValidExpression(String expression) {
        if (this.context.getDataServiceProvider().checkState(16) || this.context.getDataServiceProvider().checkState(1024) || this.context.getDataServiceProvider().checkState(2)) {
            if (this.cmbDefinition == null) {
                return false;
            }
            int index = this.cmbDefinition.indexOf(expression);
            return index >= 0;
        }
        return true;
    }

    private boolean isGroupEnabled() {
        return this.seriesdefinition != null && this.seriesdefinition.getGrouping() != null && this.seriesdefinition.getGrouping().isEnabled();
    }

    private boolean isAggregateEnabled() {
        return this.query != null && this.query.getGrouping() != null && this.query.getGrouping().isEnabled() && this.query.getGrouping().getAggregateExpression() != null;
    }

    public void updateText(String expression) {
        if (this.isTableSharedBinding() && ("category".equals(this.queryType) && this.isGroupEnabled() || "optional".equals(this.queryType) || "value".equals(this.queryType) && this.isAggregateEnabled())) {
            expression = this.sbHelper.translateFromBindingName(expression);
        }
        if (this.btnBuilder != null) {
            this.btnBuilder.setExpression(expression);
        }
    }

    public String getExpressionType() {
        if (this.btnBuilder != null) {
            return this.btnBuilder.getExpressionType();
        }
        return null;
    }

    public IExpressionButton getExpressionButton() {
        return this.btnBuilder;
    }

    private static class SharedBindingHelper {
        private final ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
        private final Map<String, String> mapBindingName = new HashMap<String, String>();
        private final Map<String, ColumnBindingInfo> mapBinding = new HashMap<String, ColumnBindingInfo>();

        private SharedBindingHelper() {
        }

        public void reset(Object[] predefinedQuery) {
            this.mapBindingName.clear();
            this.mapBinding.clear();
            if (predefinedQuery != null) {
                Object[] objectArray = predefinedQuery;
                int n = predefinedQuery.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof ColumnBindingInfo) {
                        ColumnBindingInfo cbi = (ColumnBindingInfo)obj;
                        switch (cbi.getColumnType()) {
                            case 1: 
                            case 2: {
                                String bindingName = this.exprCodec.getBindingName(cbi.getExpression());
                                this.mapBindingName.put(cbi.getName(), bindingName);
                                this.mapBinding.put(cbi.getName(), cbi);
                            }
                        }
                    }
                    ++n2;
                }
            }
        }

        public String findGroupName(String expr) {
            return this.findName(expr, 1);
        }

        public String findAggrName(String expr) {
            return this.findName(expr, 2);
        }

        private String findName(String expr, int columnType) {
            if (expr != null && expr.length() > 0) {
                for (Map.Entry<String, ColumnBindingInfo> entry : this.mapBinding.entrySet()) {
                    String name;
                    if (entry.getValue().getColumnType() != columnType || !expr.contains(name = entry.getKey())) continue;
                    return name;
                }
            }
            return null;
        }

        public String getChartAggr(String aggrName) {
            ColumnBindingInfo cbi = this.mapBinding.get(aggrName);
            if (cbi != null) {
                return cbi.getChartAggExpression();
            }
            return null;
        }

        public String translateToBindingName(String expr, String name) {
            String bindingName;
            if (expr != null && expr.length() > 0 && (bindingName = this.mapBindingName.get(name)) != null) {
                expr = expr.replaceAll(name, bindingName);
            }
            return expr;
        }

        public String translateFromBindingName(String expr) {
            if (expr != null && expr.length() > 0) {
                for (Map.Entry<String, String> entry : this.mapBindingName.entrySet()) {
                    if (!expr.contains(entry.getValue())) continue;
                    return expr.replaceAll(entry.getValue(), entry.getKey());
                }
            }
            return expr;
        }
    }
}

