/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskChangeListener;
import org.eclipse.birt.chart.ui.swt.wizard.ApplyButtonHandler;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.core.ui.frameworks.taskwizard.TasksManager;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBaseDialog;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ITask;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IWizardContext;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ChartWizard
extends WizardBase {
    public static final String PreviewPainter_ID = "ChartPreviewPainter";
    public static final String RepDSProvider_Cube_ID = "ReportDataServiceProvider.setDataCube";
    public static final String RepDSProvider_Set_ID = "ReportDataServiceProvider.setDataSet";
    public static final String RepDSProvider_Ref_ID = "ReportDataServiceProvider.setReportItemReference";
    public static final String RepDSProvider_Style_ID = "ReportDataServiceProvider.setStyle";
    public static final String StaChartDSh_switch_ID = "StandardChartDataSheet.swtichDataSet";
    public static final String StaChartDSh_dPreview_ID = "StandChartDataSheet.dataPreview";
    public static final String StaChartDSh_gHeaders_ID = "StandardChartDataSheet.getPreviewHeaders";
    public static final String StaChartDSh_checCube_ID = "StandardChartDataSheet.checkCubeColumnBinding";
    public static final String ChartColBinDia_ID = "ChartColumnBindingDialog";
    public static final String FormatSpeciCom_ID = "FormatSpecifierComposite";
    public static final String MarkerEdiCom_ID = "MarkerEditorComposite";
    public static final String PluginSet_getAggF_ID = "PluginSettings.getAggregateFunc";
    public static final String PluginSet_getDPDef_ID = "PluginSettings.getDataPointDefinition";
    public static final String CheckSeriesBindingType_ID = "CheckSeriesBindingType_";
    public static final String TaskSelType_chOvST_ID = "TaskSelectType.changeOverlaySeriesType";
    public static final String TaskSelType_refreCh_ID = "TaskSelectType.refreshChart";
    public static final String LineSMarkerSh_ID = "LineSeriesMarkerSheet";
    public static final String SeriesShImpl_ID = "SeriesSheetImpl.getNewSeries";
    public static final String ChartUIUtil_pLiPreview_ID = "ChartUIUtil.prepareLivePreview";
    public static final String Gatt_aggCheck_ID = "Gantt.aggCheck_";
    public static final String ChartUIUtil_cGType_ID = "ChartUIUtil.checkGroupType";
    private static final int CHART_WIZARD_WIDTH_MINMUM = 690;
    private static final int CHART_WIZARD_HEIGHT_MINMUM = 670;
    private static Map<String, String> errors = new HashMap<String, String>(3);
    public static boolean POPUP_CLOSING_BY_USER = true;
    private static Map<String, String> lastTask = new HashMap<String, String>(3);
    private ChartAdapter adapter = null;
    protected boolean isOkPressed = false;

    public ChartWizard() {
        this(null);
    }

    public ChartWizard(Shell parentShell) {
        this(parentShell, ChartWizard.class.getName(), 690, 670, Messages.getString("ChartWizard.Title.ChartBuilder"), UIHelper.getImage("icons/obj16/chartselector.gif"), Messages.getString("ChartWizard.Label.SelectChartTypeDataFormat"), UIHelper.getImage("icons/wizban/chartwizardtaskbar.gif"));
    }

    protected ChartWizard(Shell parentShell, String wizardId, int iInitialWidth, int iInitialHeight, String strTitle, Image imgTitle, String strHeader, Image imgHeader) {
        super(parentShell, wizardId, iInitialWidth, iInitialHeight, strTitle, imgTitle, strHeader, imgHeader);
        this.setWizardClosedWhenEnterPressed(false);
        this.adapter = new ChartAdapter(this);
    }

    public void addTask(String sTaskID) {
        super.addTask(sTaskID);
        ITask task = TasksManager.instance().getTask(sTaskID);
        if (task instanceof ITaskChangeListener) {
            this.adapter.addListener((ITaskChangeListener)task);
        }
    }

    private void removeAllAdapters(EObject chart) {
        chart.eAdapters().remove((Object)this.adapter);
        TreeIterator iterator = chart.eAllContents();
        while (iterator.hasNext()) {
            EObject oModel = (EObject)iterator.next();
            oModel.eAdapters().remove((Object)this.adapter);
        }
    }

    protected EObject getAdaptableObject(IWizardContext context) {
        return ((ChartWizardContext)context).getModel();
    }

    public void dispose() {
        if (this.getContext() != null) {
            this.getContext().getDataSheet().dispose();
            EObject chart = this.getAdaptableObject(this.getContext());
            if (chart != null) {
                this.removeAllAdapters(chart);
                ChartCacheManager.getInstance().dispose();
            }
        }
        super.dispose();
    }

    public EContentAdapter getAdapter() {
        return this.adapter;
    }

    protected ChartWizardContext getContext() {
        return (ChartWizardContext)this.context;
    }

    public String[] validate() {
        return this.getContext().getUIServiceProvider().validate(this.getContext().getModel(), this.getContext().getExtendedItem());
    }

    protected Chart getChartModel(IWizardContext context) {
        return ((ChartWizardContext)context).getModel();
    }

    public IWizardContext open(String[] sTasks, String topTaskId, IWizardContext initialContext) {
        Chart chart = this.getChartModel(initialContext);
        if (chart == null) {
            this.setTitle(this.getTitleNewChart());
        } else {
            this.setTitle(this.getTitleEditChart());
            this.getAdaptableObject(initialContext).eAdapters().add((Object)this.adapter);
        }
        if (chart == null) {
            topTaskId = null;
        } else if (topTaskId == null) {
            topTaskId = lastTask.get(initialContext.getWizardID());
        }
        return super.open(sTasks, topTaskId, initialContext);
    }

    public void updateTitleAsEdit() {
        if (this.getTitle().equals(this.getTitleNewChart())) {
            this.setTitle(this.getTitleEditChart());
            this.getDialog().getShell().setText(this.getTitleEditChart());
        }
    }

    public void updateApplyButton() {
        List buttonList = this.getCustomButtons();
        int i = 0;
        while (i < buttonList.size()) {
            Button applyButton;
            if (buttonList.get(i) instanceof ApplyButtonHandler && !(applyButton = ((ApplyButtonHandler)buttonList.get(i)).getButton()).isEnabled()) {
                applyButton.setEnabled(true);
            }
            ++i;
        }
    }

    public void detachPopup() {
        POPUP_CLOSING_BY_USER = false;
        super.detachPopup();
        POPUP_CLOSING_BY_USER = true;
    }

    public void switchTo(String sTaskID) {
        lastTask.put(this.getContext().getWizardID(), sTaskID);
        super.switchTo(sTaskID);
    }

    protected String getTitleNewChart() {
        return Messages.getString("ChartWizard.Title.NewChart");
    }

    protected String getTitleEditChart() {
        return Messages.getString("ChartWizard.Title.EditChart");
    }

    public static void showException(String key, final String errorMessage) {
        if (errorMessage != null) {
            try {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        WizardBase.showException((String)errorMessage);
                    }
                });
            }
            catch (Exception exception) {}
            errors.put(key, errorMessage);
        }
    }

    public static void removeException(String key) {
        boolean removed = false;
        String error = errors.get(key);
        if (error != null && error.equals(WizardBase.getErrors())) {
            try {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        WizardBase.removeException();
                    }
                });
            }
            catch (Exception exception) {}
            removed = true;
        }
        errors.remove(key);
        if ((removed || WizardBase.getErrors() == null) && errors.size() > 0) {
            final String es = errors.values().toArray(new String[errors.size()])[0];
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    WizardBase.showException((String)es);
                }
            });
        }
    }

    public static void clearExceptions() {
        errors.clear();
    }

    public static void removeAllExceptions(String subKey) {
        boolean removed = false;
        Iterator<String> iter = errors.keySet().iterator();
        ArrayList<String> needToRemove = new ArrayList<String>(2);
        while (iter.hasNext()) {
            String key = iter.next();
            if (key.indexOf(subKey) <= -1) continue;
            needToRemove.add(key);
        }
        for (String s : needToRemove) {
            String e = errors.get(s);
            if (e != null && e.equals(WizardBase.getErrors())) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        WizardBase.removeException();
                    }
                });
                removed = true;
            }
            errors.remove(s);
        }
        if ((removed || WizardBase.getErrors() == null) && errors.size() > 0) {
            final String es = errors.values().toArray(new String[errors.size()])[0];
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    WizardBase.showException((String)es);
                }
            });
        }
    }

    protected WizardBaseDialog createDialog(Shell shell, int initialWidth, int initialHeight, String strTitle, Image imgTitle) {
        return new WizardBaseDialog(this, shell, initialWidth, initialHeight, strTitle, imgTitle){

            protected void okPressed() {
                super.okPressed();
                ChartWizard.this.isOkPressed = true;
            }
        };
    }

    public boolean isOkPressed() {
        return this.isOkPressed;
    }
}

