/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

public final class Tools {
    public static boolean valuesAreEqual(Object value1, Object value2) {
        return value1 == null ? value2 == null : value2 != null && value1.equals(value2);
    }

    public static boolean valuesAreDifferent(Object value1, Object value2) {
        return !Tools.valuesAreEqual(value1, value2);
    }

    public static boolean jvmIsSun() {
        return Tools.jvmIs("Sun");
    }

    public static boolean jvmIsIBM() {
        return Tools.jvmIs("IBM");
    }

    private static boolean jvmIs(String jvmVendorName) {
        return System.getProperty("java.vendor").startsWith(jvmVendorName);
    }

    public static boolean osIsWindows() {
        return Tools.osIs("Windows");
    }

    public static boolean osIsLinux() {
        return Tools.osIs("Linux");
    }

    private static boolean osIs(String osName) {
        return System.getProperty("os.name").indexOf(osName) != -1;
    }

    private Tools() {
        throw new UnsupportedOperationException();
    }
}

