/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntReference
implements Comparable<IntReference>,
Cloneable,
Serializable {
    private volatile int value = 0;
    private static final long serialVersionUID = 1L;

    public IntReference(int count) {
        this.value = count;
    }

    public IntReference() {
        this(0);
    }

    public int getValue() {
        return this.value;
    }

    public boolean equals(int v) {
        return this.value == v;
    }

    public boolean notEquals(int v) {
        return this.value != v;
    }

    public boolean isZero() {
        return this.value == 0;
    }

    public boolean isNotZero() {
        return this.value != 0;
    }

    public boolean isGreaterThan(int v) {
        return this.value > v;
    }

    public boolean isGreaterThanOrEqual(int v) {
        return this.value >= v;
    }

    public boolean isLessThan(int v) {
        return this.value < v;
    }

    public boolean isLessThanOrEqual(int v) {
        return this.value <= v;
    }

    public boolean isPositive() {
        return this.isGreaterThan(0);
    }

    public boolean isNotPositive() {
        return this.isLessThanOrEqual(0);
    }

    public boolean isNegative() {
        return this.isLessThan(0);
    }

    public boolean isNotNegative() {
        return this.isGreaterThanOrEqual(0);
    }

    public int setValue(int value) {
        int old = this.value;
        this.value = value;
        return old;
    }

    public int abs() {
        this.value = Math.abs(this.value);
        return this.value;
    }

    public int neg() {
        this.value = -this.value;
        return this.value;
    }

    public int setZero() {
        return this.setValue(0);
    }

    public int add(int v) {
        return this.value += v;
    }

    public int increment() {
        return ++this.value;
    }

    public int subtract(int v) {
        return this.value -= v;
    }

    public int decrement() {
        return --this.value;
    }

    public int multiply(int v) {
        return this.value *= v;
    }

    public int divide(int v) {
        return this.value /= v;
    }

    public int remainder(int v) {
        return this.value %= v;
    }

    public int min(int v) {
        this.value = Math.min(this.value, v);
        return this.value;
    }

    public int max(int v) {
        this.value = Math.max(this.value, v);
        return this.value;
    }

    public int pow(int v) {
        this.value = (int)Math.pow(this.value, v);
        return this.value;
    }

    @Override
    public int compareTo(IntReference ir) {
        int v = ir.getValue();
        return this.value < v ? -1 : (this.value == v ? 0 : 1);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        return o instanceof IntReference && this.value == ((IntReference)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.value) + ']';
    }
}

