/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameCompilationUnitProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameEnumConstProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameJavaProjectProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameLocalVariableProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameNonVirtualMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenamePackageProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameSourceFolderProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeParameterProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameVirtualMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.UserInterfaceStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameRefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameSelectionState;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameUserInterfaceManager;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameUserInterfaceStarter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.swt.widgets.Shell;

public class RenameSupport {
    private RenameRefactoring fRefactoring;
    private RefactoringStatus fPreCheckStatus;
    public static final int NONE = 0;
    public static final int UPDATE_REFERENCES = 1;
    public static final int UPDATE_JAVADOC_COMMENTS = 2;
    public static final int UPDATE_REGULAR_COMMENTS = 4;
    public static final int UPDATE_STRING_LITERALS = 8;
    public static final int UPDATE_TEXTUAL_MATCHES = 64;
    public static final int UPDATE_GETTER_METHOD = 16;
    public static final int UPDATE_SETTER_METHOD = 32;
    static /* synthetic */ Class class$0;

    public IStatus preCheck() throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            return this.fPreCheckStatus.getEntryMatchingSeverity(4).toStatus();
        }
        return Status.OK_STATUS;
    }

    public void openDialog(Shell parent) throws CoreException {
        this.openDialog(parent, false);
    }

    public boolean openDialog(Shell parent, boolean showPreviewOnly) throws CoreException {
        UserInterfaceStarter starter;
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            this.showInformation(parent, this.fPreCheckStatus);
            return false;
        }
        if (!showPreviewOnly) {
            starter = RenameUserInterfaceManager.getDefault().getStarter((Refactoring)this.fRefactoring);
        } else {
            starter = new RenameUserInterfaceStarter();
            RenameRefactoringWizard wizard = new RenameRefactoringWizard((Refactoring)this.fRefactoring, this.fRefactoring.getName(), null, null, null){

                protected void addUserInputPages() {
                }
            };
            wizard.setForcePreviewReview(showPreviewOnly);
            starter.initialize(wizard);
        }
        return starter.activate((Refactoring)this.fRefactoring, parent, this.getJavaRenameProcessor().getSaveMode());
    }

    public void perform(Shell parent, IRunnableContext context) throws InterruptedException, InvocationTargetException {
        try {
            this.ensureChecked();
            if (this.fPreCheckStatus.hasFatalError()) {
                this.showInformation(parent, this.fPreCheckStatus);
                return;
            }
            RenameSelectionState state = this.createSelectionState();
            RefactoringExecutionHelper helper = new RefactoringExecutionHelper((Refactoring)this.fRefactoring, RefactoringCore.getConditionCheckingFailedSeverity(), this.getJavaRenameProcessor().getSaveMode(), parent, context);
            helper.perform(true, true);
            this.restoreSelectionState(state);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private RenameSupport(RenameJavaElementDescriptor descriptor) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        this.fRefactoring = (RenameRefactoring)descriptor.createRefactoring(refactoringStatus);
        if (refactoringStatus.hasFatalError()) {
            this.fPreCheckStatus = refactoringStatus;
        } else {
            this.preCheck();
            refactoringStatus.merge(this.fPreCheckStatus);
            this.fPreCheckStatus = refactoringStatus;
        }
    }

    public static RenameSupport create(RenameJavaElementDescriptor descriptor) throws CoreException {
        return new RenameSupport(descriptor);
    }

    private RenameSupport(JavaRenameProcessor processor, String newName, int flags) {
        this.fRefactoring = new RenameRefactoring((RenameProcessor)processor);
        RenameSupport.initialize(processor, newName, flags);
    }

    private JavaRenameProcessor getJavaRenameProcessor() {
        return (JavaRenameProcessor)this.fRefactoring.getProcessor();
    }

    public static RenameSupport create(IJavaProject project, String newName, int flags) throws CoreException {
        RenameJavaProjectProcessor processor = new RenameJavaProjectProcessor(project);
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(IPackageFragmentRoot root, String newName) throws CoreException {
        RenameSourceFolderProcessor processor = new RenameSourceFolderProcessor(root);
        return new RenameSupport(processor, newName, 0);
    }

    public static RenameSupport create(IPackageFragment fragment, String newName, int flags) throws CoreException {
        RenamePackageProcessor processor = new RenamePackageProcessor(fragment);
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(ICompilationUnit unit, String newName, int flags) throws CoreException {
        RenameCompilationUnitProcessor processor = new RenameCompilationUnitProcessor(unit);
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(IType type, String newName, int flags) throws CoreException {
        RenameTypeProcessor processor = new RenameTypeProcessor(type);
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(IMethod method, String newName, int flags) throws CoreException {
        RenameMethodProcessor processor = MethodChecks.isVirtual(method) ? new RenameVirtualMethodProcessor(method) : new RenameNonVirtualMethodProcessor(method);
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(IField field, String newName, int flags) throws CoreException {
        if (JdtFlags.isEnum((IMember)field)) {
            return new RenameSupport(new RenameEnumConstProcessor(field), newName, flags);
        }
        RenameFieldProcessor processor = new RenameFieldProcessor(field);
        processor.setRenameGetter(RenameSupport.updateGetterMethod(flags));
        processor.setRenameSetter(RenameSupport.updateSetterMethod(flags));
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(ITypeParameter parameter, String newName, int flags) throws CoreException {
        RenameTypeParameterProcessor processor = new RenameTypeParameterProcessor(parameter);
        processor.setUpdateReferences(RenameSupport.updateReferences(flags));
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(ILocalVariable variable, String newName, int flags) throws CoreException {
        RenameLocalVariableProcessor processor = new RenameLocalVariableProcessor(variable);
        processor.setUpdateReferences(RenameSupport.updateReferences(flags));
        return new RenameSupport(processor, newName, flags);
    }

    private static void initialize(JavaRenameProcessor processor, String newName, int flags) {
        RenameSupport.setNewName(processor, newName);
        if (processor instanceof IReferenceUpdating) {
            IReferenceUpdating reference = (IReferenceUpdating)((Object)processor);
            reference.setUpdateReferences(RenameSupport.updateReferences(flags));
        }
        if (processor instanceof ITextUpdating) {
            ITextUpdating text = (ITextUpdating)((Object)processor);
            text.setUpdateTextualMatches(RenameSupport.updateTextualMatches(flags));
        }
    }

    private static void setNewName(INameUpdating refactoring, String newName) {
        if (newName != null) {
            refactoring.setNewElementName(newName);
        }
    }

    private static boolean updateReferences(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean updateTextualMatches(int flags) {
        int TEXT_UPDATES = 76;
        return (flags & TEXT_UPDATES) != 0;
    }

    private static boolean updateGetterMethod(int flags) {
        return (flags & 0x10) != 0;
    }

    private static boolean updateSetterMethod(int flags) {
        return (flags & 0x20) != 0;
    }

    private void ensureChecked() throws CoreException {
        if (this.fPreCheckStatus == null) {
            this.fPreCheckStatus = !this.fRefactoring.isApplicable() ? RefactoringStatus.createFatalErrorStatus((String)JavaUIMessages.RenameSupport_not_available) : new RefactoringStatus();
        }
    }

    private void showInformation(Shell parent, RefactoringStatus status) {
        String message = status.getMessageMatchingSeverity(4);
        MessageDialog.openInformation((Shell)parent, (String)JavaUIMessages.RenameSupport_dialog_title, (String)message);
    }

    private RenameSelectionState createSelectionState() {
        RenameProcessor processor = (RenameProcessor)this.fRefactoring.getProcessor();
        Object[] elements = processor.getElements();
        RenameSelectionState state = elements.length == 1 ? new RenameSelectionState(elements[0]) : null;
        return state;
    }

    private void restoreSelectionState(RenameSelectionState state) throws CoreException {
        Object newElement;
        INameUpdating nameUpdating;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((nameUpdating = (INameUpdating)this.fRefactoring.getAdapter((Class)clazz)) != null && state != null && (newElement = nameUpdating.getNewElement()) != null) {
            state.restore(newElement);
        }
    }
}

