/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.jdt.internal.ui.preferences.formatter.CompilationUnitPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterProfileStore;
import org.eclipse.jdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class CodeFormatterConfigurationBlock
extends ProfileConfigurationBlock {
    private static final String FORMATTER_DIALOG_PREFERENCE_KEY = "formatter_page";
    private static final String DIALOGSTORE_LASTSAVELOADPATH = "org.eclipse.jdt.ui.codeformatter";
    protected final String PREVIEW = "/**\n* " + FormatterMessages.CodingStyleConfigurationBlock_preview_title + "\n*/\n\n" + "package mypackage; import java.util.LinkedList; public class MyIntStack {" + "private final LinkedList fStack;" + "public MyIntStack(){fStack= new LinkedList();}" + "public int pop(){return ((Integer)fStack.removeFirst()).intValue();}" + "public void push(int elem){fStack.addFirst(new Integer(elem));}" + "public boolean isEmpty() {return fStack.isEmpty();}" + "}";
    private JavaPreview fJavaPreview;

    public CodeFormatterConfigurationBlock(IProject project, PreferencesAccess access) {
        super(project, access, DIALOGSTORE_LASTSAVELOADPATH);
    }

    protected IProfileVersioner createProfileVersioner() {
        return new ProfileVersioner();
    }

    protected ProfileStore createProfileStore(IProfileVersioner versioner) {
        return new FormatterProfileStore(versioner);
    }

    protected ProfileManager createProfileManager(List profiles, IScopeContext context, PreferencesAccess access, IProfileVersioner profileVersioner) {
        return new FormatterProfileManager(profiles, context, access, profileVersioner);
    }

    protected void configurePreview(Composite composite, int numColumns, ProfileManager profileManager) {
        CodeFormatterConfigurationBlock.createLabel(composite, FormatterMessages.CodingStyleConfigurationBlock_preview_label_text, numColumns);
        CompilationUnitPreview result = new CompilationUnitPreview(profileManager.getSelected().getSettings(), composite);
        result.setPreviewText(this.PREVIEW);
        this.fJavaPreview = result;
        GridData gd = new GridData(1296);
        gd.horizontalSpan = numColumns;
        gd.verticalSpan = 7;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.fJavaPreview.getControl().setLayoutData((Object)gd);
        new PreviewController(profileManager);
    }

    protected ModifyDialog createModifyDialog(Shell shell, ProfileManager.Profile profile, ProfileManager profileManager, ProfileStore profileStore, boolean newProfile) {
        return new FormatterModifyDialog(shell, profile, profileManager, profileStore, newProfile, FORMATTER_DIALOG_PREFERENCE_KEY, DIALOGSTORE_LASTSAVELOADPATH);
    }

    private class PreviewController
    implements Observer {
        public PreviewController(ProfileManager profileManager) {
            profileManager.addObserver(this);
            CodeFormatterConfigurationBlock.this.fJavaPreview.setWorkingValues(profileManager.getSelected().getSettings());
            CodeFormatterConfigurationBlock.this.fJavaPreview.update();
        }

        public void update(Observable o, Object arg) {
            int value = (Integer)arg;
            switch (value) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    CodeFormatterConfigurationBlock.this.fJavaPreview.setWorkingValues(((ProfileManager)o).getSelected().getSettings());
                    CodeFormatterConfigurationBlock.this.fJavaPreview.update();
                }
            }
        }
    }
}

