/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.writer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.DataColumnNameValidator;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.DataItem;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ImageItem;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.ListGroup;
import org.eclipse.birt.report.model.elements.ListItem;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TemplateReportItem;
import org.eclipse.birt.report.model.elements.TextDataItem;
import org.eclipse.birt.report.model.elements.TextItem;
import org.eclipse.birt.report.model.util.BoundColumnsMgr;
import org.eclipse.birt.report.model.util.BoundDataColumnUtil;
import org.eclipse.birt.report.model.util.LevelContentIterator;

final class BoundColumnsWriterMgr
extends BoundColumnsMgr {
    private Set<DesignElement> processedElement = new HashSet<DesignElement>();
    private Map<GroupElement, List<Object>> cachedGroup = new HashMap<GroupElement, List<Object>>();
    private String version = null;

    protected BoundColumnsWriterMgr(String version) {
        this.version = version;
    }

    protected void handleBoundsForValue(DesignElement element, Module module, String propValue) {
        if (propValue == null) {
            return;
        }
        List newExprs = null;
        try {
            newExprs = ExpressionUtil.extractColumnExpressions((String)propValue);
        }
        catch (BirtException birtException) {}
        DesignElement target = BoundDataColumnUtil.findTargetOfBoundColumns(element, module);
        if (target instanceof GroupElement) {
            this.appendBoundColumnsToGroup((GroupElement)target, newExprs);
            return;
        }
        if (newExprs != null && newExprs.size() >= 1) {
            int i = 0;
            while (i < newExprs.size()) {
                IColumnBinding boundColumn = (IColumnBinding)newExprs.get(i);
                String newExpression = boundColumn.getBoundExpression();
                if (newExpression != null) {
                    BoundDataColumnUtil.createBoundDataColumn(target, boundColumn.getResultSetColumnName(), newExpression, module);
                }
                ++i;
            }
        }
    }

    private void appendBoundColumnsToGroup(GroupElement target, List newExprs) {
        ArrayList<ComputedColumn> newColumns = new ArrayList<ComputedColumn>();
        int i = 0;
        while (i < newExprs.size()) {
            ComputedColumn column = StructureFactory.createComputedColumn();
            IColumnBinding boundColumn = (IColumnBinding)newExprs.get(i);
            String newExpression = boundColumn.getBoundExpression();
            if (newExpression != null) {
                column.setName(boundColumn.getResultSetColumnName());
                column.setExpression(boundColumn.getBoundExpression());
                if (!newColumns.contains(column)) {
                    newColumns.add(column);
                }
            }
            ++i;
        }
        this.appendBoundColumnsToCachedGroup(target, newColumns);
    }

    private void appendBoundColumnsToCachedGroup(GroupElement target, List newColumns) {
        List<Object> boundColumns = this.cachedGroup.get(target);
        if (boundColumns == null) {
            this.cachedGroup.put(target, newColumns);
            return;
        }
        int i = 0;
        while (i < newColumns.size()) {
            ComputedColumn column = (ComputedColumn)newColumns.get(i);
            if (!boundColumns.contains(column)) {
                boundColumns.add(column);
            }
            ++i;
        }
    }

    protected String appendBoundColumnsToCachedGroup(GroupElement target, String boundName, String expression) {
        ComputedColumn column = StructureFactory.createComputedColumn();
        column.setName(boundName);
        column.setExpression(expression);
        List<Object> boundColumns = this.cachedGroup.get(target);
        if (boundColumns == null) {
            ArrayList<ComputedColumn> newColumns = new ArrayList<ComputedColumn>();
            newColumns.add(column);
            this.cachedGroup.put(target, newColumns);
            return boundName;
        }
        boundColumns.add(column);
        return boundName;
    }

    protected void handleBoundsForParamBinding(DesignElement element, Module module, String propValue) {
        if (propValue == null) {
            return;
        }
        List newExprs = null;
        try {
            newExprs = ExpressionUtil.extractColumnExpressions((String)propValue);
        }
        catch (BirtException birtException) {}
        if (newExprs != null && newExprs.size() >= 1) {
            DesignElement target = BoundDataColumnUtil.findTargetElementOfParamBinding(element, module);
            int i = 0;
            while (i < newExprs.size()) {
                IColumnBinding boundColumn = (IColumnBinding)newExprs.get(i);
                String newExpression = boundColumn.getBoundExpression();
                if (newExpression != null) {
                    BoundDataColumnUtil.createBoundDataColumn(target, boundColumn.getResultSetColumnName(), newExpression, module);
                }
                ++i;
            }
        }
    }

    protected void dealData(DataItem element, Module module) {
        if (this.version != null || this.processedElement.contains(element)) {
            return;
        }
        this.processedElement.add(element);
        super.dealData(element, module);
        this.dealCompatibleValueExpr(element, module);
    }

    private void dealCompatibleValueExpr(DataItem obj, Module module) {
        String valueExpr = (String)obj.getLocalProperty(module, "resultSetColumn");
        if (valueExpr == null) {
            return;
        }
        List newExprs = null;
        try {
            newExprs = ExpressionUtil.extractColumnExpressions((String)valueExpr);
        }
        catch (BirtException birtException) {}
        if (newExprs == null || newExprs.size() == 0) {
            return;
        }
        DesignElement target = BoundDataColumnUtil.findTargetOfBoundColumns(obj, module);
        if (newExprs.size() == 1) {
            IColumnBinding column = (IColumnBinding)newExprs.get(0);
            String newName = column.getResultSetColumnName();
            if (target instanceof GroupElement) {
                this.appendBoundColumnsToCachedGroup((GroupElement)target, newName, column.getBoundExpression());
            } else {
                newName = BoundDataColumnUtil.createBoundDataColumn(target, newName, column.getBoundExpression(), module);
            }
            if (valueExpr.equals(ExpressionUtil.createRowExpression((String)column.getResultSetColumnName()))) {
                obj.setProperty("resultSetColumn", (Object)newName);
                return;
            }
        }
        if (newExprs.size() > 1) {
            if (target instanceof GroupElement) {
                this.appendBoundColumnsToCachedGroup((GroupElement)target, newExprs);
            } else {
                int i = 0;
                while (i < newExprs.size()) {
                    IColumnBinding boundColumn = (IColumnBinding)newExprs.get(i);
                    String newExpression = boundColumn.getBoundExpression();
                    if (newExpression != null) {
                        BoundDataColumnUtil.createBoundDataColumn(target, boundColumn.getResultSetColumnName(), newExpression, module);
                    }
                    ++i;
                }
            }
        }
        String newName = valueExpr;
        if (target instanceof GroupElement) {
            this.appendBoundColumnsToCachedGroup((GroupElement)target, valueExpr, valueExpr);
        } else {
            newName = BoundDataColumnUtil.createBoundDataColumn(target, valueExpr, valueExpr, module);
        }
        obj.setProperty("resultSetColumn", (Object)newName);
    }

    protected void dealExtendedItem(ExtendedItem element, Module module) {
        if (this.version != null || this.processedElement.contains(element)) {
            return;
        }
        this.processedElement.add(element);
        super.dealExtendedItem(element, module);
    }

    protected void dealGrid(GridItem element, Module module) {
        if (this.version != null || this.processedElement.contains(element)) {
            return;
        }
        this.processedElement.add(element);
        super.dealGrid(element, module);
    }

    protected void dealImage(ImageItem element, Module module) {
        if (this.version != null || this.processedElement.contains(element)) {
            return;
        }
        this.processedElement.add(element);
        super.dealImage(element, module);
    }

    protected void dealLabel(Label element, Module module) {
        if (this.version != null || this.processedElement.contains(element)) {
            return;
        }
        this.processedElement.add(element);
        super.dealLabel(element, module);
    }

    protected void dealList(ListItem element, Module module) {
        if (this.version != null || this.processedElement.contains(element)) {
            return;
        }
        this.processedElement.add(element);
        super.dealList(element, module);
        this.appendCachedBoundColumns(element, module);
    }

    protected void dealScalarParameter(ScalarParameter element, Module module) {
        if (this.version != null || this.processedElement.contains(element)) {
            return;
        }
        this.processedElement.add(element);
        super.dealScalarParameter(element, module);
    }

    protected void dealTable(TableItem element, Module module) {
        if (this.version != null || this.processedElement.contains(element)) {
            return;
        }
        this.processedElement.add(element);
        super.dealTable(element, module);
        this.appendCachedBoundColumns(element, module);
    }

    protected void dealTemplateReportItem(TemplateReportItem element, Module module) {
        if (this.version != null || this.processedElement.contains(element)) {
            return;
        }
        this.processedElement.add(element);
        super.dealTemplateReportItem(element, module);
    }

    protected void dealText(TextItem element, Module module) {
        if (this.version != null || this.processedElement.contains(element)) {
            return;
        }
        this.processedElement.add(element);
        super.dealText(element, module);
    }

    protected void dealTextData(TextDataItem element, Module module) {
        if (this.version != null || this.processedElement.contains(element)) {
            return;
        }
        this.processedElement.add(element);
        super.dealTextData(element, module);
    }

    private ComputedColumn checkMatchedBoundColumnForGroup(List columns, String expression, String aggregateOn) {
        if (columns == null || columns.size() == 0 || expression == null) {
            return null;
        }
        int i = 0;
        while (i < columns.size()) {
            ComputedColumn column = (ComputedColumn)columns.get(i);
            if (expression.equals(column.getExpression())) {
                if (aggregateOn == null && column.getAggregateOn() == null) {
                    return column;
                }
                if (aggregateOn != null && aggregateOn.equals(column.getAggregateOn())) {
                    return column;
                }
            }
            ++i;
        }
        return null;
    }

    private String getUniqueBoundColumnNameForGroup(List columns, ComputedColumn checkColumn) {
        ComputedColumn column;
        String oldName;
        String tmpName = oldName = checkColumn.getName();
        int index = 0;
        while ((column = DataColumnNameValidator.getColumn(columns, tmpName)) != null) {
            tmpName = String.valueOf(oldName) + "_" + ++index;
        }
        return tmpName;
    }

    private void reCheckResultSetColumnName(GroupElement group, List columns, Module module) {
        int level = -1;
        if (group instanceof TableGroup) {
            level = 3;
        }
        if (group instanceof ListGroup) {
            level = 1;
        }
        LevelContentIterator contentIter = new LevelContentIterator(module, group, level);
        while (contentIter.hasNext()) {
            ComputedColumn foundColumn;
            String resultSetColumn;
            DesignElement item = contentIter.next();
            if (!(item instanceof DataItem) || StringUtil.isBlank(resultSetColumn = (String)item.getLocalProperty(module, "resultSetColumn")) || (foundColumn = DataColumnNameValidator.getColumn(columns, resultSetColumn)) == null || (foundColumn = this.checkMatchedBoundColumnForGroup(columns, foundColumn.getExpression(), (String)group.getLocalProperty(module, "groupName"))) == null) continue;
            item.setProperty("resultSetColumn", (Object)foundColumn.getName());
        }
    }

    private void appendCachedBoundColumns(ListingElement element, Module module) {
        Set<GroupElement> elements = this.cachedGroup.keySet();
        ContainerSlot groups = element.getSlot(1);
        int i = 0;
        while (i < groups.getCount()) {
            List<Object> columns;
            GroupElement group = (GroupElement)groups.getContent(i);
            module.getNameHelper().makeUniqueName(group);
            String groupName = (String)group.getLocalProperty(module, "groupName");
            if (elements.contains(group) && (columns = this.cachedGroup.get(group)) != null && !columns.isEmpty()) {
                ArrayList<ComputedColumn> tmpList = (ArrayList<ComputedColumn>)element.getLocalProperty(module, "boundDataColumns");
                if (tmpList == null) {
                    tmpList = new ArrayList<ComputedColumn>();
                    element.setProperty("boundDataColumns", tmpList);
                }
                int j = 0;
                while (j < columns.size()) {
                    ComputedColumn column = (ComputedColumn)columns.get(j);
                    column.setAggregateOn(groupName);
                    ComputedColumn foundColumn = this.checkMatchedBoundColumnForGroup(tmpList, column.getExpression(), column.getAggregateOn());
                    if (foundColumn == null || !foundColumn.getName().equals(column.getName())) {
                        String newName = this.getUniqueBoundColumnNameForGroup(tmpList, column);
                        column.setName(newName);
                        tmpList.add(column);
                    }
                    ++j;
                }
                this.reCheckResultSetColumnName(group, tmpList, module);
            }
            ++i;
        }
    }
}

