/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.extension.IEncryptionHelper;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IMetaDataDictionary;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.metadata.IPredefinedStyle;
import org.eclipse.birt.report.model.api.metadata.IPropertyType;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.scripts.IScriptableObjectClassInfo;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.metadata.BooleanPropertyType;
import org.eclipse.birt.report.model.metadata.ChoicePropertyType;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.ClassInfo;
import org.eclipse.birt.report.model.metadata.ColorPropertyType;
import org.eclipse.birt.report.model.metadata.ContentElementPropertyType;
import org.eclipse.birt.report.model.metadata.DateTimePropertyType;
import org.eclipse.birt.report.model.metadata.DimensionPropertyType;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyType;
import org.eclipse.birt.report.model.metadata.ElementRefPropertyType;
import org.eclipse.birt.report.model.metadata.ExpressionPropertyType;
import org.eclipse.birt.report.model.metadata.ExtendsPropertyType;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionManager;
import org.eclipse.birt.report.model.metadata.FloatPropertyType;
import org.eclipse.birt.report.model.metadata.HTMLPropertyType;
import org.eclipse.birt.report.model.metadata.IntegerPropertyType;
import org.eclipse.birt.report.model.metadata.ListPropertyType;
import org.eclipse.birt.report.model.metadata.LiteralStringPropertyType;
import org.eclipse.birt.report.model.metadata.MemberKeyPropertyType;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.NamePropertyType;
import org.eclipse.birt.report.model.metadata.NumberPropertyType;
import org.eclipse.birt.report.model.metadata.PredefinedStyle;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.ResourceKeyPropertyType;
import org.eclipse.birt.report.model.metadata.ScriptPropertyType;
import org.eclipse.birt.report.model.metadata.StringPropertyType;
import org.eclipse.birt.report.model.metadata.StructPropertyType;
import org.eclipse.birt.report.model.metadata.StructRefPropertyType;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.metadata.ULocalePropertyType;
import org.eclipse.birt.report.model.metadata.URIPropertyType;
import org.eclipse.birt.report.model.metadata.XMLPropertyType;
import org.eclipse.birt.report.model.metadata.validators.IValueValidator;
import org.eclipse.birt.report.model.validators.AbstractSemanticValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaDataDictionary
implements IMetaDataDictionary {
    private static MetaDataDictionary instance = new MetaDataDictionary();
    private HashMap<String, IElementDefn> elementNameMap = new LinkedHashMap<String, IElementDefn>();
    private Map<String, IElementDefn> elementXmlNameMap = new HashMap<String, IElementDefn>();
    private ElementDefn style = null;
    private PropertyType[] propertyTypes = new PropertyType[26];
    private HashMap<String, IChoiceSet> choiceSets = new HashMap();
    private HashMap<String, IStructureDefn> structures = new HashMap();
    private Map<String, IClassInfo> classes = new LinkedHashMap<String, IClassInfo>();
    private boolean useElementID = false;
    private HashMap<String, IPredefinedStyle> predefinedStyles = new HashMap();
    private HashMap<String, List<IPredefinedStyle>> predefinedStyleTypes = new HashMap();
    private Map<String, IValueValidator> valueValidators = new HashMap<String, IValueValidator>();
    private Map<String, AbstractSemanticValidator> semanticValidators = new HashMap<String, AbstractSemanticValidator>();
    private boolean useValidationTrigger = false;
    private Map<String, IMethodInfo> functions = null;
    private static boolean isiniatializedExtensionManager = false;

    private MetaDataDictionary() {
        this.addPropertyType(new StringPropertyType());
        this.addPropertyType(new LiteralStringPropertyType());
        this.addPropertyType(new NumberPropertyType());
        this.addPropertyType(new IntegerPropertyType());
        this.addPropertyType(new DimensionPropertyType());
        this.addPropertyType(new ColorPropertyType());
        this.addPropertyType(new ChoicePropertyType());
        this.addPropertyType(new BooleanPropertyType());
        this.addPropertyType(new ExpressionPropertyType());
        this.addPropertyType(new HTMLPropertyType());
        this.addPropertyType(new ResourceKeyPropertyType());
        this.addPropertyType(new URIPropertyType());
        this.addPropertyType(new DateTimePropertyType());
        this.addPropertyType(new XMLPropertyType());
        this.addPropertyType(new NamePropertyType());
        this.addPropertyType(new FloatPropertyType());
        this.addPropertyType(new ElementRefPropertyType());
        this.addPropertyType(new StructPropertyType());
        this.addPropertyType(new ExtendsPropertyType());
        this.addPropertyType(new ScriptPropertyType());
        this.addPropertyType(new StructRefPropertyType());
        this.addPropertyType(new ListPropertyType());
        this.addPropertyType(new MemberKeyPropertyType());
        this.addPropertyType(new ElementPropertyType());
        this.addPropertyType(new ContentElementPropertyType());
        this.addPropertyType(new ULocalePropertyType());
    }

    private void addPropertyType(PropertyType propType) {
        int typeCode = propType.getTypeCode();
        assert (this.propertyTypes[typeCode] == null);
        this.propertyTypes[typeCode] = propType;
    }

    public static MetaDataDictionary getInstance() {
        return instance;
    }

    @Override
    public IElementDefn getElement(String name) {
        return this.elementNameMap.get(name) == null ? ExtensionManager.getInstance().getElement(name) : this.elementNameMap.get(name);
    }

    public IElementDefn getElementByXmlName(String name) {
        return this.elementXmlNameMap.get(name) == null ? ExtensionManager.getInstance().getElementByXmlName(name) : this.elementXmlNameMap.get(name);
    }

    void build() throws MetaDataException {
        this.buildPropertyTypes();
        this.buildElementDefinitions();
        this.buildXmlNameMaps();
        this.validateConstants();
        this.buildStructures();
    }

    private void buildXmlNameMaps() throws MetaDataException {
        for (ElementDefn elementDefn : this.elementNameMap.values()) {
            String tmpXmlName = elementDefn.getXmlName();
            this.elementXmlNameMap.put(tmpXmlName, elementDefn);
        }
    }

    private void validateConstants() throws MetaDataException {
        int i = 0;
        while (i < this.propertyTypes.length) {
            assert (this.propertyTypes[i].getTypeCode() == i);
            ++i;
        }
        this.validateElement("Style");
        this.validateElement("ReportElement");
        this.validateElement("ReportDesign");
    }

    private void validateElement(String name) throws MetaDataException {
        if (this.getElement(name) == null) {
            throw new MetaDataException(new String[]{name}, "ELEMENT_NAME_CONST");
        }
    }

    private void buildPropertyTypes() {
        int i = 0;
        while (i < this.propertyTypes.length) {
            this.propertyTypes[i].build();
            ++i;
        }
    }

    private void buildElementDefinitions() throws MetaDataException {
        this.style = (ElementDefn)this.getElement("Style");
        if (this.style == null) {
            throw new MetaDataException("STYLE_TYPE_MISSING");
        }
        this.style.build();
        ElementDefn report = (ElementDefn)this.getElement("ReportDesign");
        if (report == null) {
            throw new MetaDataException("CONSTRUCTOR_EXISTING");
        }
        report.build();
        for (ElementDefn elementDefn : this.elementNameMap.values()) {
            elementDefn.build();
        }
    }

    private void buildStructures() throws MetaDataException {
        for (StructureDefn structureDefn : this.structures.values()) {
            structureDefn.build();
        }
    }

    @Override
    public PropertyType getPropertyType(int type) {
        assert (type >= 0 && type < this.propertyTypes.length);
        return this.propertyTypes[type];
    }

    @Override
    public List<IPropertyType> getPropertyTypes() {
        ArrayList<IPropertyType> values = new ArrayList<IPropertyType>();
        values.addAll(Arrays.asList(this.propertyTypes));
        return values;
    }

    @Override
    public PropertyType getPropertyType(String xmlName) {
        int i = 0;
        while (i < this.propertyTypes.length) {
            if (this.propertyTypes[i].getName().equalsIgnoreCase(xmlName)) {
                return this.propertyTypes[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public IElementDefn getStyle() {
        return this.style;
    }

    public static void reset() {
        instance = new MetaDataDictionary();
        MetaDataDictionary.releaseExtension();
    }

    void addElementDefn(ElementDefn type) throws MetaDataException {
        String name = type.getName();
        if (StringUtil.isBlank(name)) {
            throw new MetaDataException("MISSING_ELEMENT_NAME");
        }
        if (this.elementNameMap.containsKey(name)) {
            throw new MetaDataException(new String[]{name}, "DUPLICATE_ELEMENT_NAME");
        }
        this.elementNameMap.put(name, type);
    }

    @Override
    public void enableElementID() {
        this.useElementID = true;
    }

    @Override
    public boolean useID() {
        return this.useElementID;
    }

    void addPredefinedStyle(PredefinedStyle style) throws MetaDataException {
        String name = style.getName();
        if (StringUtil.isBlank(name)) {
            throw new MetaDataException("MISSING_STYLE_NAME");
        }
        String key = name.toLowerCase();
        if (this.predefinedStyles.get(key) != null) {
            throw new MetaDataException(new String[]{name}, "DUPLICATE_STYLE_NAME");
        }
        this.predefinedStyles.put(key, style);
        String type = style.getType();
        if (!StringUtil.isBlank(type)) {
            List<IPredefinedStyle> styles = this.predefinedStyleTypes.get(type);
            if (styles == null) {
                styles = new ArrayList<IPredefinedStyle>();
                this.predefinedStyleTypes.put(type, styles);
            }
            if (!styles.contains(style)) {
                styles.add(style);
            }
        }
    }

    public IPredefinedStyle getPredefinedStyle(String name) {
        if (StringUtil.isBlank(name)) {
            return null;
        }
        String key = name.toLowerCase();
        return this.predefinedStyles.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.elementNameMap.isEmpty() && this.predefinedStyles.isEmpty();
    }

    void addChoiceSet(ChoiceSet choiceSet) throws MetaDataException {
        String name = choiceSet.getName();
        if (StringUtil.isBlank(name)) {
            throw new MetaDataException("MISSING_CHOICE_SET_NAME");
        }
        if (this.choiceSets.containsKey(name)) {
            throw new MetaDataException(new String[]{name}, "DUPLICATE_CHOICE_SET_NAME");
        }
        this.choiceSets.put(name, choiceSet);
    }

    @Override
    public IChoiceSet getChoiceSet(String choiceSetName) {
        String newName = choiceSetName;
        if ("aggregationFunction".equalsIgnoreCase(newName)) {
            newName = "aggregationFunction";
        }
        return this.choiceSets.get(newName);
    }

    void addStructure(StructureDefn struct) throws MetaDataException {
        String name = struct.getName();
        if (StringUtil.isBlank(name)) {
            throw new MetaDataException("MISSING_STRUCT_NAME");
        }
        if (this.structures.containsKey(name)) {
            throw new MetaDataException(new String[]{name}, "DUPLICATE_STRUCT_NAME");
        }
        this.structures.put(name, struct);
    }

    @Override
    public IStructureDefn getStructure(String name) {
        return this.structures.get(name);
    }

    @Override
    public List<IElementDefn> getElements() {
        return new ArrayList<IElementDefn>(this.elementNameMap.values());
    }

    @Override
    public List<IStructureDefn> getStructures() {
        return new ArrayList<IStructureDefn>(this.structures.values());
    }

    @Override
    public List<IPredefinedStyle> getPredefinedStyles() {
        return new ArrayList<IPredefinedStyle>(this.predefinedStyles.values());
    }

    @Override
    public List<IClassInfo> getClasses() {
        return new ArrayList<IClassInfo>(this.classes.values());
    }

    @Override
    public IClassInfo getClass(String name) {
        return this.classes.get(name);
    }

    void addClass(ClassInfo classDefn) throws MetaDataException {
        if (StringUtil.isBlank(classDefn.getName())) {
            throw new MetaDataException("MISSING_CLASS_NAME");
        }
        if (this.classes.get(classDefn.getName()) != null) {
            throw new MetaDataException(new String[]{classDefn.getName()}, "DUPLICATE_CLASS_NAME");
        }
        this.classes.put(classDefn.getName(), classDefn);
    }

    @Override
    public List<IElementDefn> getExtensions() {
        return ExtensionManager.getInstance().getExtensions();
    }

    @Override
    public IElementDefn getExtension(String name) {
        return ExtensionManager.getInstance().getElement(name);
    }

    void addExtension(ExtensionElementDefn extDefn) throws MetaDataException {
        ExtensionManager.getInstance().addExtension(extDefn);
    }

    public void cacheOdaExtension(String extensionID, ExtensionElementDefn extDefn) throws MetaDataException {
        ExtensionManager.getInstance().cacheOdaExtension(extensionID, extDefn);
    }

    void addValueValidator(IValueValidator validator) throws MetaDataException {
        String name = validator.getName();
        if (StringUtil.isBlank(name)) {
            throw new MetaDataException("MISSING_VALIDATOR_NAME");
        }
        if (this.valueValidators.containsKey(name)) {
            throw new MetaDataException(new String[]{name}, "DUPLICATE_VALIDATOR_NAME");
        }
        this.valueValidators.put(name, validator);
    }

    public IValueValidator getValueValidator(String name) {
        return this.valueValidators.get(name);
    }

    public void addSemanticValidator(AbstractSemanticValidator validator) throws MetaDataException {
        String name = validator.getName();
        if (StringUtil.isBlank(name)) {
            throw new MetaDataException("MISSING_VALIDATOR_NAME");
        }
        if (this.semanticValidators.containsKey(name)) {
            throw new MetaDataException(new String[]{name}, "DUPLICATE_VALIDATOR_NAME");
        }
        this.semanticValidators.put(name, validator);
    }

    public AbstractSemanticValidator getSemanticValidator(String name) {
        return this.semanticValidators.get(name);
    }

    public boolean useValidationTrigger() {
        return this.useValidationTrigger;
    }

    public void setUseValidationTrigger(boolean useValidationTrigger) {
        this.useValidationTrigger = useValidationTrigger;
    }

    public IEncryptionHelper getEncryptionHelper(String id) {
        return ExtensionManager.getInstance().getEncryptionHelper(id);
    }

    public List<IEncryptionHelper> getEncryptionHelpers() {
        return ExtensionManager.getInstance().getEncryptionHelpers();
    }

    public IEncryptionHelper getDefaultEncryptionHelper() {
        return ExtensionManager.getInstance().getDefaultEncryptionHelper();
    }

    public String getDefaultEncryptionHelperID() {
        return ExtensionManager.getInstance().getDefaultEncryptionHelperID();
    }

    public void setDefaultEncryptionHelper(String encryptionID) {
        ExtensionManager.getInstance().setDefaultEncryptionHelper(encryptionID);
    }

    void addEncryptionHelper(String id, IEncryptionHelper encryptionHelper) throws MetaDataException {
        ExtensionManager.getInstance().addEncryptionHelper(id, encryptionHelper);
    }

    public IScriptableObjectClassInfo getScriptableFactory() {
        return ExtensionManager.getInstance().getScriptableFactory();
    }

    void setScriptableFactory(IScriptableObjectClassInfo scriptableFactory) {
        ExtensionManager.getInstance().setScriptableFactory(scriptableFactory);
    }

    public List<Style> getExtensionFactoryStyles() {
        return ExtensionManager.getInstance().getExtensionFactoryStyles();
    }

    void addExtensionFactoryStyle(Style style) {
        ExtensionManager.getInstance().addExtensionFactoryStyle(style);
    }

    @Override
    public List<IMethodInfo> getFunctions() {
        if (this.functions == null) {
            this.functions = new LinkedHashMap<String, IMethodInfo>();
            ArrayList<String> names = new ArrayList<String>();
            IChoice[] choices = this.getChoiceSet("aggregationFunction").getChoices();
            int i = 0;
            while (i < choices.length) {
                IChoice choice = choices[i];
                names.add(choice.getName());
                ++i;
            }
            IClassInfo clazz = this.getClass("Total");
            MetaDataDictionary.addMatchedFunctions(this.functions, clazz.getMethods(), names);
            names.clear();
        }
        assert (this.functions != null);
        ArrayList<IMethodInfo> retList = new ArrayList<IMethodInfo>();
        retList.addAll(this.functions.values());
        return retList;
    }

    private static void addMatchedFunctions(Map<String, IMethodInfo> methods, List<IMethodInfo> clazzMethods, List<String> names) {
        int i = 0;
        while (i < clazzMethods.size()) {
            IMethodInfo info = clazzMethods.get(i);
            if (names.contains(info.getName())) {
                methods.put(info.getName(), info);
            }
            ++i;
        }
    }

    public static void releaseExtension() {
        ExtensionManager.releaseInstance();
        isiniatializedExtensionManager = false;
    }

    public boolean isIntializedExtension() {
        return isiniatializedExtensionManager;
    }

    public static void intializeExtension() {
        ExtensionManager.getInstance().initialize();
        isiniatializedExtensionManager = true;
    }

    @Override
    public List<IPredefinedStyle> getPredefinedStyles(String type) {
        if (this.predefinedStyleTypes == null || type == null) {
            return Collections.emptyList();
        }
        List<IPredefinedStyle> styles = this.predefinedStyleTypes.get(type);
        if (styles == null) {
            return Collections.emptyList();
        }
        return styles;
    }

    @Override
    public List<String> getReportItemThemeTypes() {
        if (this.predefinedStyleTypes == null || this.predefinedStyleTypes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> types = new ArrayList<String>();
        types.addAll(this.predefinedStyleTypes.keySet());
        return types;
    }
}

