/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedBundles {
    private Map<String, LocaleResourceBundle> bundles;

    CachedBundles() {
    }

    String getMessage(String fileName, String resourceKey) {
        if (this.bundles == null) {
            return null;
        }
        LocaleResourceBundle tmpBundle = this.bundles.get(fileName);
        if (tmpBundle == null) {
            return null;
        }
        return tmpBundle.getMessage(resourceKey);
    }

    Set<String> getMessageKeys(String fileName) {
        if (this.bundles == null) {
            return null;
        }
        LocaleResourceBundle tmpBundle = this.bundles.get(fileName);
        if (tmpBundle == null) {
            return null;
        }
        return tmpBundle.getMessageKeys();
    }

    boolean isCached(String fileName) {
        if (this.bundles == null) {
            return false;
        }
        return this.bundles.containsKey(fileName);
    }

    void addCachedBundle(String fileName, URL bundleURL) {
        assert (fileName != null);
        if (this.bundles == null) {
            this.bundles = new HashMap<String, LocaleResourceBundle>(8);
        }
        if (bundleURL == null) {
            this.bundles.put(fileName, new LocaleResourceBundle(null));
        } else {
            this.bundles.put(fileName, new LocaleResourceBundle(CachedBundles.populateBundle(bundleURL)));
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PropertyResourceBundle populateBundle(URL bundleURL) {
        InputStream is;
        block17: {
            is = null;
            if (bundleURL != null) break block17;
            if (is == null) return null;
            try {
                is.close();
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        is = bundleURL.openStream();
        PropertyResourceBundle bundle = new PropertyResourceBundle(is);
        is.close();
        is = null;
        PropertyResourceBundle propertyResourceBundle = bundle;
        if (is == null) return propertyResourceBundle;
        try {
            is.close();
            return propertyResourceBundle;
        }
        catch (IOException iOException) {
            return propertyResourceBundle;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (is == null) return null;
            try {
                is.close();
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        catch (IOException iOException) {
            if (is == null) return null;
            {
                catch (Throwable throwable) {
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException iOException2) {
                        is = null;
                    }
                    throw throwable;
                }
            }
            try {
                is.close();
                return null;
            }
            catch (IOException iOException3) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocaleResourceBundle {
        private PropertyResourceBundle bundle;

        LocaleResourceBundle(PropertyResourceBundle bundle) {
            this.bundle = bundle;
        }

        private String getMessage(String resourceKey) {
            if (this.bundle == null) {
                return null;
            }
            String translation = (String)this.bundle.handleGetObject(resourceKey);
            if (translation != null) {
                return translation;
            }
            return null;
        }

        private Set<String> getMessageKeys() {
            if (this.bundle == null) {
                return Collections.emptySet();
            }
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            Enumeration<String> enumeration = this.bundle.getKeys();
            while (enumeration.hasMoreElements()) {
                keys.add(enumeration.nextElement());
            }
            return keys;
        }
    }
}

