/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ThemeException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ReportItemTheme;
import org.eclipse.birt.report.model.elements.interfaces.ISupportThemeElement;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeReferenceValidator
extends AbstractElementValidator {
    public static final String NAME = "ThemeReferenceValidator";
    private static final ThemeReferenceValidator instance = new ThemeReferenceValidator();

    public static ThemeReferenceValidator getInstance() {
        return instance;
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement element) {
        if (!(element instanceof ISupportThemeElement) && module != element) {
            return Collections.emptyList();
        }
        if (element instanceof Module) {
            ArrayList<SemanticException> list = new ArrayList<SemanticException>();
            String themeName = module.getThemeName();
            if (!StringUtil.isEmpty(themeName) && module.getTheme(module) == null) {
                list.add(new ThemeException((DesignElement)module, themeName, "Error.ThemeException.NOT_FOUND"));
            }
            return list;
        }
        if (element instanceof ReportItem) {
            return this.doValidate(module, (ReportItem)element);
        }
        assert (false);
        return Collections.emptyList();
    }

    private List<SemanticException> doValidate(Module module, ReportItem element) {
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        String themeName = element.getThemeName();
        if (!StringUtil.isEmpty(themeName) && element.getTheme(module) == null) {
            list.add(new ThemeException((DesignElement)module, themeName, "Error.ThemeException.NOT_FOUND"));
        } else {
            ReportItemTheme theme = (ReportItemTheme)element.getTheme(module);
            if (theme != null && !element.getDefn().getName().equals(theme.getType(theme.getRoot()))) {
                list.add(new ThemeException((DesignElement)element, themeName, "Error.ThemeException.WRONG_TYPE"));
            }
        }
        return list;
    }
}

