/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site.compatibility;

import org.eclipse.pde.internal.build.site.compatibility.IPlatformEntry;

public class FeatureEntry
implements IPlatformEntry {
    private final String id;
    private final String version;
    private String url;
    private String os;
    private String ws;
    private String arch;
    private String nl;
    private String match;
    private final boolean isPlugin;
    private boolean isFragment = false;
    private boolean isRequires = false;
    private Boolean unpack = null;
    private boolean optional = false;
    private String filter;

    public static FeatureEntry createRequires(String id, String version, String match, String filter, boolean isPlugin) {
        FeatureEntry result = new FeatureEntry(id, version, isPlugin);
        result.match = match;
        result.isRequires = true;
        if (filter != null) {
            result.setFilter(filter);
        }
        return result;
    }

    public FeatureEntry(String id, String version, boolean isPlugin) {
        this.id = id;
        this.version = version;
        this.isPlugin = isPlugin;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String value) {
        this.url = value;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isPlugin() {
        return this.isPlugin;
    }

    public boolean isRequires() {
        return this.isRequires;
    }

    public boolean isFragment() {
        return this.isFragment;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.isPlugin ? "Plugin: " : "Feature: ");
        result.append(this.id != null ? this.id.toString() : "");
        result.append(this.version != null ? " " + this.version.toString() : "");
        return result.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureEntry other = (FeatureEntry)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public void setEnvironment(String os, String ws, String arch, String nl) {
        this.os = os;
        this.ws = ws;
        this.arch = arch;
        this.nl = nl;
    }

    public void setFragment(boolean value) {
        this.isFragment = value;
    }

    public void setUnpack(boolean value) {
        this.unpack = value;
    }

    public boolean isUnpack() {
        return this.unpack == null || this.unpack != false;
    }

    public boolean unpackSet() {
        return this.unpack != null;
    }

    public void setOptional(boolean value) {
        this.optional = value;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getMatch() {
        return this.match;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getOS() {
        return this.os;
    }

    public String getWS() {
        return this.ws;
    }

    public String getArch() {
        return this.arch;
    }

    public String getNL() {
        return this.nl;
    }
}

