/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.internal.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class SaveDDLUtility {
    private static final String DDL_FILE_EXTENSION = "sql";
    private static final String ALTERNATE_DDL_FILE_EXTENSION = "ddl";
    private static final SaveDDLUtility save = new SaveDDLUtility();

    private SaveDDLUtility() {
    }

    public static SaveDDLUtility getInstance() {
        return save;
    }

    private IFile shouldSaveAsResource(String filename) {
        if (filename != null) {
            Path thePath = new Path(filename);
            IFile theFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)thePath);
            return theFile;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IFile saveDDLFileAsResource(StringWriter out, String filename) {
        Path thePath = new Path(filename);
        if (thePath.getFileExtension() == null || !thePath.getFileExtension().equalsIgnoreCase(DDL_FILE_EXTENSION) && !thePath.getFileExtension().equalsIgnoreCase(ALTERNATE_DDL_FILE_EXTENSION)) {
            thePath = thePath.addFileExtension(DDL_FILE_EXTENSION);
        }
        IFile theFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)thePath);
        ByteArrayOutputStream file = null;
        try {
            file = new ByteArrayOutputStream();
            String encoding = ResourcesPlugin.getEncoding();
            if (encoding != null && !encoding.equals("")) {
                file.write(out.toString().getBytes(encoding));
            } else {
                file.write(out.toString().getBytes());
            }
            this.saveDocumentAsResource(theFile, file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (file == null) return theFile;
            try {
                ((OutputStream)file).close();
                return theFile;
            }
            catch (IOException iOException) {}
            return theFile;
        }
        catch (IOException iOException) {
            try {
                if (file == null) return theFile;
            }
            catch (Throwable throwable) {
                if (file == null) throw throwable;
                try {
                    ((OutputStream)file).close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                ((OutputStream)file).close();
                return theFile;
            }
            catch (IOException iOException3) {}
            return theFile;
        }
        if (file == null) return theFile;
        try {
            ((OutputStream)file).close();
            return theFile;
        }
        catch (IOException iOException) {}
        return theFile;
    }

    /*
     * Unable to fully structure code
     */
    public void saveDDLFile(StringWriter out, String filename) {
        block21: {
            block20: {
                block18: {
                    block19: {
                        file = null;
                        if (this.shouldSaveAsResource(filename) != null) ** GOTO lbl19
                        newFile = new File(filename);
                        if (!newFile.exists() || newFile.canWrite() || this.makeCheckOut(filename)) break block18;
                        if (file == null) break block19;
                        try {
                            file.close();
                        }
                        catch (IOException v0) {}
                    }
                    return;
                }
                try {
                    file = new FileOutputStream(newFile);
                    file.write(out.toString().getBytes());
                    break block20;
lbl19:
                    // 1 sources

                    file = new ByteArrayOutputStream();
                    file.write(out.toString().getBytes());
                    this.saveDocumentAsResource(this.shouldSaveAsResource(filename), file);
                }
                catch (FileNotFoundException v1) {
                    if (file == null) ** GOTO lbl51
                    try {
                        file.close();
                    }
                    catch (IOException v2) {}
                }
                catch (IOException v3) {
                    try {
                        if (file == null) ** GOTO lbl51
                    }
                    catch (Throwable var5_5) {
                        if (file != null) {
                            try {
                                file.close();
                            }
                            catch (IOException v4) {}
                        }
                        throw var5_5;
                    }
                    try {
                        file.close();
                    }
                    catch (IOException v5) {}
                }
            }
            if (file == null) break block21;
            try {
                file.close();
            }
            catch (IOException v6) {}
        }
    }

    private void saveDocumentAsResource(IFile theFile, OutputStream writer) {
        block16: {
            if (theFile == null) {
                return;
            }
            InputStream input = null;
            try {
                try {
                    input = new ByteArrayInputStream(((ByteArrayOutputStream)writer).toByteArray());
                    if (theFile.exists()) {
                        if (theFile.isReadOnly()) {
                            theFile.setContents(input, true, true, null);
                        } else {
                            theFile.setContents(input, true, true, null);
                        }
                    } else {
                        theFile.create(input, false, null);
                    }
                }
                catch (Exception exception) {
                    try {
                        input.close();
                    }
                    catch (Exception exception2) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    private boolean makeCheckOut(String fileName) {
        return false;
    }
}

