/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.functionservice.impl;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.script.functionservice.IScriptFunction;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionCategory;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionContext;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.WrappedException;

public class CategoryWrapper
extends ScriptableObject {
    private static final long serialVersionUID = 1L;
    private IScriptFunctionCategory category;

    public CategoryWrapper(IScriptFunctionCategory category) throws BirtException {
        assert (category != null);
        this.category = category;
        IScriptFunction[] functions = category.getFunctions();
        int i = 0;
        while (i < functions.length) {
            final IScriptFunction function = functions[i];
            this.defineProperty(functions[i].getName(), new BaseFunction(){
                private static final long serialVersionUID = 1L;

                public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                    Object[] convertedArgs = JavascriptEvalUtil.convertToJavaObjects(args);
                    try {
                        return function.execute(convertedArgs, this.getIScriptFunctionContext(scope));
                    }
                    catch (BirtException e) {
                        throw new WrappedException((Throwable)e);
                    }
                }

                private IScriptFunctionContext getIScriptFunctionContext(Scriptable scope) {
                    if (scope == null) {
                        return null;
                    }
                    Object obj = scope.get("org.eclipse.birt.core.script.functionservice.context.functionBean", scope);
                    if (obj == UniqueTag.NOT_FOUND) {
                        return this.getIScriptFunctionContext(scope.getParentScope());
                    }
                    return (IScriptFunctionContext)JavascriptEvalUtil.convertJavascriptValue(obj);
                }
            }, 0);
            ++i;
        }
    }

    public String getClassName() {
        return this.category.getName();
    }
}

