/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.util.EventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IManagedConnectionListener;
import org.eclipse.datatools.connectivity.IManagedConnectionOfflineListener;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.jpt.db.ConnectionListener;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.DatabaseIdentifierAdapter;
import org.eclipse.jpt.db.internal.DTPCatalogWrapper;
import org.eclipse.jpt.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.db.internal.DTPDatabaseObject;
import org.eclipse.jpt.db.internal.DTPDatabaseWrapper;
import org.eclipse.jpt.db.internal.DTPForeignKeyWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaWrapper;
import org.eclipse.jpt.db.internal.DTPSequenceWrapper;
import org.eclipse.jpt.db.internal.DTPTableWrapper;
import org.eclipse.jpt.utility.internal.ListenerList;
import org.eclipse.jpt.utility.internal.StringTools;

final class DTPConnectionProfileWrapper
implements DTPDatabaseObject,
ConnectionProfile {
    private final IConnectionProfile dtpConnectionProfile;
    private final DatabaseIdentifierAdapter identifierAdapter;
    private final DatabaseIdentifierAdapter.DefaultCallback identifierAdapterCallback;
    private final IManagedConnection dtpManagedConnection;
    private final LocalConnectionListener connectionListener;
    private DTPDatabaseWrapper database;
    private static final String LIVE_DTP_CONNECTION_TYPE = "java.sql.Connection";
    private static final String OFFLINE_DTP_CONNECTION_TYPE = ConnectionInfo.class.getName();
    private static final String DATABASE_PRODUCT_PROP_ID = "org.eclipse.datatools.connectivity.server.version";

    DTPConnectionProfileWrapper(IConnectionProfile dtpConnectionProfile, DatabaseIdentifierAdapter adapter) {
        this.dtpConnectionProfile = dtpConnectionProfile;
        this.identifierAdapter = adapter;
        this.identifierAdapterCallback = new IdentifierAdapterCallback();
        this.dtpManagedConnection = this.buildDTPManagedConnection();
        this.connectionListener = new LocalConnectionListener();
    }

    private IManagedConnection buildDTPManagedConnection() {
        String connectionType = this.dtpConnectionProfile.supportsWorkOfflineMode() ? OFFLINE_DTP_CONNECTION_TYPE : LIVE_DTP_CONNECTION_TYPE;
        return this.dtpConnectionProfile.getManagedConnection(connectionType);
    }

    public String getName() {
        return this.dtpConnectionProfile.getName();
    }

    public String getIdentifier(String javaIdentifier) {
        throw new UnsupportedOperationException();
    }

    public String getIdentifier() {
        throw new UnsupportedOperationException();
    }

    public DTPConnectionProfileWrapper getConnectionProfile() {
        return this;
    }

    public synchronized DTPDatabaseWrapper getDatabase() {
        if (this.database == null) {
            this.database = this.buildDatabase();
        }
        return this.database;
    }

    public String getProviderID() {
        return this.dtpConnectionProfile.getProviderId();
    }

    public String getInstanceID() {
        return this.dtpConnectionProfile.getInstanceID();
    }

    public String getDatabaseName() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.databaseName");
    }

    public String getDatabaseProduct() {
        return this.getProperty(DATABASE_PRODUCT_PROP_ID);
    }

    public String getDatabaseVendor() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.vendor");
    }

    public String getDatabaseVersion() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.version");
    }

    public String getDriverClassName() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.driverClass");
    }

    public String getURL() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.URL");
    }

    public String getUserName() {
        String userName = this.getProperty("org.eclipse.datatools.connectivity.db.username");
        String[] names = (userName = userName.trim()).split("\\s+");
        if (names.length == 3 && this.nameIsKeyword(names[1])) {
            return names[0];
        }
        return userName;
    }

    public String getUserPassword() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.password");
    }

    public String getDriverDefinitionID() {
        return this.getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
    }

    public String getDriverJarList() {
        return DriverManager.getInstance().getDriverInstanceByID(this.getDriverDefinitionID()).getJarList();
    }

    public String getDriverName() {
        return DriverManager.getInstance().getDriverInstanceByID(this.getDriverDefinitionID()).getName();
    }

    public boolean isActive() {
        return this.isConnected() || this.isWorkingOffline();
    }

    public boolean isInactive() {
        return !this.isActive();
    }

    public boolean isConnected() {
        return this.dtpManagedConnection.isConnected() && !this.dtpManagedConnection.isWorkingOffline();
    }

    public boolean isDisconnected() {
        return !this.isConnected();
    }

    public void connect() {
        if (this.isDisconnected()) {
            this.checkStatus(this.dtpConnectionProfile.connect());
        }
    }

    public void disconnect() {
        this.checkStatus(this.dtpConnectionProfile.disconnect());
    }

    public boolean isWorkingOffline() {
        return this.dtpManagedConnection.isWorkingOffline();
    }

    public boolean supportsWorkOfflineMode() {
        return this.dtpConnectionProfile.supportsWorkOfflineMode();
    }

    public IStatus saveWorkOfflineData() {
        return this.dtpConnectionProfile.saveWorkOfflineData();
    }

    public boolean canWorkOffline() {
        return this.dtpConnectionProfile.canWorkOffline();
    }

    public IStatus workOffline() {
        return this.dtpConnectionProfile.workOffline();
    }

    public synchronized void addConnectionListener(ConnectionListener listener) {
        if (this.hasNoListeners()) {
            this.startListening();
        }
        this.connectionListener.addConnectionListener(listener);
    }

    private void startListening() {
        this.dtpManagedConnection.addConnectionListener((IManagedConnectionListener)this.connectionListener);
        if (this.database != null && this.isConnected()) {
            this.database.startListening();
        }
    }

    public synchronized void removeConnectionListener(ConnectionListener listener) {
        this.connectionListener.removeConnectionListener(listener);
        if (this.hasNoListeners()) {
            this.stopListening();
        }
    }

    private void stopListening() {
        if (this.database != null && this.isConnected()) {
            this.database.stopListening();
        }
        this.dtpManagedConnection.removeConnectionListener((IManagedConnectionListener)this.connectionListener);
    }

    boolean hasNoListeners() {
        return this.connectionListener.hasNoListeners();
    }

    boolean hasAnyListeners() {
        return this.connectionListener.hasAnyListeners();
    }

    private void checkStatus(IStatus status) {
        if (status.isOK()) {
            return;
        }
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.checkStatus(child);
                ++n2;
            }
        }
        throw new RuntimeException(status.getMessage(), status.getException());
    }

    private DTPDatabaseWrapper buildDatabase() {
        if (this.isInactive()) {
            return null;
        }
        if (this.isWorkingOffline()) {
            ConnectionInfo connectionInfo = (ConnectionInfo)this.dtpManagedConnection.getConnection().getRawConnection();
            return new DTPDatabaseWrapper(this, connectionInfo.getSharedDatabase());
        }
        return new DTPDatabaseWrapper(this, ProfileUtil.getDatabase((DatabaseIdentifier)new DatabaseIdentifier(this.getName(), this.getDatabaseName()), (boolean)true));
    }

    synchronized void clearDatabase() {
        if (this.database != null) {
            if (this.isConnected()) {
                this.database.stopListening();
            }
            this.database = null;
        }
    }

    String convertIdentifierToName(String identifier) {
        return this.identifierAdapter.convertIdentifierToName(identifier, this.identifierAdapterCallback);
    }

    String convertIdentifierToName_(String identifier) {
        return this.database.convertIdentifierToName_(identifier);
    }

    String convertNameToIdentifier(String name) {
        return this.identifierAdapter.convertNameToIdentifier(name, this.identifierAdapterCallback);
    }

    String convertNameToIdentifier_(String name) {
        return this.database.convertNameToIdentifier_(name);
    }

    void databaseChanged(DTPDatabaseWrapper db) {
        this.connectionListener.databaseChanged(db);
    }

    void catalogChanged(DTPCatalogWrapper catalog) {
        this.connectionListener.catalogChanged(catalog);
    }

    void schemaChanged(DTPSchemaWrapper schema) {
        this.connectionListener.schemaChanged(schema);
    }

    void sequenceChanged(DTPSequenceWrapper sequence) {
        this.connectionListener.sequenceChanged(sequence);
    }

    void tableChanged(DTPTableWrapper table) {
        this.connectionListener.tableChanged(table);
    }

    void columnChanged(DTPColumnWrapper column) {
        this.connectionListener.columnChanged(column);
    }

    void foreignKeyChanged(DTPForeignKeyWrapper foreignKey) {
        this.connectionListener.foreignKeyChanged(foreignKey);
    }

    private String getProperty(String propertyName) {
        return this.dtpConnectionProfile.getBaseProperties().getProperty(propertyName);
    }

    private boolean nameIsKeyword(String name) {
        return name.equalsIgnoreCase("as");
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.getName());
    }

    class IdentifierAdapterCallback
    implements DatabaseIdentifierAdapter.DefaultCallback {
        IdentifierAdapterCallback() {
        }

        public String convertIdentifierToName(String identifier) {
            return DTPConnectionProfileWrapper.this.convertIdentifierToName_(identifier);
        }

        public String convertNameToIdentifier(String name) {
            return DTPConnectionProfileWrapper.this.convertNameToIdentifier_(name);
        }
    }

    class LocalConnectionListener
    implements IManagedConnectionOfflineListener {
        private ListenerList<ConnectionListener> listenerList = new ListenerList(ConnectionListener.class);

        LocalConnectionListener() {
        }

        void addConnectionListener(ConnectionListener listener) {
            this.listenerList.add((EventListener)listener);
        }

        void removeConnectionListener(ConnectionListener listener) {
            this.listenerList.remove((EventListener)listener);
        }

        boolean hasNoListeners() {
            return this.listenerList.isEmpty();
        }

        boolean hasAnyListeners() {
            return !this.listenerList.isEmpty();
        }

        public void opened(ConnectEvent event) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.opened(DTPConnectionProfileWrapper.this);
            }
        }

        public void modified(ConnectEvent event) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.modified(DTPConnectionProfileWrapper.this);
            }
        }

        public boolean okToClose(ConnectEvent event) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                if (listener.okToClose(DTPConnectionProfileWrapper.this)) continue;
                return false;
            }
            return true;
        }

        public void aboutToClose(ConnectEvent event) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.aboutToClose(DTPConnectionProfileWrapper.this);
            }
        }

        public void closed(ConnectEvent event) {
            DTPConnectionProfileWrapper.this.clearDatabase();
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.closed(DTPConnectionProfileWrapper.this);
            }
        }

        public boolean okToDetach(ConnectEvent event) {
            return this.okToClose(event);
        }

        public void aboutToDetach(ConnectEvent event) {
            this.closed(event);
        }

        public void workingOffline(ConnectEvent event) {
            this.opened(event);
        }

        public void aboutToAttach(ConnectEvent event) {
            this.closed(event);
        }

        void databaseChanged(DTPDatabaseWrapper db) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.databaseChanged(DTPConnectionProfileWrapper.this, db);
            }
        }

        void catalogChanged(DTPCatalogWrapper catalog) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.catalogChanged(DTPConnectionProfileWrapper.this, catalog);
            }
        }

        void schemaChanged(DTPSchemaWrapper schema) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.schemaChanged(DTPConnectionProfileWrapper.this, schema);
            }
        }

        void sequenceChanged(DTPSequenceWrapper sequence) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.sequenceChanged(DTPConnectionProfileWrapper.this, sequence);
            }
        }

        void tableChanged(DTPTableWrapper table) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.tableChanged(DTPConnectionProfileWrapper.this, table);
            }
        }

        void columnChanged(DTPColumnWrapper column) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.columnChanged(DTPConnectionProfileWrapper.this, column);
            }
        }

        void foreignKeyChanged(DTPForeignKeyWrapper foreignKey) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.foreignKeyChanged(DTPConnectionProfileWrapper.this, foreignKey);
            }
        }
    }
}

