/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal.publishers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.generic.core.internal.CorePlugin;
import org.eclipse.jst.server.generic.core.internal.GenericPublisher;
import org.eclipse.jst.server.generic.core.internal.GenericServerBehaviour;
import org.eclipse.jst.server.generic.core.internal.GenericServerCoreMessages;
import org.eclipse.jst.server.generic.core.internal.Trace;
import org.eclipse.jst.server.generic.core.internal.publishers.AbstractModuleAssembler;
import org.eclipse.jst.server.generic.internal.core.util.FileUtil;
import org.eclipse.jst.server.generic.servertype.definition.Module;
import org.eclipse.jst.server.generic.servertype.definition.PublisherData;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.osgi.framework.Bundle;

public class AntPublisher
extends GenericPublisher {
    private static final String ATTR_LOCATION = "org.eclipse.ui.externaltools.ATTR_LOCATION";
    private static final String REMOTE_ANT_PROCESS_FACTORY_ID = "org.eclipse.ant.ui.remoteAntProcessFactory";
    private static final String JAR_PROTOCOL_PREFIX = "jar";
    public static final String PUBLISHER_ID = "org.eclipse.jst.server.generic.antpublisher";
    protected static final String PROP_SERVER_PUBLISH_DIR = "server.publish.dir";
    protected static final String PROP_PROJECT_WORKING_DIR = "project.working.dir";
    protected static final String PROP_MODULE_DIR = "module.dir";
    protected static final String PROP_MODULE_NAME = "module.name";
    protected static final String PROP_CONTEXT_ROOT = "contextRoot";
    protected static final String PROP_PROJECT_NAME = "project.name";
    protected static final String PROP_PROJECT_LOCATION = "project.location";
    protected static final String MODULE_PUBLISH_TARGET_PREFIX = "target.publish.";
    protected static final String MODULE_UNPUBLISH_TARGET_PREFIX = "target.unpublish.";
    protected static final String DATA_NAME_BUILD_FILE = "build.file";
    protected static final String PROP_MODULE_ARCHIVE_NAME = "module.archive.name";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public IStatus[] publish(IModuleArtifact[] resource, IProgressMonitor monitor) {
        if (this.getModule().length > 1 || !this.publishNeeded() || monitor.isCanceled()) {
            return null;
        }
        try {
            this.assembleModule(monitor);
            File file = this.getCustomBuildFile();
            if (file == null) {
                file = this.computeBuildFile();
            }
            this.runAnt(file.toString(), this.getPublishTargetsForModule(), this.getPublishProperties(), monitor);
        }
        catch (CoreException e) {
            Status s = new Status(4, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.errorPublishAntpublisher, (Throwable)e);
            CorePlugin.getDefault().getLog().log((IStatus)s);
            return new IStatus[]{s};
        }
        return null;
    }

    private boolean publishNeeded() {
        if (this.getKind() != 1 && this.getKind() != 3) {
            return true;
        }
        if (this.getDeltaKind() != 0) {
            return true;
        }
        if (AntPublisher.isModuleType(this.getModule()[0], "jst.ear")) {
            IModule iModule = this.getModule()[0];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.server.core.IEnterpriseApplication");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IEnterpriseApplication earModule = (IEnterpriseApplication)iModule.loadAdapter((Class)clazz, (IProgressMonitor)new NullProgressMonitor());
            IModule[] childModules = earModule.getModules();
            int i = 0;
            while (i < childModules.length) {
                IModule module = childModules[i];
                IModule[] modules = new IModule[]{this.getModule()[0], module};
                if (1 != this.getServer().getServer().getModulePublishState(modules)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void assembleModule(IProgressMonitor monitor) throws CoreException {
        long time = System.currentTimeMillis();
        AbstractModuleAssembler assembler = AbstractModuleAssembler.Factory.getModuleAssembler(this.getModule()[0], this.getServer());
        assembler.assemble(monitor);
        Trace.trace((byte)5, "AntPublisher.assembleModule(): <" + (System.currentTimeMillis() - time) + "ms> module: " + this.getModule()[0]);
    }

    private File getCustomBuildFile() throws CoreException {
        String filename = (String)this.getServer().getServerInstanceProperties().get("org.eclipse.jst.server.generic.core.custom_build_file");
        if (filename != null && filename.length() > 0) {
            filename = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(filename);
            File file = new File(filename);
            if (!file.exists()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.generic.core", "Selected build file does not exist."));
            }
            return file;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File computeBuildFile() throws CoreException {
        File file;
        Bundle bundle = Platform.getBundle((String)this.getServerRuntime().getServerTypeDefinition().getConfigurationElementNamespace());
        URL bundleUrl = bundle.getEntry(this.getBuildFile());
        URL fileURL = FileUtil.resolveURL(bundleUrl);
        if (!fileURL.getProtocol().equals(JAR_PROTOCOL_PREFIX)) return FileUtil.resolveFile(fileURL);
        OutputStream os = null;
        InputStream is = null;
        try {
            try {
                String filename = fileURL.getPath();
                String jarname = fileURL.getFile().substring(0, filename.indexOf(33));
                File jarFile = new File(new URL(jarname).getFile());
                JarFile jar = new JarFile(jarFile);
                File tmpFile = FileUtil.createTempFile(this.getBuildFile(), CorePlugin.getDefault().getStateLocation().toOSString());
                os = new FileOutputStream(tmpFile);
                String entryname = this.getBuildFile();
                if (entryname.startsWith("/")) {
                    entryname = entryname.substring(1);
                }
                JarEntry entry = jar.getJarEntry(entryname);
                is = jar.getInputStream(entry);
                FileUtil.copy(is, os);
                file = tmpFile;
                Object var13_16 = null;
            }
            catch (IOException e) {
                Status s = new Status(4, "org.eclipse.jst.server.generic.core", 0, "error creating temporary build file", (Throwable)e);
                CorePlugin.getDefault().getLog().log((IStatus)s);
                throw new CoreException((IStatus)s);
            }
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            try {
                if (is != null) {
                    is.close();
                }
                if (os == null) throw throwable;
                os.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (is != null) {
            is.close();
        }
        if (os == null) return file;
        os.close();
        return file;
    }

    private String getPublishTargetsForModule() {
        return this.doGetTargets(MODULE_PUBLISH_TARGET_PREFIX + this.getModuleTypeId());
    }

    private String getUnpublishTargetsForModule() {
        return this.doGetTargets(MODULE_UNPUBLISH_TARGET_PREFIX + this.getModuleTypeId());
    }

    private String doGetTargets(String dataname) {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.getServerRuntime().getServerTypeDefinition().getPublisher(PUBLISHER_ID).getPublisherdata().iterator();
        while (iterator.hasNext()) {
            PublisherData data = (PublisherData)iterator.next();
            if (!dataname.equals(data.getDataname())) continue;
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(data.getDatavalue());
        }
        return buffer.toString();
    }

    private String getModuleTypeId() {
        return this.getModule()[0].getModuleType().getId();
    }

    private String getBuildFile() {
        Iterator iterator = this.getServerRuntime().getServerTypeDefinition().getPublisher(PUBLISHER_ID).getPublisherdata().iterator();
        while (iterator.hasNext()) {
            PublisherData data = (PublisherData)iterator.next();
            if (!DATA_NAME_BUILD_FILE.equals(data.getDataname())) continue;
            return this.getServerRuntime().getServerTypeDefinition().getResolver().resolveProperties(data.getDatavalue());
        }
        return null;
    }

    private Map getPublishProperties() {
        HashMap props = new HashMap();
        Map serverProperties = this.getServer().getServerInstanceProperties();
        Map properties = this.getServerRuntime().getServerInstanceProperties();
        properties.putAll(serverProperties);
        Iterator propertyIterator = properties.keySet().iterator();
        while (propertyIterator.hasNext()) {
            String property = (String)propertyIterator.next();
            String value = (String)properties.get(property);
            if (value == null || value.trim().length() <= 0) continue;
            props.put(property, properties.get(property));
        }
        Module module = this.getServerRuntime().getServerTypeDefinition().getModule(this.getModuleTypeId());
        String modDir = module.getPublishDir();
        modDir = this.getServerRuntime().getServerTypeDefinition().getResolver().resolveProperties(modDir);
        IModule webModule = this.getModule()[0];
        String moduleName = this.guessModuleName(webModule);
        String contextRoot = this.guessContextRoot(webModule);
        props.put(PROP_PROJECT_WORKING_DIR, this.getProjectWorkingLocation().toString());
        props.put(PROP_MODULE_NAME, moduleName);
        props.put(PROP_CONTEXT_ROOT, contextRoot);
        if (AntPublisher.isModuleType(webModule, "jst.ear")) {
            props.put(PROP_MODULE_ARCHIVE_NAME, String.valueOf(moduleName) + ".ear");
        } else if (AntPublisher.isModuleType(webModule, "jst.web")) {
            props.put(PROP_MODULE_ARCHIVE_NAME, String.valueOf(moduleName) + ".war");
        } else if (AntPublisher.isModuleType(webModule, "jst.ejb")) {
            props.put(PROP_MODULE_ARCHIVE_NAME, String.valueOf(moduleName) + ".jar");
        }
        if (webModule.getProject() != null) {
            props.put(PROP_MODULE_DIR, this.getModuleWorkingDir().toString());
            props.put(PROP_PROJECT_NAME, webModule.getProject().getName());
            props.put(PROP_PROJECT_LOCATION, webModule.getProject().getLocation().toString());
        }
        props.put(PROP_SERVER_PUBLISH_DIR, modDir);
        return props;
    }

    private IPath getModuleWorkingDir() {
        return this.getProjectWorkingLocation().append(this.getModule()[0].getProject().getName());
    }

    private IPath getProjectWorkingLocation() {
        IServer iServer = this.getServer().getServer();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.server.core.model.ServerBehaviourDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericServerBehaviour genericServer = (GenericServerBehaviour)((Object)iServer.loadAdapter((Class)clazz, (IProgressMonitor)new NullProgressMonitor()));
        return genericServer.getTempDirectory();
    }

    private String guessModuleName(IModule module) {
        String moduleName = module.getName();
        if ("jst.web".equals(this.getModuleTypeId())) {
            IWebModule webModule;
            IModule iModule = this.getModule()[0];
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.jst.server.core.IWebModule");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((webModule = (IWebModule)iModule.loadAdapter((Class)clazz, null)) == null) {
                return module.getName();
            }
            String contextRoot = webModule.getURI(module);
            moduleName = contextRoot.substring(0, contextRoot.lastIndexOf(46));
        }
        return moduleName;
    }

    private String guessContextRoot(IModule module) {
        String moduleName;
        String contextRoot = moduleName = this.guessModuleName(module);
        if ("jst.web".equals(this.getModuleTypeId())) {
            IWebModule webModule;
            IModule iModule = this.getModule()[0];
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.jst.server.core.IWebModule");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((webModule = (IWebModule)iModule.loadAdapter((Class)clazz, null)) != null && ((contextRoot = webModule.getContextRoot()) == null || contextRoot.length() == 0)) {
                contextRoot = moduleName;
            }
        }
        return contextRoot;
    }

    private void runAnt(String buildFile, String targets, Map properties, IProgressMonitor monitor) throws CoreException {
        long time = System.currentTimeMillis();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        if (type == null) {
            Status s = new Status(4, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.antLauncherMissing, null);
            throw new CoreException((IStatus)s);
        }
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, properties.get(PROP_MODULE_NAME) + " module publisher");
        wc.setContainer(null);
        wc.setAttribute(ATTR_LOCATION, buildFile);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", targets);
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", properties);
        wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        wc.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true);
        wc.setAttribute("org.eclipse.debug.ui.private", true);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
        IVMInstall vmInstall = this.getServerRuntime().getVMInstall();
        if (vmInstall == null) {
            vmInstall = JavaRuntime.getDefaultVMInstall();
        }
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, JavaRuntime.newJREContainerPath((IVMInstall)vmInstall).toPortableString());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.eclipse.ant.internal.ui.antsupport.InternalAntRunner");
        wc.setAttribute("process_factory_id", REMOTE_ANT_PROCESS_FACTORY_ID);
        this.setupAntLaunchConfiguration(wc);
        if (!monitor.isCanceled()) {
            ILaunchConfiguration launchConfig = wc.doSave();
            launchConfig.launch("run", monitor, false, true);
            Trace.trace((byte)5, "AntPublisher.runAnt():<" + (System.currentTimeMillis() - time) + "ms> module: " + this.getModule()[0]);
        }
    }

    protected void setupAntLaunchConfiguration(ILaunchConfigurationWorkingCopy wc) {
    }

    private static boolean isModuleType(IModule module, String moduleTypeId) {
        return module.getModuleType() != null && moduleTypeId.equals(module.getModuleType().getId());
    }

    public IStatus[] unpublish(IProgressMonitor monitor) {
        if (this.getModule().length > 1) {
            return null;
        }
        try {
            File file = this.computeBuildFile();
            this.runAnt(file.toString(), this.getUnpublishTargetsForModule(), this.getPublishProperties(), monitor);
        }
        catch (CoreException e) {
            Status s = new Status(4, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.errorRemoveModuleAntpublisher, (Throwable)e);
            return new IStatus[]{s};
        }
        return null;
    }
}

