/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.transport;

import java.io.IOException;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Connection;

public abstract class PacketManager
implements Runnable {
    private final Connection connection;
    private volatile Thread partnerThread;
    private volatile IOException disconnectedException;

    protected PacketManager(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("You cannot create a new PacketManager with a null Connection");
        }
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void disconnect(IOException exception) {
        this.disconnectedException = exception;
        this.disconnect();
    }

    public void disconnect() {
        try {
            this.connection.close();
        }
        catch (IOException e) {
            this.disconnectedException = e;
        }
        if (this.partnerThread != null) {
            this.partnerThread.interrupt();
        }
    }

    public boolean isDisconnected() {
        return this.connection == null || !this.connection.isOpen();
    }

    public IOException getDisconnectedException() {
        return this.disconnectedException;
    }

    public void setPartnerThread(Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException("You cannot send a null partner thread on the PacketManager");
        }
        this.partnerThread = thread;
    }
}

