/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import java.util.logging.Level;
import org.eclipse.birt.report.designer.internal.ui.command.CommandUtils;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;

public class ReloadCssStyleAction
extends AbstractViewAction {
    public static final String ID = "org.eclipse.birt.report.designer.internal.ui.views.actions.ReloadCssStylesAction";
    public static final String ACTION_TEXT = Messages.getString((String)"ReloadCssStylesAction.Action.Text");

    public ReloadCssStyleAction(Object selectedObject, String text) {
        super(selectedObject, text);
    }

    public ReloadCssStyleAction(Object selectedObject) {
        super(selectedObject, ACTION_TEXT);
    }

    public boolean isEnabled() {
        Object selection = this.getSelection();
        if (selection == null) {
            return false;
        }
        if (selection instanceof SlotHandle && ((SlotHandle)selection).getElementHandle() instanceof ReportDesignHandle) {
            selection = ((SlotHandle)selection).getElementHandle();
        }
        if (selection instanceof CssStyleSheetHandle) {
            return true;
        }
        if (selection instanceof ReportDesignHandle) {
            return ((ReportDesignHandle)selection).getAllCssStyleSheets().size() > 0;
        }
        if (selection instanceof ThemeHandle) {
            return ((ThemeHandle)selection).getAllCssStyleSheets().size() > 0;
        }
        return false;
    }

    public void run() {
        Object selection = this.getSelection();
        if (selection != null) {
            if (selection instanceof SlotHandle && ((SlotHandle)selection).getElementHandle() instanceof ReportDesignHandle) {
                selection = ((SlotHandle)selection).getElementHandle();
            }
            CommandUtils.setVariable("SelectionHandler.Section", selection);
        }
        try {
            try {
                CommandUtils.executeCommand("org.eclipse.birt.report.designer.ui.command.reloadCssStyleCommand", null);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                CommandUtils.removeVariable("SelectionHandler.Section");
            }
        }
        finally {
            CommandUtils.removeVariable("SelectionHandler.Section");
        }
    }
}

