/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.ReportFigureUtilities;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListBandEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportShowFigure;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class ListBandControlFigure
extends Figure {
    public static final Dimension CONTROL_SIZE = new Dimension(88, 19);
    private static final Insets DISPLAY_MARGIN = new Insets(15);
    private static final String TOOLTIP_LIST_DETAIL = Messages.getString((String)"ListBandControlFigure.tooltip.ListDetail");
    private static final String TOOLTIP_LIST_HEADER = Messages.getString((String)"ListBandControlFigure.tooltip.ListHeader");
    private static final String TOOLTIP_LIST_FOOTER = Messages.getString((String)"ListBandControlFigure.tooltip.ListFooter");
    private static final String TOOLTIP_GROUP_HEADER = Messages.getString((String)"ListBandControlFigure.tooltip.GroupHeader");
    private static final String TOOLTIP_GROUP_FOOTER = Messages.getString((String)"ListBandControlFigure.tooltip.GroupFooter");
    private ListBandEditPart owner;

    public ListBandControlFigure(ListBandEditPart owner) {
        this.owner = owner;
        String tp = this.getTooltipText();
        if (tp != null) {
            Label tooltip = new Label(tp);
            tooltip.setBorder((Border)new MarginBorder(0, 2, 0, 2));
            this.setToolTip((IFigure)tooltip);
        }
    }

    protected void paintFigure(Graphics graphics) {
        graphics.setForegroundColor(ReportColorConstants.ShadowLineColor);
        graphics.setLineStyle(1);
        graphics.drawRectangle(this.getBounds().getCopy().shrink(2, 1));
        graphics.setBackgroundColor(ReportColorConstants.ListControlFillColor);
        graphics.fillRectangle(this.getBounds().getCopy().shrink(3, 2));
    }

    private String getTooltipText() {
        int type = ((ListBandProxy)this.owner.getModel()).getType();
        switch (type) {
            case 1: {
                return TOOLTIP_LIST_HEADER;
            }
            case 3: {
                return TOOLTIP_LIST_DETAIL;
            }
            case 5: {
                return TOOLTIP_LIST_FOOTER;
            }
            case 2: {
                return TOOLTIP_GROUP_HEADER;
            }
            case 4: {
                return TOOLTIP_GROUP_FOOTER;
            }
        }
        return null;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension dimension = new Dimension(0, ListBandControlFigure.CONTROL_SIZE.height);
        List list = this.getChildren();
        int i = 0;
        while (i < list.size()) {
            Figure figure = (Figure)list.get(i);
            dimension.width += figure.getSize().width;
            ++i;
        }
        return dimension;
    }

    public static class ListBandControlVisible
    extends Figure
    implements MouseListener {
        private ListBandEditPart owner;
        private boolean state = true;

        public ListBandControlVisible(ListBandEditPart owner) {
            this.setBounds(new Rectangle(0, 0, 20, 19));
            this.owner = owner;
            this.addMouseListener(this);
        }

        public void mousePressed(MouseEvent me) {
            this.state = !this.state;
            ListBandControlVisible parent = this;
            while ((parent = parent.getParent()) != null) {
                if (!(parent instanceof ReportShowFigure)) continue;
                ((ReportShowFigure)((Object)parent)).setShowing(this.state);
                this.getOwner().markDirty(true);
                break;
            }
        }

        public void mouseReleased(MouseEvent me) {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle rect = this.getBounds().getCopy().shrink(6, 6);
            graphics.fillRectangle(rect);
            ListBandControlVisible parent = this;
            while ((parent = parent.getParent()) != null) {
                if (!(parent instanceof ReportShowFigure)) continue;
                this.state = ((ReportShowFigure)((Object)parent)).isControlShowing();
                break;
            }
            ReportFigureUtilities.paintExpandHandle(graphics, 8, this.getBounds().getCenter(), !this.state);
        }

        protected ListBandEditPart getOwner() {
            return this.owner;
        }
    }

    public static class ListControlDisplayNameFigure
    extends Figure {
        private ListBandEditPart owner;
        private String text = "";

        public ListControlDisplayNameFigure(ListBandEditPart owner) {
            this.owner = owner;
            this.text = ((ListBandProxy)owner.getModel()).getDisplayName();
            Font font = this.getFont();
            Shell sl = null;
            GC gc = null;
            if (font == null) {
                sl = new Shell();
                gc = new GC((Drawable)sl);
                font = gc.getFont();
            }
            int width = FigureUtilities.getTextWidth((String)this.text, (Font)font);
            if (gc != null) {
                gc.dispose();
            }
            if (sl != null) {
                sl.dispose();
            }
            this.setBounds(new Rectangle(35, 0, width + DISPLAY_MARGIN.right, 19));
            this.setBorder((Border)new MarginBorder(8, 0, 0, 0));
        }

        public ListBandEditPart getOwner() {
            return this.owner;
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle rect = this.getClientArea().getCopy();
            graphics.setForegroundColor(ReportColorConstants.DarkShadowLineColor);
            graphics.drawString(this.text, rect.x, rect.y - 6);
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    public static class ListControlMenuFigure
    extends AbstractHandle {
        public ListControlMenuFigure(GraphicalEditPart owner, Locator loc) {
            super(owner, loc);
            this.setBounds(new Rectangle(55, 0, 18, 19));
        }

        protected void paintFigure(Graphics graphics) {
            graphics.setForegroundColor(ColorConstants.black);
            Point center = this.getBounds().getCenter();
            int height = 5;
            center.y -= height / 2;
            ReportFigureUtilities.paintDoubleArrow(graphics, height, center);
            center.x += 2;
            center.y += height + 2;
            graphics.setBackgroundColor(ColorConstants.black);
            ReportFigureUtilities.paintTriangle(graphics, 4, center);
        }

        protected DragTracker createDragTracker() {
            return new MenuTracker((EditPart)this.getOwner());
        }

        public void addNotify() {
        }
    }

    public static class ListIconFigure
    extends Figure {
        private ListBandEditPart owner;

        public ListIconFigure(ListBandEditPart owner) {
            this.owner = owner;
            this.setBounds(new Rectangle(17, 2, 16, 16));
        }

        public ListBandEditPart getOwner() {
            return this.owner;
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle rect = this.getClientArea().getCopy();
            graphics.drawImage(this.getImage(), rect.x, rect.y);
        }

        private Image getImage() {
            int type = ((ListBandProxy)this.getOwner().getModel()).getType();
            String imageType = null;
            switch (type) {
                case 1: {
                    imageType = "Header";
                    break;
                }
                case 3: {
                    imageType = "Details";
                    break;
                }
                case 5: {
                    imageType = "Footer";
                    break;
                }
                case 2: {
                    imageType = "Group Header";
                    break;
                }
                case 4: {
                    imageType = "Group Footer";
                }
            }
            return ReportPlatformUIImages.getImage(imageType);
        }
    }

    private static class MenuTracker
    extends DragEditPartsTracker {
        public MenuTracker(EditPart sourceEditPart) {
            super(sourceEditPart);
        }

        protected boolean handleButtonUp(int button) {
            boolean bool = super.handleButtonUp(button);
            if (button == 1) {
                this.getSourceEditPart().getViewer().getContextMenu().getMenu().setVisible(true);
            }
            return bool;
        }
    }
}

