/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.internal.ui.command.CommandUtils;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ContextSelectionAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.extensions.IReportItemViewProvider;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.ui.IWorkbenchPart;

public class CreateChartAction
extends ContextSelectionAction {
    private static final String TEXT = Messages.getString((String)"CreateChartAction.text");
    public static final String ID = "org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.CreateChartAction";

    public CreateChartAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText(TEXT);
    }

    protected boolean calculateEnabled() {
        List selected = this.getSelectedObjects();
        if (selected.size() != 1 || !(selected.get(0) instanceof EditPart)) {
            return false;
        }
        EditPart part = (EditPart)selected.get(0);
        Object model = part.getModel();
        if (!(model instanceof ReportItemHandle) && model instanceof IAdaptable) {
            model = ((IAdaptable)model).getAdapter(DesignElementHandle.class);
        }
        if (!(model instanceof ReportItemHandle) || DEUtil.isReferenceElement((DesignElementHandle)((ReportItemHandle)model))) {
            return false;
        }
        Object[] objs = ElementAdapterManager.getAdapters(model, IReportItemViewProvider.class);
        if (objs == null || objs.length > 1) {
            return false;
        }
        return ((ReportItemHandle)model).getViews().size() == 0;
    }

    public void run() {
        try {
            CommandUtils.executeCommand("org.eclipse.birt.report.designer.ui.command.CreateChartViewCommand", null);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

